console.log("handlers.js", "top");
var fs = require("fs");
var path = require("path");
const url = require('url');
const server = require("./server.js");

/*
// Get the Google bootstrap script that converts goog.require() as node's require()
require("../../third-party/google/closure-library/closure/goog/bootstrap/nodejs.js");

getSafeElementById = function getSafeElementById(anID) 
{
    return null;
}

///////CTAT Object vars/////
inNode = true;

//Other dependencies
var xml	= require("./libXML.js");

XMLSerializer	= require("xmldom").XMLSerializer;
XMLHttpRequest	= require('xhr2');
XMLParser	= require("xmldom").DOMParser;
Entities	= require('html-entities').XmlEntities;

require("../../src/polyfills.js");
require("../../src/set.js");
require("../../src/CTAT/CTATConfig.js");

var interfaceObject, tutorObject, interfaceMessages, tutorMessages;

interfaceObject = null;

tutorObject = null;

interfaceMessages = [];

tutorMessages = [];

sendToTutor = function(message) {
  console.log("sendToTutor(" + message + ") tutorObject " + tutorObject);
  if (tutorObject) {
	return tutorObject.receiveFromInterface(message);
  } else {
	return tutorMessages.push(message);
  }
};

registerTutor = function(tutor) {
  tutorObject = tutor;
  if (tutor)
  {
	tutorMessages.forEach(sendToTutor);
    tutorMessages = [];
  }
};

require("../../third-party/google/closure-library/closure/goog/base.js");
require("../../CTAT-deps.js");

goog.require('CTATGlobalFunctions');
goog.require('CTATExampleTracer');

customconsole = null;

useDebuggingBasic = true;
useDebugging = true;

var exampleTracer = new CTATExampleTracer();
//Request handlers go here

var httpResponse;
var response = "";

alert = function(txt)
{
    ctatdebug(txt);
}

ctatdebug = function(txt)
{
    console.log(txt);
}

sendToTutor = function(aMessage)
{
    console.log("sendToTutor() aMessage", aMessage);
    exampleTracer.receiveFromInterface(aMessage);
}

sendToInterface = function(reply,endOfTransaction)
{
    response+=reply;
    response+="\n";
    if(!endOfTransaction)
    {        
        return;
    }
    httpResponse.write(response);
    httpResponse.end();
    response = "";
    console.log("Reply:   "+reply);    
}

function handleSendToTutor(response, data)
{
    console.log("Request: "+data);    
    httpResponse = response;
    exampleTracer.receiveFromInterface(data); 
    //receiveFromTutor("Reply to "+data);    // will be sendToTutor()
}
*/

// buggy logger
function logJunker(response, data) {
    if (!(/done.*ButtonPressed/i.test(data))) {
	logServer(response, data);
    }
}

//DataShop log server
function logServer(response, data)
{
    console.log("in logServer data", data);
    const logDir = "logServer";
    const prefix = "LogService-";
    var fileName = String(data).match(/session_id=["]([^"]+)["]/);
    var fullName = logDir+path.sep+prefix+(fileName?fileName[1]:"NoSessionId")+".xml";
    var status = 200;
    var reply = 'status=success';
    var fd = null;
    try {
	fs.mkdirSync(logDir, {recursive: true});  // try local ./logServer
	fd = fs.openSync(fullName, 'a');
	console.log("append: fd", fd, "fullName", fullName);
	fs.appendFileSync(fd, "\n"+Date()+"\n"+data+"\n", 'utf8');
    } catch (e) {
	console.trace(e);
	status = 500;
	reply = String(e);
    } finally {
	if (Number.isInteger(fd)) {
	    console.log("close: fd", fd);
	    fs.closeSync(fd);
	}
    }
    response.writeHead(status,
	{
	    'Content-Length': Buffer.byteLength(reply,'utf8'),
	    'Content-Type': 'text/plain'
	});
    response.end(reply);
/*
    fs.promises.open(path, "a", 0o666)
	.then((fh)=>{console.log("append: path", path); return fh.appendFile(String(data))})
	.then((ev)=>{console.log("close: ev", ev); return fh.close()})
	.catch((e)=>{status = 500; reply = String(e); return e})
	.then((ev)=>{response.writeHead(status,
			{
			    'Content-Length': Buffer.byteLength(reply,'utf8'),
			    'Content-Type': 'text/plain'
			});
		     response.end(reply)});
*/
}

var lastSave="";

function save(response, data)
{
    console.log("in save; data", data);
    var problemState = String(data).match(/.*&problem_state=(.*)$/);
    if(problemState)
	lastSave=decodeURIComponent(problemState[1]);
    console.log("in save; lastSave", lastSave, "problemState", problemState && problemState[1]);
    response.write('status=success\nlastSave.length = '+lastSave.length);
    response.end();
}

function restore(response, data)
{
    console.log("in restore; data", data);
    response.write(lastSave);
    response.end();
}

//Echoes recieved data back to client    
function echo(response,data)
{   
    response.write(data);
    response.end();
    console.log("Data Echoed.");    
}

function writeFile(response, data, request)
{
    const url = new URL(request.url, "http://localhost:"+server.port);
    const path = url.searchParams && url.searchParams.get("path");
    const contents = String(data);
    fs.promises.writeFile(path, contents)
	.then((e)=>{response.write('result='+e+'&contents.length='+contents.length+'&status=success'); response.end(); return e})
	.catch((e)=>{response.writeHead(500, "Error: "+e); response.end(); return e});
}

//exports.handleSendToTutor = handleSendToTutor;
exports.echo = echo;
exports.logJunker = logJunker;
exports.logServer = logServer;
exports.save = save;
exports.restore = restore;
exports.writeFile = writeFile;
//xports.sendToInterface = sendToInterface;
