//Route URL requests to handlers

const path = require('path');
var fs = require("fs");

var contentTypesByExtension = {
    ".js":   "text/javascript",
    ".css":  "text/css",
    ".png":  "image/png",
    ".jpg":  "image/jpeg",
    ".jpeg": "image/jpeg",
    ".gif":  "image/gif"
};

function route(handle, pathname, response, data, request) {

    console.log("About to route a request for " + pathname);
    
    //check if path has a handler function
    if (typeof handle[pathname] === 'function') 
    {
        handle[pathname](response, data, request);
        return;
    }
    
    //Check if path points to a valid file or directory
    pathname = decodeURIComponent(pathname.slice(1, pathname.length));
    fs.open(pathname, function(err, fd) {
        try {
            if(err) {
                response.writeHead(404, {"Content-Type": "text/plain"});
                response.write("404 File or Directory Not Found : \n" + pathname);
                response.write("\nError "+err.code+" "+err.message);
                response.end();
                return;
            }
            let stats = fs.statSync(pathname);
            if(stats.isDirectory())
                pathname += '/index.html';
            let file = fs.readFileSync(pathname, "binary");
            //TODO: Add MIME information
            let contentType = contentTypesByExtension[path.extname(pathname)];
            if (contentType) {
                response.setHeader("Content-Type", contentType);
            }
            response.setHeader("Content-Length", stats.size);
            response.setHeader("Last-Modified", stats.mtime);
            response.writeHead(200);
            response.write(file, "binary");
            response.end();
        } catch (e) {
            console.log("Error on request for", pathname, ":", e);
            response.writeHead(500, {"Content-Type": "text/plain"});
            response.write(err + "\n");
            response.end();
        } finally {
            try {
                (fd >= 0) && fs.closeSync(fd);
            } catch (ce) {
                console.log("Error closing fd", fd, "pathname", pathname);
            }
        }
    });
}


exports.route = route;
