var http = require("http");
var url = require("url");
var router = require("./router.js");
var handlers = require("./handlers.js");
var queryData;

const port=8888;
exports.port = port;

//Bind handler functions
var handle = {};
handle["/echo"] = handlers.echo;
handle["/parsexml"] = handlers.parsexml;
handle["/test"] = handlers.test;
handle["/pushsiaxml"] = handlers.pushSIAXML;
handle["/sendToTutor"] = handlers.handleSendToTutor;
handle["/logServer"] = handlers.logServer;
handle["/logJunker"] = handlers.logJunker;
handle["/save"] = handlers.save;
handle["/restore"] = handlers.restore;
handle["/writeFile"] = handlers.writeFile;

function onRequest(request, response) {
    queryData = "";

    var pathname = url.parse(request.url).pathname;
    console.log("Request from", request.socket.remoteAddress, "for", pathname);
    if(!/::1|127[.]0[.]0[.]1/.test(request.socket.remoteAddress)) {
	let err = "Unauthorized remoteAddress: "+request.socket.remoteAddress;
	console.log(err);
	request.destroy(new Error(err));
	return;
    }

    request.on('data', function(data) {
        queryData += data;
    });

    request.on('end', function() {

        response.setHeader('Access-Control-Allow-Origin', '*');
        response.setHeader('Access-Control-Allow-Headers', 'ctatsession, Content-Type, Accept');
        response.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS');
        response.setHeader('Access-Control-Max-Age', '1728000');

	try {
            router.route(handle, pathname, response, queryData, request);
	} catch(e) {
	    console.log("Error from router", e);
	    request.destroy(e);
	}
    });
}

http.createServer(onRequest).listen(port);
console.log("Server listening on port "+port);
