/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.pact.Utilities.trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UnknownFormatConversionException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.w3c.dom.Node;

public class CTATBase {
    public static PrintStream outStream = System.out;
    public static PrintStream errStream = System.err;
    private static final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    private String className = this.getClass().getSimpleName();
    private String classType = this.getClass().getSimpleName();
    private String instanceName = "";
    private String name = "";

    public CTATBase() {
        this.setClassName("CTATBase");
    }

    protected String removeGarbage(String in) {
        return in.replace("\\n", "");
    }

    public byte[] inputStreamToByteArray(InputStream inStream) {
        InputStreamReader in = new InputStreamReader(inStream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int next = 0;
        try {
            next = inStream.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (next > -1) {
            baos.write(next);
            try {
                next = in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] result = baos.toByteArray();
        try {
            baos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setClassName(String aName) {
        this.className = aName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassType(String aName) {
        this.classType = aName;
    }

    public String getClassType() {
        return this.classType;
    }

    public String getCurrentDate() {
        return df.format(new Date());
    }

    protected String getClassOpen() {
        return "<" + this.getClassType() + ">";
    }

    protected String getClassOpen(String aName) {
        return "<" + this.getClassType() + " name=\"" + aName + "\">";
    }

    protected String getClassClose() {
        return "</" + this.getClassType() + ">";
    }

    protected Element getClassElement() {
        return new Element(this.getClassType());
    }

    protected Element getClassElement(String aName) {
        Element newElement = new Element(this.getClassType());
        newElement.setAttribute("name", aName);
        return newElement;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClassOpen() + "<name>" + this.getName() + "</name>" + this.getClassClose());
        return buffer.toString();
    }

    public Element toElement() {
        Element newElement = this.getClassElement();
        Element nameElement = new Element("name");
        nameElement.setText(this.getName());
        newElement.addContent((Content)nameElement);
        return newElement;
    }

    public void showNodeType(Node a_node) {
        if (a_node == null) {
            this.debug("Error: provided node is null");
            return;
        }
        switch (a_node.getNodeType()) {
            case 2: {
                this.debug("Node type: The node is an Attr.");
                break;
            }
            case 4: {
                this.debug("Node type: The node is a CDATASection.");
                break;
            }
            case 8: {
                this.debug("Node type: The node is a Comment.");
                break;
            }
            case 11: {
                this.debug("Node type: The node is a DocumentFragment.");
                break;
            }
            case 9: {
                this.debug("Node type: The node is a Document.");
                break;
            }
            case 10: {
                this.debug("Node type: The node is a DocumentType.");
                break;
            }
            case 1: {
                this.debug("Node type: The node is an Element.");
                break;
            }
            case 6: {
                this.debug("Node type: The node is an Entity.");
                break;
            }
            case 5: {
                this.debug("Node type: The node is an EntityReference.");
                break;
            }
            case 12: {
                this.debug("Node type: The node is a Notation.");
                break;
            }
            case 7: {
                this.debug("Node type: The node is a ProcessingInstruction.");
                break;
            }
            case 3: {
                this.debug("Node type: The node is a Text node.");
            }
        }
    }

    public void fromString(String xml) {
        this.debug("fromString ()");
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(xml));
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Element root = doc.getRootElement();
        this.fromXML(root);
    }

    public void fromXML(Element root) {
        this.debug("fromXML ()");
    }

    public static void debug(String aClass, String s) {
        if (!trace.getDebugCode("ll")) {
            return;
        }
        if (outStream == null) {
            return;
        }
        String aString = String.format("(%b) [%s] [%d] <%s> %s\n", trace.getDebugCode("ll"), df.format(new Date()), ++CTATLink.debugLine, aClass, s);
        outStream.print(aString);
        outStream.flush();
        if (CTATLink.logSnooper != null) {
            CTATLink.logSnooper.addLine(aString);
        }
    }

    public void debug(String s) {
        if (!trace.getDebugCode("ll")) {
            return;
        }
        if (outStream == null) {
            return;
        }
        String aString = "";
        String aDateString = df.format(new Date());
        try {
            aString = String.format("(" + trace.getDebugCode("ll") + ") [%s] [%d] <" + this.className + "> %s\n", aDateString, ++CTATLink.debugLine, s);
        }
        catch (UnknownFormatConversionException fe) {
            System.out.println("Unknown format conversion exception for: " + this.className + ", " + aDateString + ", " + CTATLink.debugLine + ", " + s);
        }
        outStream.print(aString);
        outStream.flush();
        if (CTATLink.logSnooper != null) {
            CTATLink.logSnooper.addLine(aString);
        }
    }

    public static void error(String aClass, String s) {
        if (outStream == null) {
            return;
        }
        String aString = String.format("[%s] [%d] <%s> %s\n", df.format(new Date()), ++CTATLink.debugLine, aClass, s);
        errStream.print(aString);
        errStream.flush();
        if (CTATLink.logSnooper != null) {
            CTATLink.logSnooper.addLine(aString);
        }
    }

    public void error(String s) {
        if (outStream == null) {
            return;
        }
        String aString = "";
        String aDateString = df.format(new Date());
        try {
            aString = String.format("[%s] [%d] <" + this.className + "> %s\n", aDateString, ++CTATLink.debugLine, s);
        }
        catch (UnknownFormatConversionException fe) {
            System.out.println("Unknown format conversion exception for: " + this.className + ", " + aDateString + ", " + CTATLink.debugLine + ", " + s);
        }
        errStream.print(aString);
        errStream.flush();
        if (CTATLink.logSnooper != null) {
            CTATLink.logSnooper.addLine(aString);
        }
    }

    public void debugStack(String s, Throwable e) {
        if (!CTATLink.printDebugMessages) {
            return;
        }
        if (outStream == null) {
            return;
        }
        this.debug(s);
        e.printStackTrace(outStream);
        outStream.flush();
    }

    public static PrintStream getOutStream() {
        return outStream;
    }

    public static PrintStream getErrStream() {
        return errStream;
    }

    public static void setOutStream(PrintStream outStream) {
        CTATBase.outStream = outStream;
    }

    public static void setErrStream(PrintStream errStream) {
        CTATBase.errStream = errStream;
    }
}

