/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATMilestone;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CTATMilestoneManager
extends CTATBase
implements Serializable {
    private static final long serialVersionUID = 7061551116978267821L;
    private ArrayList<CTATMilestone> milestones = null;

    public CTATMilestoneManager() {
        this.setClassName("CTATMilestoneManager");
        this.debug("CTATMilestoneManager ()");
        this.milestones = new ArrayList();
    }

    public void initialize() {
        this.debug("initialize ()");
        CTATMilestone milestone = null;
        boolean success = this.readMilestoneXML(new File(CTATLink.etc + System.getProperty("file.separator") + "milestones.xml"));
        if (!success) {
            this.debug("Could not read etc/milestones.xml. Using default hard-coded milestones.");
            milestone = this.addMilestone("Scale to the Chief", CTATMilestone.TYPESKILL, "Master the skill 'Find distance using scale factor' in Proportional Distance", "find-dist-using-sf", "basics.png");
            milestone.setTest("skill:rim-nxt-propdist-find-dist-using-sf");
            milestone = this.addMilestone("Going the Distance", CTATMilestone.TYPESKILL, "Master the skill 'Find distance using unit rate' in Proportional Distance", "find-dist-using-ur", "basics.png");
            milestone.setTest("skill:rim-nxt-propdist-find-dist-using-ur");
            milestone = this.addMilestone("You've Got the Power", CTATMilestone.TYPESKILL, "Master the skill 'Find power using scale factor' in Proportional Speed", "find-power-using-sf", "basics.png");
            milestone.setTest("skill:rim-nxt-propspeed-find-power-using-sf");
            milestone = this.addMilestone("Powered Up", CTATMilestone.TYPESKILL, "Master the skill 'Find power using unit rate' in Proportional Speed", "find-power-using-ur", "basics.png");
            milestone.setTest("skill:rim-nxt-propspeed-find-power-using-ur");
            milestone = this.addMilestone("NXT Basic Training", CTATMilestone.TYPEPSET, "RIM-BASICS-OPERATION", "Master the skill 'Find distance using scale factor' in Proportional Distance", "traning_op_MP.png");
            milestone.setTest("assignment_completed:nxt_operation");
            milestone = this.addMilestone("NXT Move Block Programmer", CTATMilestone.TYPESKILL, "Complete the 'NXT Move Block' Basics lesson", "RIM-BASICS-MOVE", "traning_move_MP.png");
            milestone.setTest("assignment_completed:nxt_move_block");
            milestone = this.addMilestone("NXTrained and Ready", CTATMilestone.TYPEMETA, "Complete both Basics lesson sequences", "RIM-BASICS-COMPLETE", "medium_basics.png");
            milestone.setTest("meta:RIM-BASICS-OPERATION:and:RIM-BASICS-MOVE");
            milestone = this.addMilestone("To Ruler Them All", CTATMilestone.TYPESKILL, "Complete the 'Measuring Distance' lesson", "RIM-MEASDIST-COMPLETE", "measdist_mp.png");
            milestone.setTest("assignment_completed:measuring_distance");
            milestone = this.addMilestone("Turn Measurer Minor", CTATMilestone.TYPESKILL, "Complete the 'Small Turns' portion of 'Measuring Turns'", "RIM-MEASTURN-SMALLTURN", "basics.png");
            milestone.setTest("problemset_completed:measturn2");
            milestone = this.addMilestone("Turn Measurer Major", CTATMilestone.TYPESKILL, "Complete the 'Measuring Turns', including both small and large turns", "RIM-MEASTURN-COMPLETE", "measturn_mp.png");
            milestone.setTest("assignment_completed:measuring_turns");
            milestone = this.addMilestone("Distance Over Time", CTATMilestone.TYPESKILL, "Complete the 'What is Speed?' portion of 'Measuring Speed'", "RIM-MEASSPEED-WHATISSPEED", "basics.png");
            milestone.setTest("problemset_completed:measspeed2");
            milestone = this.addMilestone("Speed Limitless", CTATMilestone.TYPESKILL, "Complete the 'Measuring Speed' lesson", "RIM-MEASSPEED-COMPLETE", "measspeed_mp.png");
            milestone.setTest("assignment_completed:measuring_speed");
            milestone = this.addMilestone("Measurably Accomplished", CTATMilestone.TYPEMETA, "Complete both main Measurement lessons", "RIM-MEASUREMENT-COMPLETE", "medium_meas.png");
            milestone.setTest("meta:RIM-MEASDIST-COMPLETE:and:RIM-MEASTURN-COMPLETE");
            milestone = this.addMilestone("The nth Degree", CTATMilestone.TYPESKILL, "Master the skill 'Find angle using unit rate'", "RIM-PROPTURNRATE-FIND-ANGLE", "basics.png");
            milestone.setTest("skill:rim-nxt-propturn-find-angle-using-ur");
            milestone = this.addMilestone("Scaling Spinning", CTATMilestone.TYPESKILL, "Master the skill 'Find angle using scale factor'", "RIM-PROPTURNSCALE-FIND-ANGLE", "basics.png");
            milestone.setTest("skill:rim-nxt-propturn-find-angle-using-sf");
            milestone = this.addMilestone("To Boldly Roll", CTATMilestone.TYPESKILL, "Master the skill 'Find rotations using unit rate' in Proportional Distance", "RIM-PROPDISTRATE-FIND-ROTS", "basics.png");
            milestone.setTest("skill:rim-nxt-propdist-find-rots-using-ur");
            milestone = this.addMilestone("Roll with the Times", CTATMilestone.TYPESKILL, "Master the skill 'Find rotations using scale factor' in Proportional Distance", "RIM-PROPDISTSCALE-FIND-ROTS", "basics.png");
            milestone.setTest("skill:rim-nxt-propdist-find-rots-using-sf");
            milestone = this.addMilestone("One Good Turn Deserves Another", CTATMilestone.TYPESKILL, "Master the skill 'Find rotations using unit rate' in Proportional Turns", "RIM-PROPTURNRATE-FIND-ROTS", "basics.png");
            milestone.setTest("skill:rim-nxt-propturn-find-rots-using-ur");
            milestone = this.addMilestone("A Turn for the Better", CTATMilestone.TYPESKILL, "Master the skill 'Find rotations using scale factor' in Proportional Turns", "RIM-PROPTURNSCALE-FIND-ROTS", "basics.png");
            milestone.setTest("skill:rim-nxt-propturn-find-rots-using-sf");
            milestone = this.addMilestone("Ratio of Rate", CTATMilestone.TYPESKILL, "Master the skill 'Find speed using unit rate' in Proportional Speed", "RIM-PROPSPEEDRATE-FIND-SPEED", "basics.png");
            milestone.setTest("skill:rim-nxt-propspeed-find-speed-using-ur");
            milestone = this.addMilestone("Fast Times", CTATMilestone.TYPESKILL, "Master the skill 'Find speed using scale factor' in Proportional Speed", "RIM-PROPSPEEDSCALE-FIND-SPEED", "basics.png");
            milestone.setTest("skill:rim-nxt-propspeed-find-speed-using-sf");
            milestone = this.addMilestone("Proportional Distance: Rate", CTATMilestone.TYPESKILL, "Complete the 'Proportional Distance Rate' lesson", "RIM-PROPDIST-RATE", "ur_propdist.png");
            milestone.setTest("assignment_completed:proportional_distance_rate");
            milestone = this.addMilestone("Proportional Distance: Scale", CTATMilestone.TYPESKILL, "Complete the 'Proportional Distance Scale' lesson", "RIM-PROPDIST-SCALE", "sf_propdist.png");
            milestone.setTest("assignment_completed:proportional_distance_scale");
            milestone = this.addMilestone("Proportional Turns: Rate", CTATMilestone.TYPESKILL, "Complete the 'Proportional Turns Rate' lesson", "RIM-PROPTURN-RATE", "ur_propturn.png");
            milestone.setTest("assignment_completed:proportional_turns_rate");
            milestone = this.addMilestone("Proportional Turns: Scale", CTATMilestone.TYPESKILL, "Complete the 'Proportional Turns Scale' lesson", "RIM-PROPTURN-SCALE", "sf_propturn.png");
            milestone.setTest("assignment_completed:proportional_turns_scale");
            milestone = this.addMilestone("Proportional Speed: Rate", CTATMilestone.TYPESKILL, "Complete the 'Proportional Speed Rate' lesson", "RIM-PROPSPEED-RATE", "ur_propspeed.png");
            milestone.setTest("assignment_completed:proportional_speed_rate");
            milestone = this.addMilestone("Proportional Speed: Scale", CTATMilestone.TYPESKILL, "Complete the 'Proportional Speed Scale' lesson", "RIM-PROPSPEED-SCALE", "sf_propspeed.png");
            milestone.setTest("assignment_completed:proportional_speed_scale");
            milestone = this.addMilestone("Distance Relationship", CTATMilestone.TYPEMETA, "Complete one investigation into the proportional relationship between Motor Rotations and Distance", "RIM-PROPDIST-SINGLE", "propdist_1invest.png");
            milestone.setTest("meta:RIM-PROPDIST-RATE:or:RIM-PROPDIST-SCALE");
            milestone = this.addMilestone("Distance Mastery", CTATMilestone.TYPEMETA, "Complete both investigations into the proportional relationship between Motor Rotations and Distance", "RIM-PROPDIST-BOTH", "propdist_2invest.png");
            milestone.setTest("meta:RIM-PROPDIST-RATE:and:RIM-PROPDIST-SCALE");
            milestone = this.addMilestone("Turn, Turn, Turn", CTATMilestone.TYPEMETA, "Complete one investigation into the proportional relationship between Motor Rotations and Turn Angle", "RIM-PROPTURN-SINGLE", "propturn_1invest.png");
            milestone.setTest("meta:RIM-PROPTURN-RATE:or:RIM-PROPTURN-SCALE");
            milestone = this.addMilestone("Turn Mastery", CTATMilestone.TYPEMETA, "Complete both investigations into the proportional relationship between Motor Rotations and Turn Angle", "RIM-PROPTURN-BOTH", "propturn_2invest.png");
            milestone.setTest("meta:RIM-PROPTURN-RATE:and:RIM-PROPTURN-SCALE");
            milestone = this.addMilestone("Speed Control", CTATMilestone.TYPEMETA, "Complete one investigation into the proportional relationship between Motor Power and Speed", "RIM-PROPSPEED-SINGLE", "propspeed_1invest.png");
            milestone.setTest("meta:RIM-PROPSPEED-RATE:or:RIM-PROPSPEED-SCALE");
            milestone = this.addMilestone("Speed Mastery", CTATMilestone.TYPEMETA, "Complete both investigations into the proportional relationship between Motor Power and Speed", "RIM-PROPSPEED-BOTH", "propspeed_2invest.png");
            milestone.setTest("meta:RIM-PROPSPEED-RATE:and:RIM-PROPSPEED-SCALE");
            milestone = this.addMilestone("Highly Rated", CTATMilestone.TYPEMETA, "Complete all three investigations using Unit Rate", "RIM-PROP-3RATE", "ur_all.png");
            milestone.setTest("meta:RIM-PROPDIST-RATE:and:RIM-PROPTURN-RATE:and:RIM-PROPSPEED-RATE");
            milestone = this.addMilestone("Large Scale", CTATMilestone.TYPEMETA, "Complete all three investigations using Scale Factor", "RIM-PROP-3SCALE", "sf_all.png");
            milestone.setTest("meta:RIM-PROPDIST-SCALE:and:RIM-PROPTURN-SCALE:and:RIM-PROPSPEED-SCALE");
            milestone = this.addMilestone("Best of Both Worlds", CTATMilestone.TYPEMETA, "Complete both main investigations using both Unit Rate and Scale Factor", "RIM-PROP-FULL-MAIN", "prop_everything1.png");
            milestone.setTest("meta:RIM-PROPDIST-RATE:and:RIM-PROPDIST-SCALE:and:RIM-PROPTURN-RATE:and:RIM-PROPTURN-SCALE");
            milestone = this.addMilestone("Proportionally Prepared", CTATMilestone.TYPEMETA, "Complete both main investigations using both Unit Rate and Scale Factor", "RIM-PROPORTIONALITY-COMPLETE", "medium_prop.png");
            milestone.setTest("meta:RIM-PROPDIST-SINGLE:and:RIM-PROPTURN-SINGLE");
            milestone = this.addMilestone("Robot Algebra", CTATMilestone.TYPEMETA, "Complete Robots in Motion, demonstrating mastery of measurement and proportional reasoning concepts, and their application in robotics programming", "RIM-COMPLETE", "large_rem.png");
            milestone.setTest("meta:RIM-MEASUREMENT-COMPLETE:and:RIM-PROPORTIONALITY-COMPLETE");
        }
        this.checkMetaMilestones();
    }

    public boolean readMilestoneXML(File f) {
        this.debug("readMilestoneXML(" + f + ")");
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equalsIgnoreCase("milestones")) {
                return false;
            }
            NodeList docChildren = root.getChildNodes();
            int numDocChildren = docChildren.getLength();
            for (int i = 0; i < numDocChildren; ++i) {
                Node docChild = docChildren.item(i);
                if (docChild.getNodeType() != 1 || !docChild.getNodeName().equalsIgnoreCase("milestone")) continue;
                CTATMilestone milestone = new CTATMilestone();
                NodeList milestoneAttributes = docChild.getChildNodes();
                int numMilestoneAttributes = milestoneAttributes.getLength();
                for (int j = 0; j < numMilestoneAttributes; ++j) {
                    Node milestoneAttribute = milestoneAttributes.item(j);
                    if (milestoneAttribute.getNodeType() != 1) continue;
                    if (milestoneAttribute.getNodeName().equalsIgnoreCase("name")) {
                        milestone.setName(milestoneAttribute.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (milestoneAttribute.getNodeName().equalsIgnoreCase("type")) {
                        String typeString = milestoneAttribute.getFirstChild().getNodeValue();
                        if ("unset".equalsIgnoreCase(typeString)) {
                            milestone.setType(CTATMilestone.TYPEUNSET);
                            continue;
                        }
                        if ("time".equalsIgnoreCase(typeString)) {
                            milestone.setType(CTATMilestone.TYPETIME);
                            continue;
                        }
                        if ("skill".equalsIgnoreCase(typeString)) {
                            milestone.setType(CTATMilestone.TYPESKILL);
                            continue;
                        }
                        if ("meta".equalsIgnoreCase(typeString)) {
                            milestone.setType(CTATMilestone.TYPEMETA);
                            continue;
                        }
                        if ("pset".equalsIgnoreCase(typeString)) {
                            milestone.setType(CTATMilestone.TYPEPSET);
                            continue;
                        }
                        if (!"assn".equalsIgnoreCase(typeString)) continue;
                        milestone.setType(CTATMilestone.TYPEASSN);
                        continue;
                    }
                    if (milestoneAttribute.getNodeName().equalsIgnoreCase("description")) {
                        milestone.setDescription(milestoneAttribute.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (milestoneAttribute.getNodeName().equalsIgnoreCase("slug")) {
                        milestone.setSlug(milestoneAttribute.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (milestoneAttribute.getNodeName().equalsIgnoreCase("image")) {
                        milestone.setImage(milestoneAttribute.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (milestoneAttribute.getNodeName().equalsIgnoreCase("test")) {
                        milestone.setTest(milestoneAttribute.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!milestoneAttribute.getNodeName().equalsIgnoreCase("assignment")) continue;
                    milestone.setAssignment(milestoneAttribute.getFirstChild().getNodeValue());
                }
                this.milestones.add(milestone);
            }
            this.debug(this.milestones.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean isEmpty() {
        if (this.milestones.size() == 0) {
            return true;
        }
        return false;
    }

    public ArrayList<CTATMilestone> getMilestones() {
        return this.milestones;
    }

    public CTATMilestone getMilestone(String aName) {
        for (int i = 0; i < this.milestones.size(); ++i) {
            CTATMilestone test = this.milestones.get(i);
            if (!test.getSlug().equalsIgnoreCase(aName)) continue;
            return test;
        }
        return null;
    }

    public ArrayList<CTATMilestone> getMilestonesWithName(String aName) {
        ArrayList<CTATMilestone> list = new ArrayList<CTATMilestone>();
        for (int i = 0; i < this.milestones.size(); ++i) {
            CTATMilestone test = this.milestones.get(i);
            if (!test.getSlug().equalsIgnoreCase(aName)) continue;
            list.add(test);
        }
        return list;
    }

    public CTATMilestone addMilestone(String aName, int aType, String aDescription, String aSlug, String anImage) {
        this.debug("addMilestone (" + aName + ")");
        CTATMilestone tester = this.getMilestone(aName);
        if (tester == null) {
            tester = new CTATMilestone();
            tester.setName(aName);
            tester.setSlug(aSlug);
            tester.setType(aType);
            tester.setDescription(aDescription);
            tester.setImage(anImage);
            this.milestones.add(tester);
        }
        return tester;
    }

    public CTATMilestone addMilestone(String aName, int aType, String aDescription, String aSlug) {
        this.debug("addMilestone (" + aName + ")");
        CTATMilestone tester = this.getMilestone(aSlug);
        if (tester == null) {
            tester = new CTATMilestone();
            tester.setName(aName);
            tester.setSlug(aSlug);
            tester.setType(aType);
            tester.setDescription(aDescription);
            tester.setImage(aSlug);
        }
        return tester;
    }

    public CTATMilestone addMilesone(String aName, int aType, String aDescription, String aSlug, String anImage, String assignment) {
        CTATMilestone m = this.addMilestone(aName, aType, aDescription, aSlug, anImage);
        m.setAssignment(assignment);
        return m;
    }

    public ArrayList<CTATMilestone> checkAssignmentMilestone(String anAssignment) {
        this.debug("checkAssignmentMilestone (" + anAssignment + ")");
        anAssignment = anAssignment.replace(" ", "_");
        for (int j = 0; j < this.milestones.size(); ++j) {
            CTATMilestone milestone = this.milestones.get(j);
            if (milestone.getType() != CTATMilestone.TYPEASSN) continue;
            this.debug("Checking problem set milestone ...");
            if (milestone.getState() != CTATMilestone.WAITING) continue;
            this.debug("Found a waiting problem set milestone");
            if (!milestone.getTest().equalsIgnoreCase(anAssignment)) continue;
            this.debug("Matched a milestone to the problem set, marking accomplished");
            milestone.setState(CTATMilestone.ACCOMPLISHED);
        }
        this.checkMetaMilestones();
        return null;
    }

    public ArrayList<CTATMilestone> checkProblemSetMilestone(String aProblemSet) {
        this.debug("checkProblemSetMilestone (" + aProblemSet + ")");
        for (int j = 0; j < this.milestones.size(); ++j) {
            CTATMilestone milestone = this.milestones.get(j);
            if (milestone.getType() != CTATMilestone.TYPEPSET) continue;
            this.debug("Checking problem set milestone ...");
            if (milestone.getState() != CTATMilestone.WAITING) continue;
            this.debug("Found a waiting problem set milestone");
            if (!milestone.getTest().equalsIgnoreCase(aProblemSet)) continue;
            this.debug("Matched a milestone to the problem set, marking accomplished");
            milestone.setState(CTATMilestone.ACCOMPLISHED);
        }
        this.checkMetaMilestones();
        return null;
    }

    public ArrayList<CTATMilestone> checkSkillMilestone(String aSkillname, String currentAssignment) {
        this.debug("checkSkillMilestone (" + aSkillname + ", " + currentAssignment + ")");
        ArrayList<CTATMilestone> milestones = this.getMilestonesWithName(aSkillname);
        for (CTATMilestone aMilestone : milestones) {
            if (aMilestone == null || aMilestone.getType() != CTATMilestone.TYPESKILL) continue;
            String milestoneAssignment = aMilestone.getAssignment();
            if (currentAssignment != null && milestoneAssignment != null && !currentAssignment.equals(milestoneAssignment)) continue;
            if (aMilestone.getState() != CTATMilestone.WAITING) break;
            aMilestone.setState(CTATMilestone.ACCOMPLISHED);
            break;
        }
        this.checkMetaMilestones();
        return null;
    }

    public ArrayList<CTATMilestone> checkTimeMilestone(long aTime) {
        this.debug("checkTimeMilestone (" + aTime + ")");
        this.checkMetaMilestones();
        return null;
    }

    public ArrayList<CTATMilestone> checkMetaMilestones() {
        boolean somethingChanged;
        this.debug("checkMetaMilestones ()");
        do {
            somethingChanged = false;
            for (int i = 0; i < this.milestones.size(); ++i) {
                CTATMilestone tester;
                CTATMilestone milestone = this.milestones.get(i);
                if (milestone.getType() != CTATMilestone.TYPEMETA) continue;
                Boolean valid = true;
                ArrayList<String> targets = milestone.getChildren();
                if (milestone.getMetaType() == CTATMilestone.METAOR) {
                    valid = false;
                    for (int j = 0; j < targets.size(); ++j) {
                        tester = this.getMilestone(targets.get(j));
                        if (tester == null || tester.getState() != CTATMilestone.ACCOMPLISHED) continue;
                        valid = true;
                    }
                }
                if (milestone.getMetaType() == CTATMilestone.METAAND) {
                    valid = true;
                    for (int k = 0; k < targets.size(); ++k) {
                        tester = this.getMilestone(targets.get(k));
                        if (tester == null || tester.getState() == CTATMilestone.ACCOMPLISHED) continue;
                        valid = false;
                    }
                }
                if (!valid.booleanValue()) continue;
                this.debug("Found an accomplished meta milestone: " + milestone.getSlug());
                if (milestone.getState() == CTATMilestone.ACCOMPLISHED) continue;
                milestone.setState(CTATMilestone.ACCOMPLISHED);
                somethingChanged = true;
            }
        } while (somethingChanged);
        return null;
    }

    public String generateMilestoneHTML() {
        this.debug("generateMilestoneHTML (" + this.milestones.size() + ")");
        StringBuffer formatter = new StringBuffer();
        int total = 0;
        for (int j = 0; j < this.milestones.size(); ++j) {
            CTATMilestone milestone = this.milestones.get(j);
            if (milestone.getState() != CTATMilestone.ACCOMPLISHED) continue;
            ++total;
        }
        if (total == 0) {
            return null;
        }
        int counter = 0;
        for (int i = 0; i < this.milestones.size(); ++i) {
            CTATMilestone milestone = this.milestones.get(i);
            if (milestone.getState() != CTATMilestone.ACCOMPLISHED) continue;
            formatter.append("<div class=\"milestone\">");
            formatter.append("<div class=\"milestone-image\"><img alt=\"" + milestone.getSlug() + "\" src=\"http://localhost:8080/images/badges/" + milestone.getImage() + "\" /></div>");
            formatter.append("<div class=\"milestone-count\">");
            formatter.append("  Achievement Earned (" + (counter + 1) + "/" + total + ")");
            formatter.append("</div>");
            formatter.append("<div class=\"milestone-text\">");
            formatter.append("<div class=\"milestone-name\">");
            formatter.append(milestone.getName());
            formatter.append("</div>");
            formatter.append("<div class=\"milestone-description\">");
            formatter.append(milestone.getDescription());
            formatter.append("</div>");
            formatter.append("</div>");
            formatter.append("<div class=\"milestone-continue\">");
            if (counter + 1 < total) {
                formatter.append("<a href=\"#\" data-close=\"false\"><img alt=\"Continue\" src=\"http://localhost:8080/images/badges/continue-button.png\" /></a>");
            } else {
                formatter.append("<a href=\"#\" data-close=\"true\"><img alt=\"Close\" src=\"http://localhost:8080/images/badges/continue-button.png\" /></a>");
            }
            formatter.append("</div>");
            formatter.append("</div>");
            milestone.setState(CTATMilestone.SHOWN);
            ++counter;
        }
        this.debug(formatter.toString());
        return formatter.toString();
    }

    public void markShown() {
        this.debug("markShown()");
        for (CTATMilestone milestone : this.milestones) {
            if (milestone.getState() != CTATMilestone.ACCOMPLISHED) continue;
            milestone.setState(CTATMilestone.SHOWN);
        }
    }

    public String generateMilestoneXML() {
        this.debug("generateMilestoneXML ()");
        StringBuffer formatter = new StringBuffer();
        formatter.append("<?xml version='1.0' encoding=\"UTF-8\" ?>");
        formatter.append("<milestones>");
        for (int i = 0; i < this.milestones.size(); ++i) {
            CTATMilestone milestone = this.milestones.get(i);
            this.debug("Checking milestone: " + milestone.getSlug() + " has state: " + milestone.getState());
            if (milestone.getState() != CTATMilestone.ACCOMPLISHED) continue;
            formatter.append("<milestone>");
            formatter.append("<name>" + milestone.getName() + "</name>");
            formatter.append("<slug>" + milestone.getSlug() + "</slug>");
            formatter.append("<description>" + milestone.getDescription() + "</description>");
            formatter.append("<image>https://s3.amazonaws.com/cs2n-content-files-dev/milestones/traning_op_MP_original-7852dccaf650e3be3724fa599ab71dae.png?1346358835</image>");
            formatter.append("<achieved>1</achieved>");
            formatter.append("</milestone>");
            milestone.setState(CTATMilestone.SHOWN);
        }
        formatter.append("</milestones>");
        return formatter.toString();
    }

    public String getDebugString() {
        StringBuilder sb = new StringBuilder();
        for (CTATMilestone milestone : this.milestones) {
            sb.append(milestone.getName() + ": " + milestone.getDescription() + "\n");
        }
        return sb.toString();
    }
}

