/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATContentCache;
import edu.cmu.hcii.ctat.CTATFlashTutorShop;
import edu.cmu.hcii.ctat.CTATHTTPHandler;
import edu.cmu.hcii.ctat.CTATHTTPServer;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATTutorUpdater;
import edu.cmu.hcii.ctat.OnlineOfflineManager;
import edu.cmu.pact.Utilities.trace;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class LocalTSSystemTray
implements ActionListener {
    private static LocalTSSystemTray singleton = null;
    private static Object lock = new Object();
    private boolean displayed = false;
    private TrayIcon awtMain = null;
    private JFrame progframe = null;
    private boolean refreshing = false;
    private final String REFRESH = "Refresh local cache";
    private final String EXIT = "Exit Local TutorShop";
    private final String OFFLINE = "Use offline mode";
    private final String ONLINE = "Return to online mode";
    private final String RESTART = "Return to start page";
    private CTATHTTPServer wserver;

    private LocalTSSystemTray() {
    }

    public static LocalTSSystemTray getInstance() {
        if (singleton == null) {
            singleton = new LocalTSSystemTray();
        }
        return singleton;
    }

    public void setWebServer(CTATHTTPServer wserver) {
        this.wserver = wserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean display() {
        Object object = lock;
        synchronized (object) {
            boolean canUseAWT;
            if (this.displayed) {
                return true;
            }
            String version = System.getProperty("java.version");
            try {
                String[] versionSplit = version.split("\\.");
                int major = Integer.valueOf(versionSplit[0]);
                int minor = Integer.valueOf(versionSplit[1]);
                canUseAWT = major > 1 || minor >= 6 ? SystemTray.isSupported() : false;
            }
            catch (Exception e) {
                canUseAWT = false;
            }
            if (canUseAWT) {
                BufferedImage img;
                try {
                    img = ImageIO.read(new File("ctat-icon.ico"));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "Couldn't find tray icon image: ctat-icon.ico");
                    return false;
                }
                TrayIcon icon = new TrayIcon(img, "CTAT Local TutorShop");
                PopupMenu pm = new PopupMenu();
                pm.add("Refresh local cache");
                pm.add("Use offline mode");
                pm.add("Return to start page");
                pm.add("Exit Local TutorShop");
                pm.addActionListener(this);
                icon.setPopupMenu(pm);
                try {
                    SystemTray.getSystemTray().add(icon);
                    this.awtMain = icon;
                }
                catch (AWTException e) {
                    System.err.println(e);
                    return false;
                }
            }
            this.displayed = true;
            return true;
        }
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public boolean showBubbleIfPossible(String message) {
        return this.showBubbleIfPossible(null, message, TrayIcon.MessageType.INFO);
    }

    public boolean showBubbleIfPossible(String caption, String message, TrayIcon.MessageType type) {
        if (!this.displayed) {
            return false;
        }
        if (this.awtMain != null) {
            this.awtMain.displayMessage(caption, message != null ? message : "", type);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneRefreshing() {
        Object object = lock;
        synchronized (object) {
            if (!this.refreshing) {
                return;
            }
            if (this.progframe != null) {
                this.progframe.dispose();
                CTATContentCache.UI.refreshprogbar = null;
                this.progframe = null;
            }
            this.refreshing = false;
        }
    }

    public void showOfflineIcon() {
        if (this.awtMain != null) {
            BufferedImage img;
            try {
                img = ImageIO.read(new File("ctat-iconOFFLINE.ico"));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Couldn't find tray icon image: ctat-iconOFFLINE.ico");
                return;
            }
            this.awtMain.setImage(img);
            this.awtMain.setToolTip("CTAT Local TutorShop -- offline mode");
            MenuItem mi = this.awtMain.getPopupMenu().getItem(1);
            mi.setLabel("Return to online mode");
            mi.setActionCommand("Return to online mode");
        }
    }

    public void showOnlineIcon() {
        if (this.awtMain != null) {
            BufferedImage img;
            try {
                img = ImageIO.read(new File("ctat-icon.ico"));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Couldn't find tray icon image: ctat-icon.ico");
                return;
            }
            this.awtMain.setImage(img);
            this.awtMain.setToolTip("CTAT Local TutorShop");
            MenuItem mi = this.awtMain.getPopupMenu().getItem(1);
            mi.setLabel("Use offline mode");
            mi.setActionCommand("Use offline mode");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.handleMenuChoice(e.getActionCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMenuChoice(String choice) {
        if (choice.equals("Refresh local cache")) {
            Object object = lock;
            synchronized (object) {
                if (this.refreshing) {
                    return;
                }
                this.refreshing = true;
            }
            JFrame frame = new JFrame();
            frame.setAlwaysOnTop(true);
            frame.setVisible(true);
            frame.setVisible(false);
            int yesno = JOptionPane.showConfirmDialog(frame, "Are you sure you want to refresh the locally cached content?\nThis should be done only with a reliable and fast internet connection", "Refresh local cache?", 0);
            frame.dispose();
            if (yesno == 0) {
                this.progframe = new JFrame("TutorShop");
                JPanel panel = new JPanel();
                CTATContentCache.UI.refreshprogbar = new JProgressBar(0, 100);
                CTATContentCache.UI.refreshprogbar.setMinimumSize(new Dimension(320, 20));
                CTATContentCache.UI.refreshprogbar.setPreferredSize(new Dimension(320, 20));
                CTATContentCache.UI.refreshprogbar.setMaximumSize(new Dimension(5000, 20));
                CTATContentCache.UI.refreshprogbar.setString("Refreshing contents");
                CTATContentCache.UI.refreshprogbar.setStringPainted(true);
                CTATContentCache.UI.refreshprogbar.setValue(0);
                panel.add(CTATContentCache.UI.refreshprogbar);
                this.progframe.add(panel);
                this.progframe.setVisible(true);
                this.progframe.pack();
                new CTATTutorUpdater(null, null, null).updateContent();
            } else {
                this.refreshing = false;
            }
        } else if (choice.equals("Use offline mode")) {
            this.showOfflineIcon();
            OnlineOfflineManager.goOffline();
        } else if (choice.equals("Return to online mode")) {
            OnlineOfflineManager.goOnline();
            this.showOnlineIcon();
        } else if (choice.equals("Exit Local TutorShop")) {
            if (this.wserver != null && this.wserver.getHandler() instanceof CTATHTTPHandler) {
                ((CTATHTTPHandler)this.wserver.getHandler()).enqueuePushResponse(CTATHTTPHandler.PushResponse.Exit);
            }
            long ms = CTATLink.pushPollingInterval + 2000L;
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException ie) {
                trace.errStack("Error while sleeping " + ms + "ms awaiting poll for exit", ie);
            }
            System.exit(0);
        } else if (choice.equals("Return to start page")) {
            CTATFlashTutorShop.launchBrowser();
        }
    }
}

