/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.LocalTSSystemTray;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;

public class OnlineOfflineManager
extends CTATBase {
    private static List<Sendable> stuffToSend = new LinkedList<Sendable>();
    private static volatile boolean online = true;
    private static volatile boolean shouldRemainOnline = false;
    private static Thread stuffSender = null;

    public OnlineOfflineManager() {
        this.setClassName("OnlineOfflineManager");
        this.debug("OnlineOfflineManager ()");
    }

    public static synchronized void goOnline() {
        LocalTSSystemTray.getInstance().showOnlineIcon();
        online = true;
        if (!(stuffToSend.isEmpty() || stuffSender != null && stuffSender.isAlive())) {
            stuffSender = new StuffSender();
            stuffSender.start();
        }
    }

    public static synchronized void goOffline() {
        if (!shouldRemainOnline) {
            LocalTSSystemTray.getInstance().showOfflineIcon();
            online = false;
        } else {
            OnlineOfflineManager.goOnline();
        }
    }

    public static synchronized void remainOnline() {
        shouldRemainOnline = true;
        OnlineOfflineManager.goOnline();
    }

    public static synchronized boolean isOnline() {
        return online;
    }

    public static synchronized boolean isOffline() {
        return !online;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendStuffWhenOnline(String url, byte[] messageBody) {
        if (online) {
            OnlineOfflineManager.send(url, messageBody);
        } else {
            List<Sendable> list = stuffToSend;
            synchronized (list) {
                stuffToSend.add(new Sendable(url, messageBody));
            }
        }
    }

    private static byte[] send(String url, byte[] messageBody) {
        byte[] response;
        if (url != null) {
            try {
                int b;
                URLConnection conn = new URL(url).openConnection();
                if (messageBody != null) {
                    conn.setDoOutput(true);
                    OutputStream out = conn.getOutputStream();
                    out.write(messageBody);
                }
                BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((b = ((InputStream)in).read()) != -1) {
                    baos.write((byte)b);
                }
                ((InputStream)in).close();
                response = baos.toByteArray();
            }
            catch (Exception e) {
                System.err.println("OnlineOfflineManager: " + e);
                response = null;
            }
        } else {
            response = null;
        }
        return response;
    }

    private static class Sendable {
        public final String url;
        public final byte[] messageBody;

        public Sendable(String url, byte[] messageBody) {
            this.url = url;
            this.messageBody = messageBody;
        }
    }

    private static class StuffSender
    extends Thread {
        private StuffSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!OnlineOfflineManager.isOffline()) {
                Sendable current;
                List list = stuffToSend;
                synchronized (list) {
                    if (stuffToSend.isEmpty()) {
                        return;
                    }
                    current = (Sendable)stuffToSend.remove(0);
                }
                OnlineOfflineManager.send(current.url, current.messageBody);
            }
            return;
        }
    }
}

