/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.CTATBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;

public class CTATEmail
extends CTATBase {
    private ArrayList<String> contacts = null;

    public CTATEmail() {
        this.setClassName("CTATEmail");
        this.debug("CTATEmail ()");
        this.contacts = new ArrayList();
    }

    public void addContactServer(String aContact) {
        this.debug("addContactServer (" + aContact + ")");
        this.contacts.add(aContact);
    }

    protected String sendEmail(String a_to, String a_subject, String a_body) {
        this.debug("sendEmail ()");
        for (int i = 0; i < this.contacts.size(); ++i) {
            String aURL = this.contacts.get(i);
            this.debug("Trying contact: " + aURL);
            String result = this.sendEmailToServer(aURL, a_to, a_subject, a_body);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected String sendEmailToServer(String aURL, String a_to, String a_subject, String a_body) {
        this.debug("sendEmailToServer ()");
        StringBuffer reply = new StringBuffer();
        URL url = null;
        URLConnection conn = null;
        OutputStreamWriter wr = null;
        BufferedReader in = null;
        String line = null;
        String data = null;
        try {
            data = URLEncoder.encode("to", "UTF-8") + "=" + URLEncoder.encode(a_to, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        try {
            data = data + "&" + URLEncoder.encode("subject", "UTF-8") + "=" + URLEncoder.encode(a_subject, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        try {
            data = data + "&" + URLEncoder.encode("body", "UTF-8") + "=" + URLEncoder.encode(a_body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        try {
            url = new URL(aURL);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        try {
            conn = url.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        conn.setDoOutput(true);
        try {
            wr = new OutputStreamWriter(conn.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            wr.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            wr.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            while ((line = in.readLine()) != null) {
                reply.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        this.debug(reply.toString());
        return reply.toString();
    }
}

