/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.toedter.calendar.JDateChooser;
import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.monitor.CTATBerkeleyDB;
import edu.cmu.hcii.ctat.monitor.CTATBerkeleyDBInstance;
import edu.cmu.hcii.ctat.monitor.CTATDBFileFilter;
import edu.cmu.hcii.ctat.monitor.CTATTSMemory;
import edu.cmu.hcii.ctat.monitor.CTATTSSerializable;
import edu.cmu.hcii.ctat.monitor.CTATTSSession;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;

public class CTATMonitorDatabaseManager
extends JFrame
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = -1353911499968570785L;
    private SimpleDateFormat df = new SimpleDateFormat("EEE d MMM yyyy HH:mm:ss.SSS Z");
    private JList coreList = null;
    private CTATBerkeleyDB driver = null;
    private JTextArea dbData = null;
    private JTable vizTable = null;
    private String[] dbheader = new String[]{"Index", "Date", "Entry"};
    private String[][] dbdata = new String[0][];
    private String[] resolutionoptons = new String[]{"All", "Hour", "Day", "Week", "Month"};
    private DefaultTableModel model = null;
    private CTATBerkeleyDBInstance sessionDB = null;
    private CTATBerkeleyDBInstance memoryDB = null;
    private CTATBerkeleyDBInstance dummyDB = null;
    private StoredSortedMap<Long, CTATTSSession> sessionMap = null;
    private StoredSortedMap<Long, CTATTSMemory> memoryMap = null;
    private StoredSortedMap<Long, String> dummyMap = null;
    private SortedMap<Long, CTATTSSession> sessionMapRanged = null;
    private SortedMap<Long, CTATTSMemory> memoryMapRanged = null;
    private SortedMap<Long, String> dummyMapRanged = null;
    private Object[] sessionObjectMap = null;
    private Object[] memoryObjectMap = null;
    private Object[] dummyObjectMap = null;
    private Object currentDB;
    private Boolean showDates = false;
    private JCheckBox toggleDateFormat = null;
    private JTextField status = null;
    private JTextField statusBar = null;
    private JTextField tableInfo = null;
    private JTextField minRange = null;
    private JTextField maxRange = null;
    private JButton setRange = null;
    private JButton setDateRange = null;
    private JButton previousSet = null;
    private JButton nextSet = null;
    private JComboBox changeResolution = null;
    private JButton exportSet = null;
    private JRadioButton exportAllButton = null;
    private JRadioButton exportSelectedButton = null;
    private Boolean exportAll = false;
    private JDateChooser startDate = null;
    private JDateChooser endDate = null;
    public static final int BYRANGE = 1;
    public static final int BYDATE = 2;
    private int sortby = 1;

    public CTATMonitorDatabaseManager() {
        this.setTitle("CTAT Monitor Database Manager");
        this.setSize(640, 450);
        Border border = BorderFactory.createLineBorder(Color.black);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.setContentPane(tabbedPane);
        JPanel panel = new JPanel();
        tabbedPane.addTab("Data Manager", null, panel, "Load, edit and export data");
        panel.setLayout(new BoxLayout(panel, 1));
        this.coreList = new JList();
        this.coreList.setMinimumSize(new Dimension(100, 50));
        this.coreList.addMouseListener(this);
        this.coreList.setFont(new Font("Dialog", 1, 10));
        JScrollPane posScrollList = new JScrollPane(this.coreList);
        Box bottomContainer = new Box(1);
        Box buttonBar = new Box(0);
        buttonBar.setMinimumSize(new Dimension(50, 20));
        buttonBar.setMaximumSize(new Dimension(50000, 20));
        this.toggleDateFormat = new JCheckBox();
        this.toggleDateFormat.setText("Show Date/Raw");
        this.toggleDateFormat.setFont(new Font("Dialog", 1, 10));
        this.toggleDateFormat.addActionListener(this);
        buttonBar.add(this.toggleDateFormat);
        this.changeResolution = new JComboBox<String>(this.resolutionoptons);
        this.changeResolution.addActionListener(this);
        buttonBar.add(this.changeResolution);
        buttonBar.add(new JSeparator(1));
        this.minRange = new JTextField();
        this.minRange.setText("0");
        this.minRange.setFont(new Font("Dialog", 1, 10));
        this.minRange.setMinimumSize(new Dimension(50, 18));
        this.minRange.setPreferredSize(new Dimension(50, 18));
        buttonBar.add(this.minRange);
        this.maxRange = new JTextField();
        this.maxRange.setText("100");
        this.maxRange.setFont(new Font("Dialog", 1, 10));
        this.maxRange.setMinimumSize(new Dimension(50, 20));
        this.maxRange.setPreferredSize(new Dimension(50, 20));
        buttonBar.add(this.maxRange);
        this.setRange = new JButton();
        this.setRange.setMargin(new Insets(1, 1, 1, 1));
        this.setRange.setText("Set");
        this.setRange.setFont(new Font("Dialog", 1, 10));
        this.setRange.setMinimumSize(new Dimension(60, 20));
        this.setRange.setPreferredSize(new Dimension(60, 20));
        this.setRange.addActionListener(this);
        buttonBar.add(this.setRange);
        this.previousSet = new JButton();
        this.previousSet.setMargin(new Insets(1, 1, 1, 1));
        this.previousSet.setText("Previous");
        this.previousSet.setFont(new Font("Dialog", 1, 10));
        this.previousSet.setMinimumSize(new Dimension(60, 20));
        this.previousSet.setPreferredSize(new Dimension(60, 20));
        this.previousSet.addActionListener(this);
        buttonBar.add(this.previousSet);
        this.nextSet = new JButton();
        this.nextSet.setMargin(new Insets(1, 1, 1, 1));
        this.nextSet.setText("Next");
        this.nextSet.setFont(new Font("Dialog", 1, 10));
        this.nextSet.setMinimumSize(new Dimension(60, 20));
        this.nextSet.setPreferredSize(new Dimension(60, 20));
        this.nextSet.addActionListener(this);
        buttonBar.add(this.nextSet);
        buttonBar.add(new JSeparator(1));
        this.startDate = new JDateChooser(new Date());
        this.startDate.setFont(new Font("Dialog", 1, 10));
        this.startDate.setMinimumSize(new Dimension(100, 20));
        this.startDate.setPreferredSize(new Dimension(100, 20));
        buttonBar.add((Component)this.startDate);
        this.endDate = new JDateChooser(new Date());
        this.endDate.setFont(new Font("Dialog", 1, 10));
        this.endDate.setMinimumSize(new Dimension(100, 20));
        this.endDate.setPreferredSize(new Dimension(100, 20));
        buttonBar.add((Component)this.endDate);
        this.setDateRange = new JButton();
        this.setDateRange.setMargin(new Insets(1, 1, 1, 1));
        this.setDateRange.setText("Set Dates");
        this.setDateRange.setFont(new Font("Dialog", 1, 10));
        this.setDateRange.setMinimumSize(new Dimension(60, 20));
        this.setDateRange.setPreferredSize(new Dimension(60, 20));
        this.setDateRange.addActionListener(this);
        buttonBar.add(this.setDateRange);
        buttonBar.add(new JSeparator(1));
        this.status = new JTextField();
        this.status.setText("Status: OK");
        this.status.setEditable(false);
        this.status.setBorder(border);
        this.status.setFont(new Font("Dialog", 1, 10));
        this.status.setMinimumSize(new Dimension(20, 20));
        this.status.setPreferredSize(new Dimension(50000, 20));
        buttonBar.add(this.status);
        this.model = new DefaultTableModel(this.dbdata, this.dbheader);
        this.vizTable = new JTable(this.model);
        this.vizTable.setMinimumSize(new Dimension(100, 50));
        this.vizTable.setFont(new Font("Dialog", 1, 10));
        this.vizTable.getColumnModel().getColumn(0).setPreferredWidth(27);
        this.vizTable.getColumnModel().getColumn(1).setPreferredWidth(120);
        JScrollPane tableScrollList = new JScrollPane(this.vizTable);
        tableScrollList.setMinimumSize(new Dimension(50, 50));
        tableScrollList.setMaximumSize(new Dimension(5000, 5000));
        Box toolBar = new Box(0);
        toolBar.setMinimumSize(new Dimension(50, 20));
        toolBar.setMaximumSize(new Dimension(50000, 20));
        this.exportAllButton = new JRadioButton();
        this.exportAllButton.setText("All");
        this.exportAllButton.setFont(new Font("Dialog", 1, 10));
        this.exportAllButton.addActionListener(this);
        toolBar.add(this.exportAllButton);
        this.exportSelectedButton = new JRadioButton();
        this.exportSelectedButton.setText("Selected");
        this.exportSelectedButton.setFont(new Font("Dialog", 1, 10));
        this.exportSelectedButton.setSelected(true);
        this.exportSelectedButton.addActionListener(this);
        toolBar.add(this.exportSelectedButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.exportAllButton);
        group.add(this.exportSelectedButton);
        this.exportSet = new JButton();
        this.exportSet.setMargin(new Insets(1, 1, 1, 1));
        this.exportSet.setText("Export ...");
        this.exportSet.setFont(new Font("Dialog", 1, 10));
        this.exportSet.setMinimumSize(new Dimension(70, 20));
        this.exportSet.setPreferredSize(new Dimension(70, 20));
        this.exportSet.addActionListener(this);
        toolBar.add(this.exportSet);
        JButton importSet = new JButton();
        importSet.setMargin(new Insets(1, 1, 1, 1));
        importSet.setText("Import ...");
        importSet.setFont(new Font("Dialog", 1, 10));
        importSet.setMinimumSize(new Dimension(70, 20));
        importSet.setPreferredSize(new Dimension(70, 20));
        importSet.addActionListener(this);
        toolBar.add(importSet);
        JTextField filler2 = new JTextField();
        filler2.setText("Status: OK");
        filler2.setEditable(false);
        filler2.setBorder(border);
        filler2.setFont(new Font("Dialog", 1, 10));
        filler2.setMinimumSize(new Dimension(20, 18));
        filler2.setPreferredSize(new Dimension(50000, 20));
        toolBar.add(filler2);
        this.tableInfo = new JTextField();
        this.tableInfo.setText("");
        this.tableInfo.setEditable(false);
        this.tableInfo.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tableInfo.setFont(new Font("Dialog", 1, 10));
        this.tableInfo.setMinimumSize(new Dimension(20, 20));
        this.tableInfo.setPreferredSize(new Dimension(50000, 20));
        this.tableInfo.setMaximumSize(new Dimension(50000, 20));
        bottomContainer.add(buttonBar);
        bottomContainer.add(this.tableInfo);
        bottomContainer.add(tableScrollList);
        bottomContainer.add(toolBar);
        this.dbData = new JTextArea();
        this.dbData.setFont(new Font("Courier", 1, 10));
        JScrollPane dbDataScroller = new JScrollPane(this.dbData);
        JSplitPane rightSplitPane = new JSplitPane(0, dbDataScroller, bottomContainer);
        rightSplitPane.setOneTouchExpandable(true);
        rightSplitPane.setDividerLocation(150);
        JSplitPane splitPane = new JSplitPane(1, posScrollList, rightSplitPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(150);
        splitPane.setMinimumSize(new Dimension(20, 20));
        splitPane.setMaximumSize(new Dimension(50000, 50000));
        splitPane.setBorder(border);
        panel.add(splitPane);
        JPanel genPanel = new JPanel();
        tabbedPane.addTab("Data Generator", null, genPanel, "Generate simulated data");
        genPanel.setLayout(new BoxLayout(genPanel, 1));
        this.addWindowListener(new ExitListener());
        this.setVisible(true);
        this.driver = new CTATBerkeleyDB();
        this.driver.startDBService();
        this.getDBInfo();
    }

    private void debug(String aMessage) {
        CTATBase.debug("CTATMonitorDatabaseManager", aMessage);
    }

    private void showMessage(String aMessage) {
        this.debug(aMessage);
        JOptionPane.showMessageDialog(this, aMessage);
    }

    private void reset() {
        this.minRange.setText("0");
        this.maxRange.setText("100");
        this.sortby = 1;
        this.tableInfo.setText("");
    }

    public Boolean getExportAll() {
        return this.exportAll;
    }

    public void setExportAll(Boolean exportAll) {
        this.exportAll = exportAll;
    }

    private void getDBInfo() {
        this.debug("getDBInfo ()");
        this.dbData.setText(this.driver.getStatus());
        ArrayList<String> dbs = this.driver.getDatabases();
        ArrayList<String> dbUUIDS = new ArrayList<String>();
        for (int i = 0; i < dbs.size(); ++i) {
            this.debug(dbs.get(i));
            if (!dbs.get(i).matches("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}.*?/All")) continue;
            this.debug(dbs.get(i));
            dbUUIDS.add(dbs.get(i).substring(0, dbs.get(i).length() - 4));
        }
        this.coreList.setModel(this.modelFromList(dbUUIDS));
    }

    public DefaultListModel modelFromList(ArrayList<String> dbs) {
        this.debug("modelFromArray ()");
        DefaultListModel<String> mdl = new DefaultListModel<String>();
        for (int i = 0; i < dbs.size(); ++i) {
            mdl.addElement(dbs.get(i));
        }
        return mdl;
    }

    public DefaultListModel modelFromMap(Map<Long, String> aMap) {
        this.debug("modelFromArray ()");
        DefaultListModel<String> mdl = new DefaultListModel<String>();
        for (Map.Entry<Long, String> entry : aMap.entrySet()) {
            mdl.addElement(entry.getKey().toString());
        }
        return mdl;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.reset();
            int index = this.coreList.locationToIndex(e.getPoint());
            ListModel dlm = this.coreList.getModel();
            Object item = dlm.getElementAt(index);
            this.coreList.ensureIndexIsVisible(index);
            this.currentDB = item;
            this.loadDB(item + "/All");
        }
    }

    private void loadDB(Object item) {
        this.debug("loadDB: " + item);
        this.sessionDB = null;
        this.memoryDB = null;
        this.dummyDB = null;
        this.sessionMap = null;
        this.memoryMap = null;
        this.dummyMap = null;
        CTATBerkeleyDBInstance inst = null;
        try {
            inst = this.driver.accessDB(item.toString());
        }
        catch (Exception e1) {
            this.debug("Error accessing or creating database: " + item.toString());
            e1.printStackTrace();
        }
        if (inst != null) {
            Long toKey;
            Long fromKey;
            Map.Entry entry;
            LongBinding keyBinding;
            if (item.toString().indexOf("-TSSession") != -1) {
                this.debug("Mapping session db ...");
                try {
                    this.sessionDB = this.driver.accessDB(item.toString());
                }
                catch (Exception e1) {
                    this.debug("Error accessing or creating session data " + item.toString());
                    e1.printStackTrace();
                }
                if (this.sessionDB != null) {
                    keyBinding = new LongBinding();
                    SerialBinding sessionBinding = new SerialBinding((ClassCatalog)this.driver.getClassCatalog(), CTATTSSession.class);
                    this.sessionMap = new StoredSortedMap(this.sessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
                } else {
                    this.debug("Error: unable to access (session) database");
                }
            }
            if (item.toString().indexOf("-TSMemory") != -1) {
                this.debug("Mapping memory db ...");
                try {
                    this.memoryDB = this.driver.accessDB(item.toString());
                }
                catch (Exception e1) {
                    this.debug("Error accessing or creating memory data " + item.toString());
                    e1.printStackTrace();
                }
                if (this.memoryDB != null) {
                    keyBinding = new LongBinding();
                    SerialBinding memoryBinding = new SerialBinding((ClassCatalog)this.driver.getClassCatalog(), CTATTSMemory.class);
                    this.memoryMap = new StoredSortedMap(this.memoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
                } else {
                    this.debug("Error: unable to access (memory) database");
                }
            }
            if (item.toString().indexOf("-TSDummy") != -1) {
                this.debug("Mapping dummy db ...");
                try {
                    this.dummyDB = this.driver.accessDB(item.toString());
                }
                catch (Exception e1) {
                    this.debug("Error accessing or creating dummy data " + item.toString());
                    e1.printStackTrace();
                }
                if (this.dummyDB != null) {
                    keyBinding = new LongBinding();
                    StringBinding valueBinding = new StringBinding();
                    this.dummyMap = new StoredSortedMap(this.dummyDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)valueBinding, true);
                } else {
                    this.debug("Error: unable to access (dummy) database");
                }
            }
            this.refreshTable();
            if (this.sessionMap != null) {
                entry = (Map.Entry)this.sessionObjectMap[0];
                fromKey = (Long)entry.getKey();
                this.startDate.setDate(new Date(fromKey));
                entry = (Map.Entry)this.sessionObjectMap[this.sessionObjectMap.length - 1];
                toKey = (Long)entry.getKey();
                this.endDate.setDate(new Date(toKey));
                this.tableInfo.setText("Table date range is from \"" + this.df.format(fromKey) + "\" to \"" + this.df.format(toKey) + "\"");
            }
            if (this.memoryMap != null) {
                entry = (Map.Entry)this.memoryObjectMap[0];
                fromKey = (Long)entry.getKey();
                this.startDate.setDate(new Date(fromKey));
                entry = (Map.Entry)this.memoryObjectMap[this.memoryObjectMap.length - 1];
                toKey = (Long)entry.getKey();
                this.endDate.setDate(new Date(toKey));
                this.tableInfo.setText("Table date range is from \"" + this.df.format(fromKey) + "\" to \"" + this.df.format(toKey) + "\"");
            }
        } else {
            this.debug("Error: unable to obtain handle to database: " + item.toString());
            if (this.statusBar != null) {
                this.statusBar.setText("Error: unable to obtain handle to database: " + item.toString());
            }
        }
    }

    private void refreshTable() {
        Long range;
        Long start;
        this.debug("refreshTable ()");
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.createRange();
        if (this.sessionMap != null) {
            if (this.statusBar != null) {
                this.statusBar.setText("Creating Session Map from DB ...");
            }
            this.status.setText("Table size: " + this.sessionMap.entrySet().size());
            start = Long.parseLong(this.minRange.getText());
            range = Long.parseLong(this.maxRange.getText());
            if ((long)this.sessionMap.entrySet().size() < start + range) {
                this.minRange.setEnabled(false);
                this.maxRange.setEnabled(false);
                this.setRange.setEnabled(false);
                this.previousSet.setEnabled(false);
                this.nextSet.setEnabled(false);
            } else {
                this.minRange.setEnabled(true);
                this.maxRange.setEnabled(true);
                this.setRange.setEnabled(true);
                this.previousSet.setEnabled(true);
                this.nextSet.setEnabled(true);
            }
            this.model.setRowCount(0);
            if (this.sortby == 1) {
                this.sessionArrayToTable(this.sessionObjectMap, this.model);
            } else {
                this.sessionMapToTable(this.sessionMapRanged, this.model);
            }
            if (this.statusBar != null) {
                this.statusBar.setText("Map available");
            }
        }
        if (this.memoryMap != null) {
            if (this.statusBar != null) {
                this.statusBar.setText("Creating Memory Map from DB ...");
            }
            this.status.setText("Table size: " + this.memoryMap.entrySet().size());
            start = Long.parseLong(this.minRange.getText());
            range = Long.parseLong(this.maxRange.getText());
            if ((long)this.memoryMap.entrySet().size() < start + range) {
                this.minRange.setEnabled(false);
                this.maxRange.setEnabled(false);
                this.setRange.setEnabled(false);
                this.previousSet.setEnabled(false);
                this.nextSet.setEnabled(false);
            } else {
                this.minRange.setEnabled(true);
                this.maxRange.setEnabled(true);
                this.setRange.setEnabled(true);
                this.previousSet.setEnabled(true);
                this.nextSet.setEnabled(true);
            }
            this.model.setRowCount(0);
            if (this.sortby == 1) {
                this.memoryArrayToTable(this.memoryObjectMap, this.model);
            } else {
                this.memoryMapToTable(this.memoryMapRanged, this.model);
            }
            if (this.statusBar != null) {
                this.statusBar.setText("Map available");
            }
        }
        if (this.dummyMap != null) {
            if (this.statusBar != null) {
                this.statusBar.setText("Creating Dummy Map from DB ...");
            }
            this.status.setText("Table size: " + this.dummyMap.entrySet().size());
            start = Long.parseLong(this.minRange.getText());
            range = Long.parseLong(this.maxRange.getText());
            if ((long)this.dummyMap.entrySet().size() < start + range) {
                this.minRange.setEnabled(false);
                this.maxRange.setEnabled(false);
                this.setRange.setEnabled(false);
                this.previousSet.setEnabled(false);
                this.nextSet.setEnabled(false);
            } else {
                this.minRange.setEnabled(true);
                this.maxRange.setEnabled(true);
                this.setRange.setEnabled(true);
                this.previousSet.setEnabled(true);
                this.nextSet.setEnabled(true);
            }
            this.model.setRowCount(0);
            if (this.statusBar != null) {
                this.statusBar.setText("Map available");
            }
        }
        this.vizTable.setAutoResizeMode(3);
        this.vizTable.getColumnModel().getColumn(0).setWidth(27);
        this.vizTable.getColumnModel().getColumn(1).setWidth(120);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void sessionMapToTable(Map<Long, CTATTSSession> aMap, DefaultTableModel aModel) {
        this.debug("sessionMapToTable ()");
        Long range = Long.parseLong(this.maxRange.getText());
        Iterator<Map.Entry<Long, CTATTSSession>> iter = aMap.entrySet().iterator();
        Long counter = 0L;
        while (iter.hasNext() && counter < range) {
            Map.Entry<Long, CTATTSSession> entry = iter.next();
            if (entry != null) {
                if (this.showDates.booleanValue()) {
                    Date shower = new Date(entry.getKey());
                    String aDateString = this.df.format(shower);
                    aModel.insertRow(this.vizTable.getRowCount(), new Object[]{counter.toString(), aDateString, entry.getValue().toString()});
                } else {
                    aModel.insertRow(this.vizTable.getRowCount(), new Object[]{counter.toString(), entry.getKey().toString(), entry.getValue().toString()});
                }
            } else {
                this.debug("Error getting session from map");
            }
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        }
        this.debug("sessionMapToTable () Done");
    }

    private void memoryMapToTable(Map<Long, CTATTSMemory> aMap, DefaultTableModel aModel) {
        this.debug("memoryMapToTable (" + aMap.entrySet().size() + ")");
        Long range = Long.parseLong(this.maxRange.getText());
        Iterator<Map.Entry<Long, CTATTSMemory>> iter = aMap.entrySet().iterator();
        Long counter = 0L;
        this.debug("Transforming data ...");
        while (iter.hasNext() && counter < range) {
            Map.Entry<Long, CTATTSMemory> entry = iter.next();
            if (entry != null) {
                if (this.showDates.booleanValue()) {
                    Date shower = new Date(entry.getKey());
                    String aDateString = this.df.format(shower);
                    aModel.insertRow(this.vizTable.getRowCount(), new Object[]{counter.toString(), aDateString, entry.getValue().toString()});
                } else {
                    aModel.insertRow(this.vizTable.getRowCount(), new Object[]{counter.toString(), entry.getKey().toString(), entry.getValue().toString()});
                }
            } else {
                this.debug("Error, unable to get memory entry from map");
            }
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        }
        this.debug("memoryMapToTable () Done");
    }

    private void sessionArrayToTable(Object[] anArray, DefaultTableModel aModel) {
        this.debug("sessionArrayToTable ()");
        Long start = Long.parseLong(this.minRange.getText());
        Long range = Long.parseLong(this.maxRange.getText());
        Long i = start;
        while (i < range) {
            int mappedIndex = i.intValue();
            Map.Entry entry = (Map.Entry)anArray[mappedIndex];
            Long key = (Long)entry.getKey();
            CTATTSSession value = (CTATTSSession)entry.getValue();
            if (this.showDates.booleanValue()) {
                Date shower = new Date(key);
                String aDateString = this.df.format(shower);
                aModel.insertRow(this.vizTable.getRowCount(), new Object[]{i.toString(), aDateString, value.toString()});
            } else {
                aModel.insertRow(this.vizTable.getRowCount(), new Object[]{i.toString(), key.toString(), value.toString()});
            }
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
        }
    }

    private void memoryArrayToTable(Object[] anArray, DefaultTableModel aModel) {
        this.debug("memoryArrayToTable ()");
        Long start = Long.parseLong(this.minRange.getText());
        Long range = Long.parseLong(this.maxRange.getText());
        Long i = start;
        while (i < range) {
            int mappedIndex = i.intValue();
            Map.Entry entry = (Map.Entry)anArray[mappedIndex];
            Long key = (Long)entry.getKey();
            CTATTSMemory value = (CTATTSMemory)entry.getValue();
            if (this.showDates.booleanValue()) {
                Date shower = new Date(key);
                String aDateString = this.df.format(shower);
                aModel.insertRow(this.vizTable.getRowCount(), new Object[]{i.toString(), aDateString, value.toString()});
            } else {
                aModel.insertRow(this.vizTable.getRowCount(), new Object[]{i.toString(), key.toString(), value.toString()});
            }
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Long range;
        Long start;
        this.debug("actionPerformed (" + event.getActionCommand() + ")");
        if (event.getSource() == this.toggleDateFormat) {
            this.showDates = this.toggleDateFormat.isSelected() ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.refreshTable();
            return;
        }
        if (event.getSource() == this.changeResolution) {
            this.debug("changeResolution");
            this.debug("current db is " + this.currentDB);
            String selectedResolution = (String)this.changeResolution.getSelectedItem();
            String dbToOpen = this.currentDB + "/" + selectedResolution;
            this.debug("Opening " + dbToOpen);
            this.loadDB(dbToOpen);
        }
        if (event.getSource() == this.setRange) {
            this.sortby = 1;
            this.createRange();
            this.refreshTable();
            return;
        }
        if (event.getSource() == this.setDateRange) {
            this.sortby = 2;
            this.refreshTable();
            return;
        }
        if (event.getSource() == this.exportAllButton) {
            this.setExportAll(true);
            return;
        }
        if (event.getSource() == this.exportSelectedButton) {
            this.setExportAll(false);
            return;
        }
        if (event.getSource() == this.exportSet) {
            CTATDBFileFilter filter1 = new CTATDBFileFilter("Delimited spreadsheet files", new String[]{"CSV"});
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(filter1);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.debug("Opening: " + file.getName() + ".");
                this.exportData(file.getAbsolutePath());
            } else {
                this.debug("Open command cancelled by user.");
            }
            return;
        }
        if (event.getSource() == this.setRange) {
            this.refreshTable();
            return;
        }
        if (event.getSource() == this.previousSet) {
            start = Long.parseLong(this.minRange.getText());
            range = Long.parseLong(this.maxRange.getText());
            start = start - 100L;
            range = range - 100L;
            this.minRange.setText(start.toString());
            this.maxRange.setText(range.toString());
            this.refreshTable();
            return;
        }
        if (event.getSource() == this.nextSet) {
            start = Long.parseLong(this.minRange.getText());
            range = Long.parseLong(this.maxRange.getText());
            start = start + 100L;
            range = range + 100L;
            this.minRange.setText(start.toString());
            this.maxRange.setText(range.toString());
            this.refreshTable();
            return;
        }
    }

    private void createRange() {
        this.debug("createRange ()");
        Long minTest = Long.parseLong(this.minRange.getText());
        Long maxTest = Long.parseLong(this.maxRange.getText());
        if (minTest > maxTest) {
            this.showMessage("Error: maximum range needs to be larger than minimum range");
            return;
        }
        if (minTest == maxTest) {
            this.showMessage("Error: Start index is equal to end index");
            return;
        }
        if (minTest < 0L) {
            this.showMessage("Error: Can't enter negative numbers");
            return;
        }
        if (this.sessionMap != null) {
            if (maxTest > (long)this.sessionMap.size()) {
                this.showMessage("Error: max range is larger than dataset, capping ...");
                String formed = String.format("%d", this.sessionMap.size());
                this.maxRange.setText(formed);
                return;
            }
            try {
                this.sessionMapRanged = this.sessionMap.subMap((Object)minTest, (Object)maxTest);
            }
            catch (IllegalArgumentException e) {
                this.showMessage("One of the range indexes is out of bounds");
                return;
            }
            this.sessionMapRanged = this.sessionMap.subMap((Object)minTest, (Object)maxTest);
            this.sessionObjectMap = this.sessionMap.entrySet().toArray();
        }
        if (this.memoryMap != null) {
            if (maxTest > (long)this.memoryMap.size()) {
                this.showMessage("Error: max range is larger than dataset, capping ...");
                String formed = String.format("%d", this.memoryMap.size());
                this.maxRange.setText(formed);
                return;
            }
            try {
                this.memoryMapRanged = this.memoryMap.subMap((Object)minTest, (Object)maxTest);
            }
            catch (IllegalArgumentException e) {
                this.showMessage("One of the range indexes is out of bounds");
                return;
            }
            this.memoryObjectMap = this.memoryMap.entrySet().toArray();
        }
        if (this.dummyMap != null) {
            if (maxTest > (long)this.dummyMap.size()) {
                this.debug("Error: max range is larger than dataset");
                return;
            }
            try {
                this.dummyMapRanged = this.dummyMap.subMap((Object)minTest, (Object)maxTest);
            }
            catch (IllegalArgumentException e) {
                this.showMessage("One of the range indexes is out of bounds");
                return;
            }
            this.dummyObjectMap = this.dummyMap.entrySet().toArray();
        }
        this.debug("createRange () Done");
    }

    private void exportData(String aFile) {
        CTATDesktopFileManager fManager;
        this.debug("exportData ()");
        this.setCursor(Cursor.getPredefinedCursor(3));
        String fileFormatted = aFile;
        if (aFile.toLowerCase().indexOf("csv") == -1) {
            fileFormatted = aFile + ".csv";
        }
        if (!(fManager = new CTATDesktopFileManager()).openStream(fileFormatted)) {
            this.debug("Error opening file for writing");
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (this.exportAll.booleanValue()) {
            String aDateString;
            Date shower;
            CTATTSSerializable headerGenerator;
            if (this.sessionMap != null) {
                headerGenerator = new CTATTSSession();
                fManager.writeToStream("Time,");
                fManager.writeToStream(((CTATTSSession)headerGenerator).toCSVHeader());
                for (Map.Entry entry : this.sessionMap.entrySet()) {
                    if (entry != null) {
                        if (this.showDates.booleanValue()) {
                            shower = new Date((Long)entry.getKey());
                            aDateString = this.df.format(shower);
                            fManager.writeToStream(aDateString + "," + ((CTATTSSession)entry.getValue()).toCSV());
                        } else {
                            fManager.writeToStream(((Long)entry.getKey()).toString() + "," + ((CTATTSSession)entry.getValue()).toCSV());
                        }
                        fManager.writeToStream("\n");
                        continue;
                    }
                    this.debug("Error getting session from map");
                }
            }
            if (this.memoryMap != null) {
                headerGenerator = new CTATTSMemory();
                fManager.writeToStream("Time,");
                fManager.writeToStream(((CTATTSMemory)headerGenerator).toCSVHeader());
                for (Map.Entry entry : this.memoryMap.entrySet()) {
                    if (entry != null) {
                        if (this.showDates.booleanValue()) {
                            shower = new Date((Long)entry.getKey());
                            aDateString = this.df.format(shower);
                            fManager.writeToStream(aDateString + "," + ((CTATTSMemory)entry.getValue()).toCSV());
                        } else {
                            fManager.writeToStream(((Long)entry.getKey()).toString() + "," + ((CTATTSMemory)entry.getValue()).toCSV());
                        }
                        fManager.writeToStream("\n");
                        continue;
                    }
                    this.debug("Error getting session from map");
                }
            }
        } else {
            Long minTest = Long.parseLong(this.minRange.getText());
            Long l = Long.parseLong(this.maxRange.getText());
        }
        fManager.closeStream();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static void main(String[] args) {
        CTATLink link = new CTATLink(new CTATDesktopFileManager());
        CTATLink.printDebugMessages = true;
        CTATMonitorDatabaseManager f = new CTATMonitorDatabaseManager();
    }

    private class ExitListener
    extends WindowAdapter {
        private ExitListener() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            if (CTATMonitorDatabaseManager.this.driver != null) {
                try {
                    CTATMonitorDatabaseManager.this.driver.close();
                }
                catch (Exception e) {
                    CTATMonitorDatabaseManager.this.debug("Error shutting down database driver");
                    e.printStackTrace();
                }
            }
            System.exit(0);
        }
    }
}

