/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.wizard;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.wizard.CTATWizardPageListRenderer;
import edu.cmu.hcii.ctat.wizard.CTATWizardPanelDescription;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public class CTATWizardBase
extends CTATBase
implements ActionListener {
    private int stepListWidth = 125;
    protected JDialog frame;
    private JLabel titleLabel = null;
    private JButton previousButton = null;
    private JButton nextButton = null;
    private JButton quitButton = null;
    private JButton cancelButton = null;
    private JButton restoreButton = null;
    private Box rightBox = null;
    private JPanel substitute = null;
    private JList<String> pageList = null;
    private ArrayList<CTATWizardPanelDescription> pages = new ArrayList();
    private DefaultListModel<String> listModel = new DefaultListModel();
    protected String singlePage = null;
    private int pageIndex = 0;
    public static JProgressBar progress = null;

    public CTATWizardBase() {
        this(null);
    }

    public CTATWizardBase(String singlePage) {
        this.setClassName("CTATWizardBase");
        this.debug("CTATWizardBase ()");
        this.singlePage = singlePage;
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new BoxLayout(mainPane, 1));
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box centerBox = new Box(0);
        centerBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPane.add(centerBox);
        this.pageList = new JList();
        this.pageList.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.pageList.setCellRenderer(new CTATWizardPageListRenderer());
        this.pageList.setEnabled(false);
        this.pageList.setMinimumSize(new Dimension(this.stepListWidth, 50));
        this.pageList.setMaximumSize(new Dimension(this.stepListWidth, 700));
        if (singlePage == null) {
            JScrollPane listScroller = new JScrollPane(this.pageList);
            listScroller.setMinimumSize(new Dimension(this.stepListWidth, 50));
            listScroller.setPreferredSize(new Dimension(this.stepListWidth, 300));
            listScroller.setMaximumSize(new Dimension(this.stepListWidth, 700));
            listScroller.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 100)));
            centerBox.add(listScroller);
        }
        this.rightBox = new Box(1);
        this.rightBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.titleLabel = new JLabel("CTAT SCORM Package Generator");
        this.titleLabel.setHorizontalAlignment(2);
        this.titleLabel.setFont(new Font("Dialog", 1, 12));
        this.titleLabel.setMinimumSize(new Dimension(50, 22));
        this.rightBox.add(this.titleLabel);
        this.rightBox.add(new JSeparator(0));
        centerBox.add(this.rightBox);
        this.substitute = this.createWizardJPanel();
        this.rightBox.add(this.substitute);
        this.rightBox.add(Box.createVerticalGlue());
        mainPane.add(centerBox);
        Box buttonBox = new Box(0);
        buttonBox.setBorder(new EmptyBorder(5, 5, 5, 0));
        buttonBox.add(Box.createHorizontalGlue());
        if (singlePage == null) {
            this.previousButton = new JButton("< Prev");
            this.previousButton.addActionListener(this);
            this.previousButton.setEnabled(false);
            buttonBox.add(this.previousButton);
            buttonBox.add(Box.createRigidArea(new Dimension(5, 0)));
            this.nextButton = new JButton("Next >");
            this.nextButton.addActionListener(this);
            buttonBox.add(this.nextButton);
            buttonBox.add(Box.createRigidArea(new Dimension(5, 0)));
        }
        this.quitButton = new JButton("Finish");
        this.quitButton.setEnabled(singlePage != null);
        this.quitButton.addActionListener(this);
        buttonBox.add(this.quitButton);
        buttonBox.add(Box.createRigidArea(new Dimension(5, 0)));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        buttonBox.add(this.cancelButton);
        mainPane.add(new JSeparator(0));
        mainPane.add(buttonBox);
        this.frame = new JDialog(AbstractCtatWindow.mainFrame, "CTAT Wizard", true);
        this.frame.setSize(700, 400);
        this.frame.setContentPane(mainPane);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setLocationRelativeTo(AbstractCtatWindow.mainFrame);
        this.frame.setResizable(false);
    }

    public void init() {
        this.debug("init ()");
    }

    public void setTitle(String aTitle) {
        this.frame.setTitle(aTitle);
    }

    public CTATWizardPanelDescription getNextPage(int anIndex) {
        return this.pages.get(anIndex);
    }

    public int getCurrentIndex() {
        return this.pageIndex;
    }

    public JPanel getCurrentPanel() {
        return this.pages.get(this.pageIndex).getPanelContent();
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public ArrayList<CTATWizardPanelDescription> getPages() {
        return this.pages;
    }

    public int getStepListWidth() {
        return this.stepListWidth;
    }

    public void setStepListWidth(int stepListWidth) {
        this.stepListWidth = stepListWidth;
    }

    protected void populateWizard() {
        this.debug("populateWizard ()");
    }

    protected void addPageLabel(String aLabel) {
        this.debug("addPageLabel ()");
        this.listModel.addElement(aLabel);
        this.pageList.setModel(this.listModel);
    }

    protected Box generateHorizontalBox() {
        Box radioBox = new Box(0);
        radioBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        return radioBox;
    }

    protected Box generateVerticalBox() {
        Box radioBox = new Box(1);
        radioBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        return radioBox;
    }

    protected CTATWizardPanelDescription addPage(String aLabel, JPanel aPanel) {
        this.debug("addPage ()");
        CTATWizardPanelDescription newPage = new CTATWizardPanelDescription();
        newPage.setPanelLabel(aLabel);
        newPage.setPanelContent(aPanel);
        this.pages.add(newPage);
        this.addPageLabel(aLabel);
        Component test = this.rightBox.getComponent(2);
        this.debug("Test: " + test);
        if (test == this.substitute) {
            this.debug("We have a start page, substituting ...");
            this.rightBox.remove(this.substitute);
            this.rightBox.add((Component)aPanel, 2);
        } else {
            this.debug("Info: component at index 2 is not our substitute page");
        }
        this.updateState();
        return newPage;
    }

    private void updateState() {
        this.debug("updateState ()");
        Component test = this.rightBox.getComponent(2);
        if (test != null) {
            for (int i = 0; i < this.pages.size(); ++i) {
                CTATWizardPanelDescription testPanel = this.pages.get(i);
                if (testPanel.getPanelContent() != test) continue;
                this.titleLabel.setText(this.singlePage == null ? testPanel.getPanelLabel() + " - Page ( " + (i + 1) + " of " + this.pages.size() + ")" : this.singlePage);
                return;
            }
        } else {
            this.titleLabel.setText("No wizard pages defined");
        }
        this.debug("updateState () Done");
    }

    protected void generateStartPage(JPanel aContainer) {
        this.debug("generateStartPage ()");
    }

    protected Boolean checkReadyToFinish() {
        this.debug("checkReadyToFinish ()");
        return false;
    }

    protected Boolean processFinish() {
        this.debug("processFinish ()");
        return false;
    }

    protected Boolean cleanup() {
        this.debug("cleanup ()");
        return false;
    }

    protected JPanel createWizardJPanel() {
        this.debug("createWizardJPanel ()");
        JPanel wizardPane = new JPanel();
        wizardPane.setLayout(new BoxLayout(wizardPane, 1));
        wizardPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        wizardPane.setAlignmentX(0.0f);
        return wizardPane;
    }

    protected void alert(String aMessage) {
        JOptionPane.showMessageDialog(null, aMessage);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.debug("actionPerformed ()");
        Object comp = arg0.getSource();
        if (comp == this.cancelButton) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        if (comp == this.restoreButton) {
            // empty if block
        }
        if (comp == this.quitButton && this.processFinish().booleanValue()) {
            this.cleanup();
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        if (comp == this.previousButton) {
            --this.pageIndex;
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(true);
            if (this.pageIndex <= 0) {
                this.pageIndex = 0;
                this.previousButton.setEnabled(false);
            }
            this.updatePageContent();
            this.updateState();
        }
        if (comp == this.nextButton) {
            if (!this.checkNextOK().booleanValue()) {
                return;
            }
            ++this.pageIndex;
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(true);
            if (this.pageIndex > this.pages.size() - 1) {
                this.pageIndex = this.pages.size() - 1;
            }
            if (this.pageIndex == this.pages.size() - 1) {
                this.nextButton.setEnabled(false);
                if (this.checkReadyToFinish().booleanValue()) {
                    this.quitButton.setEnabled(true);
                }
            } else {
                this.quitButton.setEnabled(false);
            }
            this.updatePageContent();
            this.updateState();
        }
    }

    protected Boolean checkNextOK() {
        return true;
    }

    private void updatePageContent() {
        CTATWizardPanelDescription targetPage;
        this.debug("updatePageContent ()");
        Component test = this.rightBox.getComponent(2);
        if (test != null && (targetPage = this.getNextPage(this.pageIndex)) != null) {
            this.rightBox.remove(test);
            this.rightBox.add((Component)targetPage.getPanelContent(), 2);
        }
        this.rightBox.repaint();
    }

    public static void main(String[] args) {
        CTATWizardBase t = new CTATWizardBase();
        t.show();
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            Random random = new Random();
            int progress = 0;
            this.setProgress(0);
            while (progress < 100) {
                try {
                    Thread.sleep(random.nextInt(1000));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.setProgress(Math.min(progress += random.nextInt(10), 100));
            }
            return null;
        }

        @Override
        public void done() {
        }
    }
}

