/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.Utilities.trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pact.CommWidgets.UniversalToolProxy;

class AwaitCancel
extends Thread
implements UniversalToolProxy.RebootInterfaceDialog {
    private JDialog dialog = null;
    private final Thread threadToInterrupt;
    private final Frame parent;

    AwaitCancel(Thread threadToInterrupt, Frame parent) {
        super("AwaitCancel" + System.currentTimeMillis());
        this.threadToInterrupt = threadToInterrupt;
        this.parent = parent;
    }

    @Override
    public void invoke() {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public boolean confirm() {
        int proceed = JOptionPane.showConfirmDialog(this.parent, "To ensure that you have the initial settings of all\ncomponents, unchanged by actions from the graph,\nyou must close and restart the student interface.\nPlease press OK to proceed, Cancel to quit.", "Must restart student interface", 2, 3);
        return proceed == 0;
    }

    @Override
    public void dispose() {
        this.dialog.dispose();
    }

    private void cancelUI(EventObject evt) {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "AwaitCancel.cancelUI(" + evt.getClass().getSimpleName() + ")");
        }
        this.threadToInterrupt.interrupt();
        this.dispose();
    }

    @Override
    public void run() {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "AwaitCancel.run() at top");
        }
        JLabel msg = new JLabel("Waiting for you to restart the student interface.");
        JLabel req = new JLabel("Press Cancel to abort...");
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        labelPanel.add(msg);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        labelPanel.add(req);
        labelPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AwaitCancel.this.cancelUI(evt);
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(cancel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)labelPanel, "Center");
        panel.add((Component)buttonPanel, "South");
        panel.setOpaque(true);
        this.dialog = new JDialog(this.parent, "Awaiting student interface restart");
        Point p = this.parent.getLocation();
        p.move(p.x + 100, p.y + 100);
        this.dialog.setLocation(p);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AwaitCancel.this.cancelUI(evt);
            }
        });
        this.dialog.setContentPane(panel);
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "AwaitCancel.run() just called setVisible()");
        }
    }
}

