/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class EditAudioButtonDialog
extends JDialog
implements ActionListener {
    private JCheckBox InvisibleCheckBox;
    private JButton replace;
    private JButton cancel;
    private JButton browseAudio;
    private JButton browseIcon;
    private JTextField newLabelText;
    private JTextField iconImageFile;
    private JTextField newAudioFile;
    private String newLabel;
    private String audioFileName;
    private ImageIcon icon = null;
    private String currentDirectory;
    private boolean invisible;
    private String defaultnewLabelText = "";
    private String defaultnewAudioFile = "";

    public EditAudioButtonDialog(JFrame parent, String title, String oldLabel, Icon oldIcon, String oldAudioFileName, String currentDirectory, boolean invisible, boolean modal) {
        super(parent, title, modal);
        this.newLabel = oldLabel;
        this.currentDirectory = currentDirectory;
        JPanel mainPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.ipadx = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        mainPane.add((Component)new JLabel("New Text: "), c);
        this.newLabelText = new JTextField(this.newLabel, 25);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.newLabelText);
        this.newLabelText.setName("newLabelText");
        c.gridy = 1;
        c.gridwidth = 3;
        mainPane.add((Component)this.newLabelText, c);
        c.gridy = 2;
        mainPane.add((Component)new JLabel("Image File:"), c);
        this.browseIcon = new JButton("Browse");
        this.browseIcon.addActionListener(this);
        c.gridx = 3;
        c.gridy = 3;
        mainPane.add((Component)this.browseIcon, c);
        this.iconImageFile = oldIcon != null ? new JTextField(oldIcon.toString(), 25) : new JTextField(25);
        jTextUndoPacket = JUndo.makeTextUndoable(this.iconImageFile);
        this.iconImageFile.setName("iconImageFile");
        c.gridx = 0;
        c.gridwidth = 3;
        mainPane.add((Component)this.iconImageFile, c);
        c.gridx = 0;
        c.gridy = 4;
        mainPane.add((Component)new JLabel("New Audio File: "), c);
        this.newAudioFile = oldAudioFileName != null ? new JTextField(oldAudioFileName, 25) : new JTextField(this.audioFileName, 25);
        jTextUndoPacket = JUndo.makeTextUndoable(this.newAudioFile);
        this.newAudioFile.setName("newAudioFile");
        c.gridy = 5;
        c.gridwidth = 3;
        mainPane.add((Component)this.newAudioFile, c);
        this.browseAudio = new JButton("browseAudio");
        this.browseAudio.addActionListener(this);
        c.gridx = 3;
        c.gridy = 5;
        mainPane.add((Component)this.browseAudio, c);
        this.InvisibleCheckBox = new JCheckBox("Invisible", null, invisible);
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 1;
        mainPane.add((Component)this.InvisibleCheckBox, c);
        this.replace = new JButton("Replace");
        this.replace.addActionListener(this);
        c.gridx = 2;
        c.gridy = 9;
        c.gridwidth = 1;
        mainPane.add((Component)this.replace, c);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        c.gridx = 3;
        mainPane.add((Component)this.cancel, c);
        this.setContentPane(mainPane);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.browseAudio) {
            class SoundFilter
            extends FileFilter {
                SoundFilter() {
                }

                @Override
                public boolean accept(File f) {
                    String name = f.getName().toLowerCase();
                    return f.isDirectory() || name.endsWith(".aif") || name.endsWith(".aiff") || name.endsWith(".wav");
                }

                @Override
                public String getDescription() {
                    return "Sound Files";
                }
            }
            File f = DialogUtilities.chooseFile(this.currentDirectory, new SoundFilter(), "Choose a sound file", "Open", null);
            if (f != null) {
                this.newAudioFile.setText(f.getAbsolutePath());
                trace.err("Save newAudioFile" + this.newAudioFile.getText());
                this.setAudioFileName(f.getAbsolutePath());
            }
        } else if (ae.getSource() == this.browseIcon) {
            class ImageFilter
            extends FileFilter {
                ImageFilter() {
                }

                @Override
                public boolean accept(File f) {
                    String name = f.getName().toLowerCase();
                    return f.isDirectory() || name.endsWith(".gif") || name.endsWith(".png") || name.endsWith(".jpg");
                }

                @Override
                public String getDescription() {
                    return "Image Files";
                }
            }
            File f = DialogUtilities.chooseFile(this.currentDirectory, new ImageFilter(), "Choose an image file", "Open", null);
            if (f != null) {
                this.iconImageFile.setText(f.getAbsolutePath());
            }
        } else if (ae.getSource() == this.cancel) {
            this.setVisible(false);
            this.dispose();
        } else if (ae.getSource() == this.replace) {
            String audioFileName;
            String[] args = new String[3];
            args[0] = this.newLabelText.getText();
            String newLabel = this.newLabelText.getText();
            if (!newLabel.equals("")) {
                this.setNewLabel(this.newLabelText.getText());
            }
            if (!(audioFileName = this.newAudioFile.getText()).equals("")) {
                this.setAudioFileName(this.newAudioFile.getText());
            }
            trace.err("Replace newAudioFile to " + this.getAudioFileName());
            String newImageFileName = this.iconImageFile.getText();
            if (!newImageFileName.equals("")) {
                ImageIcon icon = this.createImageIcon(newImageFileName, "a pretty but meaningless splat");
                this.setIcon(icon);
            }
            this.setInvisible(this.InvisibleCheckBox.isSelected());
            this.setVisible(false);
            this.dispose();
        }
    }

    public String getAudioFileName() {
        return this.audioFileName;
    }

    public void setAudioFileName(String audioFileName) {
        this.audioFileName = audioFileName;
    }

    protected ImageIcon createImageIcon(String path, String description) {
        File imgFile = null;
        try {
            imgFile = new File(path);
            if (imgFile.exists()) {
                String newName = imgFile.getCanonicalPath().replace('\\', '/');
                return new ImageIcon(newName);
            }
            URL newName = Utils.getURL(path, this);
            if (newName == null) {
                newName = EditAudioButtonDialog.class.getResource(path);
            }
            if (newName != null) {
                return new ImageIcon(newName);
            }
            return null;
        }
        catch (Exception e) {
            trace.err("Can't find file" + path);
            return null;
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public String getNewLabel() {
        return this.newLabel;
    }

    public void setNewLabel(String newLabel) {
        this.newLabel = newLabel;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }
}

