/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree;

import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.AdditionNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.ExponentNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.MultiplicationNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.NumberNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.VariableNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTreeProperties;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ExpressionTreeNode {
    private Double eval_value;
    protected ArrayList<ExpressionTreeNode> children;
    protected boolean negated;
    protected boolean stringNeedsRecreation;
    protected String myString;
    protected ExpressionTreeProperties properties;
    static final String[] NodeLevels = new String[]{NumberNode.class.getSimpleName() + " " + VariableNode.class.getSimpleName(), ExponentNode.class.getSimpleName(), MultiplicationNode.class.getSimpleName(), AdditionNode.class.getSimpleName(), ExpressionTreeNode.class.getSimpleName()};
    static final int NNindex = 0;
    static final int VNindex = 0;
    static final int XNindex = 1;
    static final int MNindex = 2;
    static final int ANindex = 3;
    static final int XTNindex = 4;
    private static final int MAX_SIMPLIFY_PASSES = 5;
    protected final int nodeLevel;

    public ExpressionTreeNode(ArrayList<ExpressionTreeNode> children, Boolean negated, ExpressionTreeProperties properties) {
        int i = 0;
        while (!NodeLevels[i].contains(this.getClass().getSimpleName())) {
            ++i;
        }
        this.nodeLevel = i;
        if (this.nodeLevel >= NodeLevels.length) {
            throw new IllegalStateException("Class " + this.getClass().getCanonicalName() + " not found in NodeLevels");
        }
        this.children = children != null ? children : new ArrayList();
        this.myString = "";
        this.stringNeedsRecreation = true;
        this.properties = properties;
        this.negated = negated;
    }

    public String toString() {
        return this.stringNeedsRecreation ? this.myString + '!' : this.myString;
    }

    public boolean isSimpleTerm() {
        return false;
    }

    public void setSimpleTerm(boolean b) {
        if (trace.getDebugCode("simpleterm")) {
            trace.outNT("simpleterm", this.getClass().getSimpleName() + ".setSimpleTerm(" + b + ") isSimpleTerm() " + this.isSimpleTerm());
        }
    }

    public ExpressionTreeNode clone() {
        try {
            throw new CloneNotSupportedException("Superclass ExpressionTreeNode.clone() called");
        }
        catch (Exception e) {
            trace.errStack(e.getMessage() + ": returning null", e);
            return null;
        }
    }

    public void performBasicSimplification(boolean reorderTerms) {
        int i = 0;
        for (i = 0; i < this.children.size(); ++i) {
            this.children.get(i).performBasicSimplification(reorderTerms);
            if (!trace.getDebugCode("functions")) continue;
            trace.out("functions", this.getClass().getSimpleName() + ".performBasicSimplification(child " + i + ") result " + this.children.get(i));
        }
        if (trace.getDebugCode("functions")) {
            trace.out("functions", this.getClass().getSimpleName() + ".performBasicSimplification() result " + this);
        }
    }

    protected void orderTerms() {
        if (this.children != null && this.children.size() > 1) {
            Collections.sort(this.children, new CompareForSort());
        }
    }

    protected ExpressionTreeNode collapseSubTree() {
        try {
            throw new IllegalStateException("Superclass ExpressionTreeNode.collapseSubTree() called");
        }
        catch (Exception e) {
            trace.errStack(e.getMessage() + ": returning null", e);
            return null;
        }
    }

    public ExpressionTreeNode performComplexSimplification() {
        return this.clone();
    }

    protected ExpressionTreeNode attemptCancelTerms(ExpressionTreeNode x) {
        if (x.getNonNegatedString().equals(this.getNonNegatedString())) {
            if (x.negated ^ this.negated) {
                return new NumberNode("-1.0", this.properties);
            }
            return new NumberNode("1.0", this.properties);
        }
        return null;
    }

    protected ExpressionTreeNode additiveCombine(ExpressionTreeNode x) {
        return null;
    }

    protected ExpressionTreeNode mergeMultiplicands(ExpressionTreeNode x) {
        return null;
    }

    protected ExpressionTreeNode cloneAndMultiplyBy(ExpressionTreeNode x) {
        ArrayList<ExpressionTreeNode> products = new ArrayList<ExpressionTreeNode>();
        products.add(this.clone());
        products.add(x.clone());
        MultiplicationNode result = new MultiplicationNode(products, null, false, this.properties);
        return result.performComplexSimplification();
    }

    public Boolean evaluate() {
        return this.eval_internal();
    }

    public void negate() {
        this.negated = !this.negated;
    }

    public Double getEvalValue() {
        return this.eval_value;
    }

    protected void setEvalValue(Double newVal) {
        this.eval_value = newVal;
    }

    protected Boolean eval_internal() {
        return false;
    }

    protected void setString(String s) {
        this.myString = s;
        this.stringNeedsRecreation = false;
    }

    public String getNegatedString() {
        return this.getNegatedString(false);
    }

    protected String getNegatedString(boolean preserveSimpleTerms) {
        String res = this.getNonNegatedString(preserveSimpleTerms);
        if (res != null) {
            if (this.negated) {
                return "-" + res;
            }
            return res;
        }
        return null;
    }

    public String getNonNegatedString() {
        return this.getNonNegatedString(false);
    }

    protected String getNonNegatedString(boolean preserveSimpleTerms) {
        throw new IllegalStateException("superclass ExpressionTreeNode.getNonNegatedString(" + preserveSimpleTerms + ") called");
    }

    private String removeParenMinusSign(String orig) {
        String s = orig.replace("(", "");
        if ((s = s.replace(")", "")).charAt(0) == '-') {
            s = s.substring(1, s.length());
        }
        if (trace.getDebugCode("exprtree")) {
            trace.outNT("exprtree", "XTN.removeParenMinusSign(" + orig + ") => " + s + ";");
        }
        return s;
    }

    public String makeCanonicalWithoutCombining(boolean sort) {
        ExpressionTreeNode copy = this.clone();
        String lastResult = "";
        String result = copy.getNegatedString();
        int oldCount = Integer.MAX_VALUE;
        int count = copy.countNodes();
        for (int i = 0; !lastResult.equals(result) && i < 5; ++i) {
            lastResult = result;
            copy.performBasicSimplification(false);
            copy = copy.removeIdentityOperandsAndDemote(false);
            oldCount = count;
            count = copy.countNodes();
            if (sort) {
                copy.orderTermsRecursive();
            }
            result = copy.getNegatedString();
            if (!trace.getDebugCode("functions")) continue;
            trace.out("functions", "XTN.makeCanonicalWithoutCombining[" + i + "] count " + oldCount + " => " + count + ", result " + lastResult + " => " + result);
        }
        return result;
    }

    public String simplifyWithoutCanonicalWithoutCombining(boolean sort) {
        ExpressionTreeNode copy = this.clone();
        String lastResult = "";
        String result = copy.getNegatedString();
        int oldCount = Integer.MAX_VALUE;
        int count = copy.countNodes();
        for (int i = 0; !lastResult.equals(result) && i < 5; ++i) {
            lastResult = result;
            copy.performBasicSimplification(false);
            copy = copy.removeIdentityOperandsAndDemote(true);
            oldCount = count;
            count = copy.countNodes();
            if (sort) {
                copy.orderTermsRecursive();
            }
            result = copy.getNegatedString(true);
            if (!trace.getDebugCode("functions")) continue;
            trace.out("functions", "XTN.simplifyWithoutCanonicalWithoutCombining[" + i + "] count " + oldCount + " => " + count + ", result " + lastResult + " => " + result);
        }
        return result;
    }

    public String makeCanonical(boolean sort) {
        ExpressionTreeNode copy = this.clone();
        String lastResult = "";
        String result = copy.getNegatedString();
        int oldCount = Integer.MAX_VALUE;
        int count = copy.countNodes();
        for (int i = 0; !lastResult.equals(result) && i < 5; ++i) {
            lastResult = result;
            copy = copy.performComplexSimplification();
            oldCount = count;
            count = copy.countNodes();
            if (sort) {
                copy.orderTermsRecursive();
            }
            result = copy.getNegatedString();
            if (!trace.getDebugCode("functions")) continue;
            trace.out("functions", "XTN.makeCanonical[" + i + "] count " + oldCount + " => " + count + ", result " + lastResult + " => " + result);
        }
        return result;
    }

    public int countNodes() {
        int[] total = new int[1];
        return this.count(total);
    }

    protected int count(int[] total) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).count(total);
        }
        total[0] = total[0] + 1;
        return total[0];
    }

    protected ExpressionTreeNode removeIdentityOperandsAndDemote(boolean simpleTermsOnly) {
        try {
            throw new IllegalStateException("Superclass ExpressionTreeNode.removeIdentityOperandsAndDemote() called");
        }
        catch (Exception e) {
            trace.errStack(e.getMessage() + ": returning null", e);
            return null;
        }
    }

    protected boolean isIdentity(ExpressionTreeNode operand, boolean[] negated) {
        try {
            throw new IllegalStateException(this.getClass().getSimpleName() + ".isIdentity(" + operand + ") called");
        }
        catch (Exception e) {
            trace.errStack(e.getMessage() + ": returning false", e);
            return false;
        }
    }

    protected String toCanonicalString(int callerLevel) {
        try {
            throw new IllegalStateException("Superclass ExpressionTreeNode.toCanonicalString(" + callerLevel + ") called");
        }
        catch (Exception e) {
            trace.errStack(e.getMessage() + ": returning null", e);
            return null;
        }
    }

    public int getNodeLevel() {
        return this.nodeLevel;
    }

    protected void orderTermsRecursive() {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).orderTermsRecursive();
        }
        Collections.sort(this.children, new CompareTerms(false));
        this.stringNeedsRecreation = true;
        if (trace.getDebugCode("functions")) {
            trace.out("functions", this.getClass().getSimpleName() + ".orderTermsRecursive() result: " + this.toCanonicalString(4));
        }
    }

    protected class CompareTerms
    implements Comparator<ExpressionTreeNode> {
        private boolean sortCoefficientsFirst = false;

        public CompareTerms(boolean sortCoefficientsFirst) {
            this.sortCoefficientsFirst = sortCoefficientsFirst;
        }

        @Override
        public int compare(ExpressionTreeNode c0, ExpressionTreeNode c1) {
            Integer result;
            String s0 = ExpressionTreeNode.this.removeParenMinusSign(c0.toCanonicalString(NodeLevels.length));
            String s1 = ExpressionTreeNode.this.removeParenMinusSign(c1.toCanonicalString(NodeLevels.length));
            if (s0 != null && s0.equals(s1)) {
                if (c0.negated == c1.negated) {
                    Integer n = new Integer(0);
                }
                result = c1.negated ? new Integer(1) : new Integer(-1);
            } else {
                Boolean is0NumberNode = c0.getClass().equals(NumberNode.class);
                Boolean is1NumberNode = c1.getClass().equals(NumberNode.class);
                if (is0NumberNode.booleanValue() && is1NumberNode.booleanValue()) {
                    NumberNode n0 = (NumberNode)c0;
                    NumberNode n1 = (NumberNode)c1;
                    result = new Integer(Double.compare(n1.getNonNegatedValue(), n0.getNonNegatedValue()));
                } else {
                    result = is0NumberNode ^ is1NumberNode ? (this.sortCoefficientsFirst ? new Integer(is0NumberNode != false ? -1 : 1) : new Integer(is0NumberNode != false ? 1 : -1)) : new Integer(s1.compareTo(s0));
                }
            }
            if (trace.getDebugCode("exprtree")) {
                trace.outNT("exprtree", "ExpressionTreeNode.CompareTerms(" + s0 + "," + s1 + ") returns " + result);
            }
            return result;
        }
    }

    protected class CompareForSort
    implements Comparator<ExpressionTreeNode> {
        protected CompareForSort() {
        }

        @Override
        public int compare(ExpressionTreeNode c0, ExpressionTreeNode c1) {
            String s0 = ExpressionTreeNode.this.removeParenMinusSign(c0.getNonNegatedString());
            String s1 = ExpressionTreeNode.this.removeParenMinusSign(c1.getNonNegatedString());
            if (trace.getDebugCode("exprtree")) {
                trace.outNT("exprtree", "ExpressionTreeNode.CompareForSort(" + s0 + "," + s1 + ")");
            }
            if (s0 != null && s0.equals(s1)) {
                if (c0.negated == c1.negated) {
                    return 0;
                }
                if (c1.negated) {
                    return 1;
                }
                return -1;
            }
            Boolean is0NumberNode = c0.getClass().equals(NumberNode.class);
            Boolean is1NumberNode = c1.getClass().equals(NumberNode.class);
            if (is0NumberNode ^ is1NumberNode) {
                if (is0NumberNode.booleanValue()) {
                    return 1;
                }
                return -1;
            }
            return s1.compareTo(s0);
        }
    }
}

