/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RegexMatcher
extends Matcher {
    Element element;
    protected Document doc;
    protected Element selectionElement;
    protected Element actionElement;
    protected Element inputElement;
    protected Element actorElement;
    protected Element singleElement;
    private String inputPattern;
    private String selectionPattern;
    private String actionPattern;
    private String singlePattern;
    private String actor;
    private Pattern inputPatternObj;
    private Pattern selectionPatternObj;
    private Pattern actionPatternObj;
    private Pattern singlePatternObj;
    protected Element type;

    public RegexMatcher(boolean concat2, int vector, String value) {
        super(concat2, vector);
        this.setSinglePattern(value);
    }

    public RegexMatcher() {
        this.initXML();
    }

    private void initXML() {
        this.element = new Element("matcher");
        this.type = new Element("matcherType");
        this.type.addContent("RegexMatcher");
        this.element.addContent((Content)this.type);
        this.selectionElement = new Element("matcherParameter");
        this.actionElement = new Element("matcherParameter");
        this.inputElement = new Element("matcherParameter");
        this.actorElement = new Element("matcherParameter");
        this.element.addContent((Content)this.selectionElement);
        this.element.addContent((Content)this.actionElement);
        this.element.addContent((Content)this.inputElement);
        this.element.addContent((Content)this.actorElement);
        this.doc = new Document(this.element);
    }

    @Override
    public Object clone() {
        RegexMatcher m = new RegexMatcher(this.concat, this.vector, this.getSinglePattern());
        m.copyFrom(this);
        return m;
    }

    protected void copyFrom(RegexMatcher m) {
        super.copyFrom(m);
        this.initXML();
        this.setSelectionPattern(m.getSelectionPattern());
        this.setActionPattern(m.getActionPattern());
        this.setInputPattern(m.getInputPattern());
        this.setActorPattern(m.getActorPattern());
    }

    @Override
    public String toXML() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLOutputter outp = new XMLOutputter(Format.getPrettyFormat());
            outp.output(this.doc, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String newString = out.toString();
        newString = newString.substring(newString.indexOf("\n"), newString.length());
        return newString;
    }

    @Override
    public String toXML(String prefix) {
        String xml = this.toXML();
        xml = prefix + xml;
        xml = xml.replaceAll("\n", "\n" + prefix);
        return xml;
    }

    @Override
    protected boolean matchAction(Vector action) {
        java.util.regex.Matcher actionMatcher = this.actionPatternObj.matcher((String)action.get(0));
        return actionMatcher.matches();
    }

    @Override
    protected boolean matchInput(Vector input) {
        java.util.regex.Matcher inputMatcher = this.inputPatternObj.matcher((String)input.get(0));
        return inputMatcher.matches();
    }

    @Override
    protected boolean matchSelection(Vector selection) {
        java.util.regex.Matcher selectionMatcher = this.selectionPatternObj.matcher((String)selection.get(0));
        return selectionMatcher.matches();
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input) {
        java.util.regex.Matcher selectionMatcher = this.selectionPatternObj.matcher((String)selection.get(0));
        java.util.regex.Matcher actionMatcher = this.actionPatternObj.matcher((String)action.get(0));
        java.util.regex.Matcher inputMatcher = this.inputPatternObj.matcher((String)input.get(0));
        boolean value = selectionMatcher.matches() && actionMatcher.matches() && inputMatcher.matches();
        return value;
    }

    @Override
    public boolean matchForHint(Vector selection, Vector action, String actor, VariableTable vt) {
        java.util.regex.Matcher selectionMatcher = this.selectionPatternObj.matcher((String)selection.get(0));
        java.util.regex.Matcher actionMatcher = action == null ? null : this.actionPatternObj.matcher((String)action.get(0));
        return this.matchActor(actor) && selectionMatcher.matches() && (action == null || actionMatcher.matches());
    }

    @Override
    public boolean matchConcatenation(Vector s) {
        return this.matchSingle(RegexMatcher.vector2ConcatString(s));
    }

    @Override
    public boolean matchSingle(String s) {
        java.util.regex.Matcher m = this.singlePatternObj.matcher(s);
        boolean match = m.matches();
        return match;
    }

    @Override
    protected void setParameterInternal(Element element2, int index) {
        this.setParameterByIndex(element2.getText(), index);
    }

    @Override
    public void setParameterByIndex(String stringValue, int index) {
        if (this.concat && index == 0) {
            this.setSinglePattern(stringValue);
            return;
        }
        if (index == 0) {
            this.setSelectionPattern(stringValue);
        } else if (index == 1) {
            this.setActionPattern(stringValue);
        } else if (index == 2) {
            this.setInputPattern(stringValue);
        } else if (index == 3) {
            this.setActorPattern(stringValue);
        } else {
            throw new UnknownError("Parameter index " + index + " not recognized.");
        }
    }

    @Override
    public void setParameter(Element element2, int index) {
        String name = element2.getAttributeValue("name");
        if (name == null || name.length() == 0) {
            this.setParameterInternal(element2, index);
        } else if (name.equalsIgnoreCase("selection")) {
            this.setSelectionPattern(element2.getText());
        } else if (name.equalsIgnoreCase("action")) {
            this.setActionPattern(element2.getText());
        } else if (name.equalsIgnoreCase("input")) {
            this.setInputPattern(element2.getText());
        } else if (name.equalsIgnoreCase("actor")) {
            this.setActorPattern(element2.getText());
        } else {
            this.setParameterByIndex(element2.getText(), index);
        }
    }

    @Override
    public Object getParameter(int index) {
        if (this.single) {
            if (index == 0) {
                return this.getSinglePattern();
            }
            return null;
        }
        switch (index) {
            case 0: {
                return this.getSelectionPattern();
            }
            case 1: {
                return this.getActionPattern();
            }
            case 2: {
                return this.getInputPattern();
            }
            case 3: {
                return this.getActorPattern();
            }
        }
        return null;
    }

    @Override
    public int getParameterCount() {
        return this.single ? 1 : 4;
    }

    @Override
    public Matcher.MatcherParameter getMatcherParameter(int index) {
        if (this.single) {
            return new Matcher.MatcherParameter("single", this.getParameter(index));
        }
        return super.getMatcherParameter(index);
    }

    public void setSinglePattern(String singlePattern) {
        if (singlePattern == null) {
            return;
        }
        this.singlePattern = singlePattern;
        this.singlePatternObj = this.cacheCompile(singlePattern, 32);
    }

    public void setInputPattern(String inputPattern) {
        this.inputPattern = inputPattern;
        this.inputPatternObj = this.cacheCompile(inputPattern);
        this.inputElement.addContent(inputPattern);
    }

    @Override
    public void setSingle(String single) {
        this.setSinglePattern(single);
    }

    public void setActionPattern(String actionPattern) {
        this.actionPattern = actionPattern;
        this.actionPatternObj = this.cacheCompile(actionPattern);
        this.actionElement.addContent(actionPattern);
    }

    public void setSelectionPattern(String selectionPattern) {
        this.selectionPattern = selectionPattern;
        this.selectionPatternObj = this.cacheCompile(selectionPattern);
        this.selectionElement.addContent(selectionPattern);
    }

    protected Pattern cacheCompile(String regexp) {
        return this.cacheCompile(regexp, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pattern cacheCompile(String regexp, int flags) throws IllegalArgumentException {
        Map<String, Object> ss = this.getSessionStorage();
        try {
            if (ss == null) {
                return Pattern.compile(regexp, flags);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad regular expression \"" + regexp + "\"", e);
        }
        String psName = this.getClass().getName();
        Map<String, Pattern> ps = null;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            ps = (Map<String, Pattern>)ss.get(psName);
            if (ps == null) {
                ps = Collections.synchronizedMap(new HashMap());
                ss.put(psName, ps);
            }
        }
        String key = Integer.toString(flags) + ' ' + regexp;
        Pattern p = (Pattern)ps.get(key);
        if (p == null) {
            try {
                p = Pattern.compile(regexp, flags);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Bad regular expression \"" + regexp + "\"", e);
            }
            ps.put(key, p);
            if (trace.getDebugCode("matchers")) {
                trace.outNT("matchers", "RegexMatcher.cacheCompile(\"" + regexp + "\"): new");
            }
        } else if (trace.getDebugCode("matchers")) {
            trace.outNT("matchers", "RegexMatcher.cacheCompile(\"" + regexp + "\"): existing");
        }
        return p;
    }

    public void setActorPattern(String actor) {
        this.actor = actor;
        this.actorElement.removeContent();
        this.actorElement.addContent(actor);
    }

    public String getActionPattern() {
        return this.actionPattern;
    }

    public String getSelectionPattern() {
        return this.selectionPattern;
    }

    public String getInputPattern() {
        return this.inputPattern;
    }

    @Override
    public String getSelectionLabelText() {
        return this.getSelectionPattern();
    }

    @Override
    public String getActionLabelText() {
        return this.getActionPattern();
    }

    @Override
    public String getInputLabelText() {
        return this.getInputPattern();
    }

    @Override
    public String getSingleLabelText() {
        return this.getSinglePattern();
    }

    public String getActorPattern() {
        return this.actor;
    }

    public String getSinglePattern() {
        return this.singlePattern;
    }

    @Override
    public String getMatcherType() {
        return "Regular Expression Match";
    }

    @Override
    public String getMatcherTypeText() {
        return "Regex";
    }

    @Override
    public String getMatcherClassType() {
        return "RegexMatcher";
    }

    public String toString() {
        if (this.single) {
            return this.singlePattern;
        }
        return super.toString();
    }

    @Override
    public String[] getValuesVector() {
        return this.singlePattern.split("\n", -1);
    }

    @Override
    public String getActionMatcherType() {
        return this.getMatcherTypeText();
    }

    @Override
    public String getInputMatcherType() {
        return this.getMatcherTypeText();
    }

    @Override
    public String getSelectionMatcherType() {
        return this.getMatcherTypeText();
    }
}

