/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.SolutionStateModel;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.SolutionStateModel.TraversedLinkObject;
import edu.cmu.pact.BehaviorRecorder.SolutionStateModel.TraversedLinksModel;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MessagePlayer;
import edu.cmu.pact.ctat.model.CtatModeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import pact.CommWidgets.JCommWidget;

public class ProcessTraversedLinks {
    TraversedLinksModel traversedLinksModel;
    private final String LINK_NAME_PREFIX = "link_";
    private final int NON_VALID_ID = -999;
    private BR_Controller controller;

    public ProcessTraversedLinks(BR_Controller controller) {
        this.traversedLinksModel = new TraversedLinksModel(controller);
        this.controller = controller;
    }

    public void saveTraversedLinks_Tofile(String traversedLinksFileName) {
        this.traversedLinksModel.saveTraversedLinks_Tofile(traversedLinksFileName);
    }

    public String getTraversedLinks_asXML() {
        return this.traversedLinksModel.getTraversedLinks_asXML();
    }

    public void initTraversedLinks() {
        if (trace.getDebugCode("br")) {
            trace.out("br", "initTraversedLinks()");
        }
        this.traversedLinksModel.initDom();
    }

    public void loadTraversedLinks_Fromfile(String traversedLinksFileName) {
        this.traversedLinksModel.loadTraversedLinks_Fromfile(traversedLinksFileName);
        Vector<String> nameList = this.traversedLinksModel.getTraversedLinkNodesNames();
        if (nameList.size() == 0) {
            this.traversedLinksModel.initDom();
            return;
        }
        ProblemNode lastVisitedNode = this.controller.getSolutionState().getCurrentNode();
        MessageObject commMsgObj = null;
        Object propertyNames = null;
        Object propertyValues = null;
        int maxLabelID = 0;
        for (int i = 0; i < nameList.size(); ++i) {
            ProblemNode newNode;
            Vector<String> input;
            Vector<String> action;
            Vector<String> selection;
            ProblemEdge tempEdge;
            String tempName = nameList.elementAt(i);
            int tempID = this.getUniqueIDFromLinkName(tempName);
            if (tempID == -999) {
                trace.err("link name " + tempName + " has no valid id number");
                continue;
            }
            if (maxLabelID < tempID) {
                maxLabelID = tempID;
            }
            if ((tempEdge = this.controller.getProblemModel().getEdge(tempID)) != null) {
                EdgeData myEdge = tempEdge.getEdgeData();
                String authorIntent = myEdge.getActionType();
                selection = myEdge.getSelection();
                action = myEdge.getAction();
                input = myEdge.getInput();
                if (authorIntent.equalsIgnoreCase("Correct Action")) {
                    this.controller.sendCorrectActionMsg(selection, input, action);
                } else if (authorIntent.equalsIgnoreCase("Fireable Buggy Action")) {
                    this.controller.sendIncorrectActionMsg(selection, input, action);
                }
                if (!this.controller.getCtatModeModel().isJessMode() && !this.controller.getCtatModeModel().isTDKMode()) continue;
                lastVisitedNode = tempEdge.getNodes()[1];
                continue;
            }
            if (tempEdge != null) continue;
            TraversedLinkObject traversedLinkObject = this.traversedLinksModel.getTraversedLinkObject(tempName);
            if (traversedLinkObject == null) {
                trace.err("Cannot find traversedLinkObject for name " + tempName);
                continue;
            }
            commMsgObj = traversedLinkObject.getCommMsgObj();
            selection = commMsgObj.getSelection();
            action = commMsgObj.getAction();
            input = commMsgObj.getInput();
            lastVisitedNode = newNode = this.controller.addNewState(lastVisitedNode, selection, action, input, commMsgObj, traversedLinkObject.getAuthorIntent());
        }
        if (lastVisitedNode != this.controller.getSolutionState().getCurrentNode()) {
            this.controller.setCurrentNode(lastVisitedNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTraversedLinks_FromXML(String currentState) {
        this.traversedLinksModel.loadTraversedLinks_FromXML(currentState);
        Vector nodeList = this.traversedLinksModel.getTraversedLinkNodes();
        if (nodeList.size() == 0) {
            this.traversedLinksModel.initDom();
            return;
        }
        ArrayList<MessageObject> list = new ArrayList<MessageObject>();
        for (int i = 0; i < nodeList.size(); ++i) {
            TraversedLinkObject node = (TraversedLinkObject)nodeList.elementAt(i);
            if (node == null) continue;
            int nodeID = node.getUniqueID();
            if (nodeID == -999) {
                trace.out(5, this, "link name has no valid id number");
                continue;
            }
            MessageObject message = node.getCommMsgObj();
            if (trace.getDebugCode("br")) {
                trace.out("br", "loadTraversedLinks_FromXML: message = " + message);
            }
            list.add(message);
        }
        MessagePlayer player = new MessagePlayer(this.controller, list, true, null);
        player.setForwardToClientProxy(this.controller.getUniversalToolProxy());
        try {
            this.controller.setHintMode(false);
            this.controller.getLoggingSupport().setEnableLog(false);
            player.run();
        }
        finally {
            this.controller.setHintMode(true);
            this.controller.getLoggingSupport().setEnableLog(true);
        }
    }

    private int getUniqueIDFromLinkName(String linkName) {
        if (linkName == null) {
            return -999;
        }
        if (linkName.equals("")) {
            return -999;
        }
        int index = linkName.indexOf("link_");
        if (index < 0) {
            return -999;
        }
        String idString = linkName.substring("link_".length());
        return Integer.valueOf(idString);
    }

    public void addLinkNode(int uniqueID, Vector selection, Vector action, Vector input, String actionType) {
        MessageObject messageObject = this.createInterfaceAction(selection, action, input);
        this.traversedLinksModel.addLinkNode("link_" + uniqueID, messageObject, actionType, uniqueID);
    }

    public void addLinkNode(ProblemEdge edge, MessageObject messageObject, String checkResult) {
        EdgeData edgeData = edge.getEdgeData();
        String authorIntent = EdgeData.checkResultToActionType(checkResult);
        if (authorIntent == null || authorIntent.length() < 1) {
            authorIntent = edgeData.getActionType();
        }
        if (!authorIntent.equalsIgnoreCase("Correct Action") && !authorIntent.equalsIgnoreCase("Fireable Buggy Action")) {
            return;
        }
        if (messageObject == null) {
            messageObject = edgeData.getDemoMsgObj();
        }
        int uniqueID = edgeData.getUniqueID();
        this.traversedLinksModel.addLinkNode("link_" + uniqueID, messageObject, authorIntent, uniqueID);
    }

    public MessageObject createInterfaceAction(Vector selection, Vector action, Vector input) {
        if (selection == null || selection.isEmpty() || input == null || input.isEmpty()) {
            return null;
        }
        MessageObject result = MessageObject.create("InterfaceAction", "NotePropertySet");
        if (action == null) {
            action = new Vector<String>();
        }
        if (action.size() < 1 && this.controller.getProblemModel().isUseCommWidgetFlag()) {
            for (int i = 0; i < selection.size(); ++i) {
                String selectionName = (String)selection.elementAt(i);
                JCommWidget d = this.controller.getCommWidget(selectionName);
                if (d == null) continue;
                action.addElement(d.getActionName());
            }
        }
        result.setSelection(selection);
        result.setAction(action);
        result.setInput(input);
        return result;
    }

    public int retractLinksFromTail(int nToDelete) {
        int result = this.traversedLinksModel.deleteLinksFromTail(nToDelete);
        Vector linkNodes = this.traversedLinksModel.getTraversedLinkNodes();
        if (trace.getDebugCode("br")) {
            trace.out("br", "retractLinksFromTail(): nToDelete " + nToDelete + ", nRemaining " + linkNodes.size());
        }
        this.controller.goToStartState();
        if (linkNodes.size() < 1) {
            return result;
        }
        CtatModeModel mm = this.controller.getCtatModeModel();
        if (mm != null && mm.isRuleEngineTracing()) {
            this.goToWmState(linkNodes);
        } else {
            int i = 0;
            for (TraversedLinkObject tlo : linkNodes) {
                this.controller.handleCommMessage(tlo.getCommMsgObj());
                ++i;
            }
        }
        return result;
    }

    private int goToWmState(List linkNodes) {
        if (linkNodes.size() < 1) {
            trace.err("ProcessedTraversedLinks.goToWmState(): empty link list");
            return 0;
        }
        Vector<Vector> selectionList = new Vector<Vector>();
        Vector<Vector> actionList = new Vector<Vector>();
        Vector<Vector> inputList = new Vector<Vector>();
        Vector<String> authorIntentList = new Vector<String>();
        Vector<Integer> uniqueIDList = new Vector<Integer>();
        int i = 0;
        String errMsg = null;
        for (TraversedLinkObject linkNode : linkNodes) {
            MessageObject msg = linkNode.getCommMsgObj();
            Vector selection = (Vector)msg.getProperty("Selection");
            Vector action = (Vector)msg.getProperty("Action");
            Vector input = (Vector)msg.getProperty("Input");
            if (selection == null) {
                errMsg = "selection[" + i + "] is null";
                break;
            }
            if (action == null) {
                errMsg = "action[" + i + "] is null";
                break;
            }
            if (input == null) {
                errMsg = "input[" + i + "] is null";
                break;
            }
            selectionList.add(selection);
            actionList.add(action);
            inputList.add(input);
            authorIntentList.add(linkNode.getAuthorIntent());
            uniqueIDList.add(new Integer(linkNode.getUniqueID()));
            ++i;
        }
        if (i < linkNodes.size()) {
            trace.err("ProcessTraversedLinks: failed to Go_To_WM_State due to problem at link " + i + ": " + errMsg);
            return 0;
        }
        this.controller.sendGo_To_WM_State(selectionList, actionList, inputList, authorIntentList, uniqueIDList, true);
        return i;
    }

    public List getCommMsgs() {
        return this.traversedLinksModel.getCommMsgs();
    }
}

