/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATComponentBase;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATParameter;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSAI;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializable;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATStyleProperty;
import edu.cmu.pact.Utilities.EmptyIterator;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class CTATComponent
extends CTATComponentBase {
    private Map<String, String> attrsMap = new HashMap<String, String>();
    private float x = 0.0f;
    private float y = 0.0f;
    private float width = 16.0f;
    private float height = 20.0f;
    private int previewX = 0;
    private int previewY = 0;
    private int previewWidth = 0;
    private int previewHeight = 0;
    private Boolean selected = false;
    private ArrayList<CTATSAI> SAIs = null;
    private ArrayList<CTATParameter> parameters = null;
    private ArrayList<CTATStyleProperty> styles = null;
    private JCheckBox checker = null;

    public CTATComponent() {
        this.setClassName("CTATComponent");
        this.setClassType("CTATComponent");
        this.debug("CTATComponent ()");
        this.SAIs = new ArrayList();
        this.parameters = new ArrayList();
        this.styles = new ArrayList();
    }

    public void setChecker(JCheckBox aChecker) {
        this.checker = aChecker;
    }

    public JCheckBox getChecker() {
        return this.checker;
    }

    public ArrayList<CTATSAI> getSAIs() {
        return this.SAIs;
    }

    public void setSelected(Boolean aValue) {
        this.selected = aValue;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setPreviewDimensions(int aX, int aY, int aWidth, int aHeight) {
        this.previewX = aX;
        this.previewY = aY;
        this.previewWidth = aWidth;
        this.previewHeight = aHeight;
    }

    public void setPreviewX(int previewX) {
        this.previewX = previewX;
    }

    public int getPreviewX() {
        return this.previewX;
    }

    public void setPreviewY(int previewY) {
        this.previewY = previewY;
    }

    public int getPreviewY() {
        return this.previewY;
    }

    public void setPreviewWidth(int previewWidth) {
        this.previewWidth = previewWidth;
    }

    public int getPreviewWidth() {
        return this.previewWidth;
    }

    public void setPreviewHeight(int previewHeight) {
        this.previewHeight = previewHeight;
    }

    public int getPreviewHeight() {
        return this.previewHeight;
    }

    public void setX(String aValue) {
        this.debug("setX (" + aValue + ")");
        this.x = Float.parseFloat(aValue);
        this.debug("this.x: " + this.x);
    }

    public void setX(float aValue) {
        this.x = aValue;
    }

    public float getX() {
        return this.x;
    }

    public void setY(String aValue) {
        this.debug("setY (" + aValue + ")");
        this.y = Float.parseFloat(aValue);
        this.debug("this.y: " + this.y);
    }

    public void setY(float aValue) {
        this.y = aValue;
    }

    public float getY() {
        return this.y;
    }

    public void setWidth(String aValue) {
        this.debug("setWidth (" + aValue + ")");
        try {
            this.setWidth(Float.parseFloat(aValue));
        }
        catch (Exception e) {
            trace.err("CTATComponent.setWidth() invalid number \"" + aValue + "\": " + e);
        }
        this.debug("this.width: " + this.width);
    }

    public void setWidth(float aValue) {
        this.width = aValue;
    }

    public float getWidth() {
        return this.width;
    }

    public void setHeight(String aValue) {
        this.debug("setHeight (" + aValue + ")");
        try {
            this.setHeight(Float.parseFloat(aValue));
        }
        catch (Exception e) {
            trace.err("CTATComponent.setHeight() invalid number \"" + aValue + "\": " + e);
        }
        this.debug("this.height: " + this.height);
    }

    public void setHeight(float aValue) {
        this.height = aValue;
    }

    public float getHeight() {
        return this.height;
    }

    public ArrayList<CTATParameter> getParameters() {
        return this.parameters;
    }

    public ArrayList<CTATStyleProperty> getStyleProperties() {
        return this.styles;
    }

    public String getAllSAIsXML() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.SAIs.size(); ++i) {
            CTATSAI SAI = this.SAIs.get(i);
            buffer.append("<selection>");
            buffer.append(SAI.toString());
            buffer.append("</selection>");
        }
        return buffer.toString();
    }

    public String getAllComponentParametersXML(Boolean isTouched) {
        StringBuffer buffer = new StringBuffer();
        if (isTouched.booleanValue()) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                CTATParameter parameter = this.parameters.get(i);
                if (!parameter.getTouched().booleanValue()) continue;
                buffer.append("<selection>");
                buffer.append(parameter.toString());
                buffer.append("</selection>");
            }
        } else {
            for (int i = 0; i < this.parameters.size(); ++i) {
                CTATParameter parameter = this.parameters.get(i);
                buffer.append("<selection>");
                buffer.append(parameter.toString());
                buffer.append("</selection>");
            }
        }
        return buffer.toString();
    }

    public String getAllStylePropertiesXML(boolean isTouched) {
        StringBuffer buffer = new StringBuffer();
        if (isTouched) {
            for (int i = 0; i < this.styles.size(); ++i) {
                CTATStyleProperty style = this.styles.get(i);
                if (!style.getTouched().booleanValue()) continue;
                buffer.append("<selection>");
                buffer.append(style.toString());
                buffer.append("</selection>");
            }
        } else {
            for (int i = 0; i < this.styles.size(); ++i) {
                CTATStyleProperty style = this.styles.get(i);
                buffer.append("<selection>");
                buffer.append(style.toString());
                buffer.append("</selection>");
            }
        }
        return buffer.toString();
    }

    public void getAllParameterElements(Element root, Boolean isTouched, CTATSerializable.IncludeIn includeIn) {
        if (isTouched.booleanValue()) {
            Element paramSelection = new Element("selection");
            root.addContent((Content)paramSelection);
            for (int i = 0; i < this.parameters.size(); ++i) {
                CTATParameter parameter = this.parameters.get(i);
                if (!parameter.getTouched().booleanValue() || parameter.getIncludeIn().compareTo(includeIn) > 0) continue;
                paramSelection.addContent((Content)parameter.toStringElement());
            }
        } else {
            Element paramSelection = new Element("selection");
            root.addContent((Content)paramSelection);
            for (int i = 0; i < this.parameters.size(); ++i) {
                CTATParameter parameter = this.parameters.get(i);
                if (parameter.getIncludeIn().compareTo(includeIn) > 0) continue;
                paramSelection.addContent((Content)parameter.toStringElement());
            }
        }
    }

    public void getAllStyleElements(Element root, Boolean isTouched, CTATSerializable.IncludeIn includeIn) {
        if (isTouched.booleanValue()) {
            Element styleSelection = new Element("selection");
            root.addContent((Content)styleSelection);
            for (int i = 0; i < this.styles.size(); ++i) {
                CTATStyleProperty style = this.styles.get(i);
                if (!style.getTouched().booleanValue() || style.getIncludeIn().compareTo(includeIn) > 0) continue;
                styleSelection.addContent((Content)style.toStringElement());
            }
        } else {
            Element styleSelection = new Element("selection");
            root.addContent((Content)styleSelection);
            for (int i = 0; i < this.styles.size(); ++i) {
                CTATStyleProperty style = this.styles.get(i);
                if (style.getIncludeIn().compareTo(includeIn) > 0) continue;
                styleSelection.addContent((Content)style.toStringElement());
            }
        }
    }

    @Override
    public String toString() {
        this.debug("toString ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClassOpen(this.getInstanceName()));
        buffer.append("<Parameters>");
        buffer.append(this.getAllComponentParametersXML(false));
        buffer.append("</Parameters>");
        buffer.append("<Styles>");
        buffer.append(this.getAllStylePropertiesXML(false));
        buffer.append("</Styles>");
        buffer.append(this.getClassClose());
        return buffer.toString();
    }

    public String toStringTouched() {
        this.debug("toStringTouched ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClassOpen(this.getInstanceName()));
        buffer.append("<Parameters>");
        buffer.append(this.getAllComponentParametersXML(true));
        buffer.append("</Parameters>");
        buffer.append("<Styles>");
        buffer.append(this.getAllStylePropertiesXML(true));
        buffer.append("</Styles>");
        buffer.append(this.getClassClose());
        return buffer.toString();
    }

    public Element toStringElement(CTATSerializable.IncludeIn includeIn) {
        Element parameterElement;
        this.debug("toStringElement (" + (Object)((Object)includeIn) + ")");
        Element newElement = this.getClassElement();
        if (includeIn == CTATSerializable.IncludeIn.full) {
            parameterElement = new Element("s");
            newElement.addContent((Content)parameterElement);
        }
        parameterElement = new Element("Parameters");
        newElement.addContent((Content)parameterElement);
        this.getAllParameterElements(parameterElement, false, includeIn);
        Element styleElement = new Element("Styles");
        newElement.addContent((Content)styleElement);
        this.getAllStyleElements(styleElement, false, includeIn);
        return newElement;
    }

    @Override
    protected Element getClassElement() {
        Element result = super.getClassElement(this.getInstanceName());
        for (String name : this.attrsMap.keySet()) {
            result.setAttribute(name, this.attrsMap.get(name));
        }
        return result;
    }

    public Element toStringElementTouched() {
        this.debug("toStringElementTouched ()");
        Element newElement = this.getClassElement(this.getInstanceName());
        Element parameterElement = new Element("Parameters");
        newElement.addContent((Content)parameterElement);
        this.getAllParameterElements(parameterElement, true, CTATSerializable.IncludeIn.full);
        Element styleElement = new Element("Styles");
        newElement.addContent((Content)styleElement);
        this.getAllStyleElements(styleElement, true, CTATSerializable.IncludeIn.full);
        this.debug("Returning fresh element ...");
        return newElement;
    }

    @Override
    public void fromXML(Element node) {
        Iterator it;
        this.debug("fromXML (" + (node == null ? null : node.getName()) + ")");
        if (node == null) {
            return;
        }
        this.setClassType(node.getName());
        Iterator itr = node.getChildren().iterator();
        this.debug("Parsing attributes ...");
        List attrs = node.getAttributes();
        Iterator iterator = it = attrs == null ? EmptyIterator.instance() : attrs.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            this.debug(String.format("  %-17s = \"%s\"", attr.getName(), attr.getValue()));
            this.attrsMap.put(attr.getName(), attr.getValue());
        }
        this.setInstanceName(this.attrsMap.get("name"));
        this.setX(this.attrsMap.get("x"));
        this.setY(this.attrsMap.get("y"));
        this.setWidth(this.attrsMap.get("width"));
        this.setHeight(this.attrsMap.get("height"));
        while (itr.hasNext()) {
            Element elem = (Element)itr.next();
            if (elem.getName().equals("SAIs")) {
                this.debug("Parsing SAIs");
                for (Element SAIElement : ((Element)elem.getChildren().get(0)).getChildren()) {
                    CTATSAI SAI = new CTATSAI();
                    SAI.fromXML(SAIElement);
                    this.SAIs.add(SAI);
                }
            }
            if (elem.getName().equals("Parameters")) {
                this.debug("Parsing Parameters");
                for (Element ParameterElement : ((Element)elem.getChildren().get(0)).getChildren()) {
                    CTATParameter parameter = new CTATParameter();
                    parameter.fromXML(ParameterElement);
                    this.parameters.add(parameter);
                }
            }
            if (!elem.getName().equals("Styles")) continue;
            this.debug("Parsing Styles");
            for (Element StyleElement : ((Element)elem.getChildren().get(0)).getChildren()) {
                CTATStyleProperty styleProperty = new CTATStyleProperty();
                styleProperty.fromXML(StyleElement);
                this.styles.add(styleProperty);
            }
        }
    }

    public static void editInterfaceDescriptionMessage(MessageObject mo, CTATSerializable.IncludeIn includeIn) {
        if (!"InterfaceDescription".equalsIgnoreCase(mo.getMessageType())) {
            return;
        }
        Element compElt = (Element)mo.getProperty("serialized");
        if (compElt == null) {
            return;
        }
        CTATComponent comp = new CTATComponent();
        comp.fromXML(compElt);
        mo.setProperty("serialized", comp.toStringElement(includeIn));
    }
}

