/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Tab;

import edu.cmu.pact.BehaviorRecorder.Controller.AuthorHTTPSession;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.Controller.SingleSessionLauncher;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTab;
import edu.cmu.pact.Log.LogConsole;
import edu.cmu.pact.SocketProxy.SocketProxy;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctatview.DockManager;
import java.io.BufferedReader;
import java.io.File;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.infonode.docking.OperationAbortedException;
import pact.CommWidgets.RemoteProxy;
import pact.CommWidgets.RemoteToolProxy;
import pact.CommWidgets.UniversalToolProxy;

public class CTATTabManager {
    private final List<CTATTab> tabList;
    private int nextTabNumber;
    private final CTAT_Launcher server;
    private String[] argv;
    private CTATTab focusedTab;
    private static int MAX_TABS = 5;
    private static int NUM_TABS = 0;
    private int numLogConsoles = 0;
    private HashMap<JMenuItem, boolean[]> menuItems = new HashMap();

    public CTATTabManager(CTAT_Launcher server, String[] argv) {
        this.argv = argv;
        this.tabList = new ArrayList<CTATTab>();
        this.nextTabNumber = 1;
        this.server = server;
        LogConsole.setTabManager(this);
    }

    public void addCtatMenuItem(JMenuItem menuItem, boolean[] values) {
        if (trace.getDebugCode("menu")) {
            trace.out("menu", "CTATTabManager.addCtatMenuItems(" + menuItem + ") nInField " + this.menuItems.size() + ", tabList size " + this.tabList.size());
        }
        this.menuItems.put(menuItem, values);
        for (CTATTab tab : this.tabList) {
            tab.addCtatMenuItem(menuItem, Arrays.copyOf(values, values.length));
        }
    }

    public int getNextTabNumber() {
        return this.nextTabNumber;
    }

    public static int getMaxNumTabs() {
        return MAX_TABS;
    }

    public static void setMaxNumTabs(int maxTabs) {
        MAX_TABS = maxTabs;
    }

    public static int getNumTabs() {
        return NUM_TABS;
    }

    public CTATTab getFreeTab() {
        CTATTab focusedTab = this.getFocusedTab();
        if (this.getFocusedTab() != null && focusedTab.getProblemModel().isEmpty()) {
            return focusedTab;
        }
        for (CTATTab visibleTab : this.tabList) {
            if (!visibleTab.isVisible() || !visibleTab.getProblemModel().isEmpty()) continue;
            return visibleTab;
        }
        for (CTATTab tab : this.tabList) {
            if (!tab.getProblemModel().isEmpty()) continue;
            return tab;
        }
        return null;
    }

    public CTATTab getNewTab() {
        return this.getNewTab(null, null);
    }

    public CTATTab getNewTab(CTATTab newTab, SingleSessionLauncher launcher) {
        if (NUM_TABS >= MAX_TABS) {
            if (trace.getDebugCode("mg")) {
                trace.out("mg", "CTATTabManager (getNewTab): no more tabs ");
            }
            if ((newTab = this.getFreeTab()) == null) {
                JOptionPane.showMessageDialog(this.getFocusedTab().getController().getActiveWindow(), "Only " + MAX_TABS + " graphs can be open at the same time. Please close an open graph and try again.", "Maximum number of graphs", 0);
            }
            return newTab;
        }
        if (launcher == null) {
            newTab = new CTATTab(this.nextTabNumber);
            launcher = new SingleSessionLauncher(this.argv, this, this.server, newTab);
        }
        newTab.setLauncher(launcher);
        this.tabList.add(newTab);
        ++NUM_TABS;
        ++this.nextTabNumber;
        newTab.initializeCtatMenuItems(this.menuItems);
        return newTab;
    }

    public CTATTab getTabByNumber(int tabNumber) {
        return this.tabList.get(tabNumber - 1);
    }

    public void clear() {
        this.tabList.clear();
    }

    public boolean hasLoadedFile(String filepath) {
        File f = new File(filepath);
        for (CTATTab tab : this.tabList) {
            File tabFile = new File(tab.getProblemModel().getProblemFullName());
            if (!tabFile.equals(f)) continue;
            if (trace.getDebugCode("mg")) {
                trace.out("mg", "CTATTabManager (hasLoadedFile): same problem path");
            }
            this.server.getDockManager().showGraphWindow(tab.getTabNumber());
            return true;
        }
        return false;
    }

    public void setFocusedTab(CTATTab tab, boolean reloadViews) {
        int lastFocusedTabNumber;
        int n = lastFocusedTabNumber = this.focusedTab != null ? this.focusedTab.getTabNumber() : -1;
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "CTATTabMgr.setFocusedTab() arg tab " + tab.getTabNumber() + " ?= lastFocused " + lastFocusedTabNumber);
        }
        this.focusedTab = tab;
        if (tab.getTabNumber() == lastFocusedTabNumber) {
            return;
        }
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "CTATTabManager (setFocusedTab): focusing on tab " + tab.getTabNumber());
        }
        DockManager dockManager = this.server.getDockManager();
        this.focusedTab = tab;
        this.focusedTab.updateCtatMenuItems();
        if (!this.server.isDoneIntializing()) {
            return;
        }
        dockManager.markAsFocused(tab.getTabNumber(), lastFocusedTabNumber);
        if (reloadViews && dockManager != null) {
            dockManager.refreshViews(false);
            this.server.getCtatMenuBar().refreshGraphDependentItems();
            tab.getController().updateStatusPanel(null);
        }
    }

    public void setFocusedTabByNumber(int tabNumber, boolean reloadViews) {
        this.setFocusedTab(this.getTabByNumber(tabNumber), reloadViews);
    }

    public void updateIfNewTabFocus(int tabNumber) {
        if (this.getFocusedTab().getTabNumber() != tabNumber) {
            this.setFocusedTab(this.getTabByNumber(tabNumber), true);
        }
    }

    public CTATTab getFocusedTab() {
        return this.focusedTab;
    }

    public boolean getTabVisibility(int tabNumber) {
        return this.getTabByNumber(tabNumber).isVisible();
    }

    public void setTabVisibility(int tabNumber, boolean visible) {
        if (tabNumber > 0 && tabNumber <= NUM_TABS) {
            this.getTabByNumber(tabNumber).setVisible(visible);
        }
    }

    public void printInfo() {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "CTATTabManager (printInfo): size = " + this.tabList.size() + " tab(s)");
            for (CTATTab tab : this.tabList) {
                trace.out("mg", "\t" + tab.getName() + ": problem model = " + tab.getController().getProblemName() + ", " + tab.getController().getProblemModel().getEdgeCount() + " edges and " + tab.getController().getProblemModel().getNodeCount() + " nodes");
                trace.out("mg", "visible: " + tab.isVisible());
            }
        }
    }

    public boolean connectSocket(String guid, Socket sock, BufferedReader br, Map<String, String> socketArgs) {
        if (guid == null) {
            return false;
        }
        CTATTab tab = this.findTabForConnection(guid);
        if (tab == null) {
            return false;
        }
        BR_Controller controller = tab.getLauncher().getController();
        String newGuid = controller.getLauncher().getLauncherServer().editGuidForCollaboration(guid);
        if (guid.equals(newGuid)) {
            guid = tab.editGuidForTab(guid);
            tab.setSessionID(guid);
        } else {
            guid = newGuid;
            tab.setSessionID(guid);
        }
        tab.setSwfName(guid);
        if (trace.getDebugCode("tab")) {
            trace.out("tab", "TabManager setting CTAT_Properties guid to " + guid);
        }
        controller.getProperties().setProperty("guid", guid);
        controller.getLauncher().addNewSession(guid);
        if (trace.getDebugCode("tab")) {
            trace.out("tab", "TabManager just called addNewSession");
        }
        SocketProxy sp = new SocketProxy(sock, socketArgs.get("MsgFormat"));
        controller.setRemoteProxy(sp);
        sp.setController(controller, br);
        SocketProxy.setMaxIdleTime(Long.MAX_VALUE);
        sp.setEom(socketArgs.get("EOM"));
        sp.setLogOnly(socketArgs.get("LogOnly"));
        sp.setClientHost(socketArgs.get("ClientHost"));
        sp.setUseSingleSocket(socketArgs.get("UseSingleSocket"));
        sp.setConnectFirst(socketArgs.get("ConnectFirst"));
        sp.setOneMsgPerSocket(socketArgs.get("OneMsgPerSocket"));
        sp.setClientPort(socketArgs.get("ClientPort"));
        sp.setServerPort(sock.getLocalPort());
        sp.setupLogServlet(null);
        UniversalToolProxy utp = controller.getUniversalToolProxy();
        if (trace.getDebugCode("tab")) {
            trace.out("tab", "TabManager.connectSocket() utp " + trace.nh(utp) + ", sp.getToolProxy " + trace.nh(sp.getToolProxy()));
        }
        utp.awaitSetPreferences(true);
        if (this.getNumLogConsoles() > 0) {
            ((RemoteToolProxy)utp).setTeeSocket(sock);
        }
        if (trace.getDebugCode("tab")) {
            trace.out("tab", "TabManager connecting socket. Number of LogConsoles open is " + this.getNumLogConsoles());
        }
        sp.start();
        return true;
    }

    private CTATTab findTabForConnection(String guid) {
        CTATTab result = this.getFocusedTab();
        if (null == result || !result.isVisible()) {
            return null;
        }
        BR_Controller ctlr = result.getLauncher().getController();
        if (ctlr.getRemoteProxy() instanceof RemoteProxy) {
            int reply = JOptionPane.showConfirmDialog(ctlr.getActiveWindow(), "The student interface \"" + guid + "\" is trying to connect,\nbut an interface is already active on this panel. Do you want to\ndisconnect and replace it with " + guid + "?", "Student interface already active", 2, 2);
            if (reply == 2) {
                return null;
            }
            ctlr.disconnect(false);
        }
        return result;
    }

    public void closeTab(int tabNumber) throws OperationAbortedException {
        CTATTab tab = this.getTabByNumber(tabNumber);
        if (!tab.isVisible()) {
            return;
        }
        BR_Controller ctlr = tab.getController();
        if (2 == ctlr.cancelOrSaveCurrentProblemWithUserPrompt()) {
            throw new OperationAbortedException();
        }
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "CTATTabManager (closeTab): closing tab " + tabNumber);
        }
        tab.closeTab();
        ctlr.startNewProblem(null);
        if (ctlr.getRemoteProxy() instanceof SocketProxy) {
            if (trace.getDebugCode("mg")) {
                trace.out("mg", "CTATTabManager (closeTab): disconnecting  " + tabNumber);
            }
            ctlr.disconnect(false);
        } else if (ctlr.getStudentInterface() != null) {
            int reply = JOptionPane.showConfirmDialog(ctlr.getActiveWindow(), "Closing the window " + tab.getName() + " will also close the connected interface. \r\nCancel to leave the interface open and connected.  Continue?", "Close Student Interface", 2, 2);
            if (reply == 2) {
                this.setFocusedTab(tab, true);
                throw new OperationAbortedException();
            }
            ctlr.closeStudentInterface();
        }
    }

    public int numVisibleTabs() {
        int num = 0;
        for (CTATTab tabForFocus : this.tabList) {
            if (!tabForFocus.isVisible()) continue;
            ++num;
        }
        return num;
    }

    public CTATTab chooseVisibleTab() {
        CTATTab aVisibleTab = null;
        for (CTATTab visibleTab : this.tabList) {
            if (!visibleTab.isVisible()) continue;
            if (!visibleTab.getProblemModel().isEmpty()) {
                return visibleTab;
            }
            aVisibleTab = visibleTab;
        }
        return aVisibleTab;
    }

    public void createdLogConsole() {
        ++this.numLogConsoles;
        if (trace.getDebugCode("tab")) {
            trace.out("tab", "Number of LogConsoles open: " + this.numLogConsoles);
        }
    }

    public void closedLogConsole() {
        --this.numLogConsoles;
        if (trace.getDebugCode("tab")) {
            trace.out("tab", "Number of LogConsoles open: " + this.numLogConsoles);
        }
    }

    public int getNumLogConsoles() {
        return this.numLogConsoles;
    }

    public CTATTab connectHTTP(String guid, AuthorHTTPSession sess) {
        if (guid == null) {
            return null;
        }
        CTATTab tab = this.findTabBySessionID(guid);
        if (tab == null) {
            tab = this.findTabForConnection(guid);
            if (tab == null) {
                return null;
            }
            BR_Controller controller = tab.getLauncher().getController();
            String newGuid = controller.getLauncher().getLauncherServer().editGuidForCollaboration(guid);
            if (guid.equals(newGuid)) {
                guid = tab.editGuidForTab(guid);
                tab.setSessionID(guid);
                sess.reviseGuid(guid);
            } else {
                guid = newGuid;
                sess.reviseGuid(guid);
                tab.setSessionID(guid);
            }
            tab.setTargetHTMLFile(new File(guid));
            if (trace.getDebugCode("tab")) {
                trace.out("tab", "TabManager setting CTAT_Properties guid to " + guid);
            }
            controller.getProperties().setProperty("guid", guid);
        }
        return tab.connectHTTP(sess);
    }

    private CTATTab findTabBySessionID(String guid) {
        if (guid == null || guid.length() < 1) {
            return null;
        }
        for (CTATTab tab : this.tabList) {
            if (!guid.equalsIgnoreCase(tab.getSessionID())) continue;
            return tab;
        }
        return null;
    }

    public void disconnectHTTP(AuthorHTTPSession hSess) {
        CTATTab tab = this.findTabBySessionID(hSess.getGuid());
        if (tab != null) {
            tab.disconnectHTTP(hSess);
        } else if (trace.getDebugCode("tab")) {
            trace.err("CTATTabManager.disconnectHTTP() tab for guid " + hSess.getGuid() + " not found");
        }
    }
}

