/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.VariableViewer;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEventListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerInterpretation;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerTracer;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerTracerChangedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTableModel;
import edu.cmu.pact.BehaviorRecorder.View.VariableViewer.InterpretationPane;
import edu.cmu.pact.BehaviorRecorder.View.VariableViewer.VTDisplayPane;
import edu.cmu.pact.BehaviorRecorder.View.VariableViewer.VariableTablePane;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTabbedPane;

public class VTITabbedPane
extends JTabbedPane
implements ExampleTracerEventListener {
    private static final long serialVersionUID = 5776521536223331624L;
    private ExampleTracerTracer tracer;
    private ArrayList<VTDisplayPane> panes;
    private VariableTablePane vtpane;
    private static int count = 0;
    private int instance;

    public VTITabbedPane(ProblemModel pm) {
        this.debug("VTITabbedPane ()");
        this.instance = count++;
        if (trace.getDebugCode("eti")) {
            trace.outNT("eti", "VTITabbedPane()");
        }
        this.tracer = pm.getExampleTracerGraph().getExampleTracer();
        if (trace.getDebugCode("eti")) {
            trace.outNT("eti", "VTInerpretationTabbedPane has TracerTracer #" + this.tracer.getInstance());
        }
        this.setTabLayoutPolicy(0);
        this.setTabPlacement(1);
        this.vtpane = new VariableTablePane(pm);
        this.vtpane.setName("VariableTablePane");
        this.vtpane.getTable().setName("VariableTable JTable");
        this.addTab("Active", this.vtpane);
        if (trace.getDebugCode("eti")) {
            trace.outNT("eti", "adding " + this.vtpane.getType() + " #" + this.vtpane.getInstance() + " to tab #" + 0);
        }
        this.makePanes();
        this.addTabs();
        this.tracer.addExampleTracerEventListener(this);
        if (trace.getDebugCode("eti")) {
            trace.outNT("eti", "subscribing VTITabbedPane #" + this.instance + " to the listener list of TracerTracer #" + this.tracer.getInstance());
        }
    }

    private void debug(String aMessage) {
        CTATBase.debug("VTITabbedPane", aMessage);
    }

    private void addTabs() {
        this.debug("addTabs ()");
        Iterator<VTDisplayPane> it = this.panes.iterator();
        int i = 1;
        while (it.hasNext()) {
            VTDisplayPane vtdp = it.next();
            this.addTab("Interpretation " + i, vtdp);
            if (trace.getDebugCode("eti")) {
                trace.outNT("eti", "adding " + vtdp.getType() + " #" + vtdp.getInstance() + " to tab #" + i);
            }
            ++i;
        }
    }

    private void makePanes() {
        this.debug("makePanes ()");
        if (trace.getDebugCode("vt")) {
            trace.outNT("vt", this.vtpane.getType() + " #" + this.vtpane.getInstance() + " has TableModel #" + ((VariableTableModel)this.vtpane.getTable().getModel()).getInstance() + " which has VariableTable #" + ((VariableTableModel)this.vtpane.getTable().getModel()).getVTInstance());
        }
        ArrayList<ExampleTracerInterpretation> interpretations = this.tracer.getInterpretations();
        if (trace.getDebugCode("eti")) {
            trace.outNT("eti", "makePanes()");
        }
        Iterator<ExampleTracerInterpretation> it = interpretations.iterator();
        this.panes = new ArrayList();
        while (it.hasNext()) {
            InterpretationPane interp = new InterpretationPane(it.next());
            interp.setName("InterpretationPane " + interp.getInstance());
            interp.getTable().setName("InterpretationPane " + interp.getInstance() + " JTable");
            this.panes.add(interp);
            if (!trace.getDebugCode("vt")) continue;
            trace.outNT("vt", interp.getType() + " #" + interp.getInstance() + " has TableModel #" + ((VariableTableModel)interp.getTable().getModel()).getInstance() + " which has VariableTable #" + ((VariableTableModel)interp.getTable().getModel()).getVTInstance());
        }
    }

    private void clearPanes() {
        Iterator<VTDisplayPane> it = this.panes.iterator();
        while (it.hasNext()) {
            this.remove(it.next());
        }
    }

    void setTableBackground(Color color) {
        this.vtpane.getTable().setBackground(color);
        for (int i = 0; i < this.panes.size(); ++i) {
            InterpretationPane pane = (InterpretationPane)this.panes.get(i);
            pane.getTable().setBackground(color);
        }
    }

    @Override
    public void ExampleTracerEventOccurred(ExampleTracerEvent e) {
        if (trace.getDebugCode("eti")) {
            trace.outNT("eti", "ExampleTraceEventOccured()");
        }
        if (e instanceof ExampleTracerTracerChangedEvent) {
            if (trace.getDebugCode("eti")) {
                trace.outNT("eti", "e was instanceof ExampleTracerTracerChangedEvent");
            }
            this.tracer = ((ExampleTracerTracerChangedEvent)e).getNew();
            this.tracer.addExampleTracerEventListener(this);
            if (trace.getDebugCode("eti")) {
                trace.outNT("eti", "subscribing VTITabbedPane #" + this.instance + " to the listener list of TracerTracer #" + this.tracer.getInstance());
            }
        }
        this.clearPanes();
        this.makePanes();
        this.addTabs();
    }

    public int getInstance() {
        return this.instance;
    }
}

