/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.jgraphwindow;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTabManager;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_CellViewFactory;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraph;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.EditContextGraphSynchronize;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.JGraphController;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.JGraphScrollPane;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.RefreshGraphOnGroupChange;
import edu.cmu.pact.Utilities.trace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.RepaintManager;
import javax.swing.ToolTipManager;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class JGraphPanel
extends JComponent
implements Printable {
    private static final long serialVersionUID = 1L;
    private static final int INITIAL_TOOLTIP_DELAY = 750;
    private static final int DISMISS_TOOLTIP_DELAY = 50000;
    private static final int RESHOW_TOOLTIP_DELAY = 1;
    private static final String WINDOW_NAME_PREFIX = "Graph ";
    protected JGraphController jgraphController;
    private BR_JGraph jgraph;
    private DefaultGraphModel graphModel = new DefaultGraphModel();
    private GraphLayoutCache graphView = new GraphLayoutCache((GraphModel)this.graphModel, (CellViewFactory)new BR_CellViewFactory());
    private int windowID;
    private double pageScale = 1.0;

    public JGraphPanel(CTAT_Launcher server, BR_Controller brController, final int tabNumber) {
        if (trace.getDebugCode("graphPanel")) {
            trace.out("graphPanel", "JGraphPanel constructor, CTAT_Launcher is " + server);
        }
        this.jgraph = new BR_JGraph((GraphModel)this.graphModel, this.graphView, brController);
        this.windowID = tabNumber;
        this.graphModel.addGraphModelListener((GraphModelListener)this.jgraph);
        this.jgraph.setAntiAliased(true);
        this.jgraph.getSelectionModel().setChildrenSelectable(true);
        final CTATTabManager tabManager = server.getTabManager();
        this.jgraph.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                tabManager.updateIfNewTabFocus(tabNumber);
            }
        });
        this.jgraphController = new JGraphController(brController, this, (GraphModel)this.graphModel, this.graphView);
        new EditContextGraphSynchronize(brController, this.jgraph);
        new RefreshGraphOnGroupChange(brController, this.jgraph);
        this.createInterface();
        this.setToolTipDelay();
        this.repaint();
    }

    private void setToolTipDelay() {
        ToolTipManager.sharedInstance().setInitialDelay(750);
        ToolTipManager.sharedInstance().setDismissDelay(50000);
        ToolTipManager.sharedInstance().setReshowDelay(1);
    }

    private void createInterface() {
        this.setBackground(Color.WHITE);
        this.setBounds(100, 100, 500, 400);
        this.setName(WINDOW_NAME_PREFIX + String.valueOf(this.windowID));
        Box box = new Box(3);
        box.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.add((Component)box, "Center");
        JComponent zoomPanel = this.createZoomBox();
        JGraphScrollPane brPane = new JGraphScrollPane(this.jgraph);
        this.jgraph.setBackground(this.getBackground());
        this.jgraph.setForeground(this.getForeground());
        if (this.windowID == 1) {
            this.jgraph.setName("BR_JGraph");
        } else {
            this.jgraph.setName("BR_JGraph" + String.valueOf(this.windowID));
        }
        trace.out("background = " + this.getBackground());
        trace.out("foreground = " + this.getForeground());
        box.add(brPane);
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    private JComponent createZoomBox() {
        String[] zoomStrings = new String[]{"200%", "150%", "125%", "100%", "75%", "50%", "25%"};
        Box box2 = new Box(2);
        JComboBox<String> zoomList = new JComboBox<String>(zoomStrings);
        zoomList.setName("Scale Selection List");
        zoomList.setSelectedItem("100%");
        box2.add(zoomList);
        zoomList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox zb = (JComboBox)e.getSource();
                String zoomName = (String)zb.getSelectedItem();
                JGraphPanel.this.jgraphController.zoomListActionPerfomed(zoomName);
            }
        });
        return box2;
    }

    public static AbstractButton createModeButton(String title, ButtonGroup modeGroup, Box box, String toolTipText) {
        JToggleButton button = new JToggleButton(title);
        button.setOpaque(false);
        modeGroup.add(button);
        box.add(button);
        button.setRolloverEnabled(true);
        button.setToolTipText(toolTipText);
        return button;
    }

    public BR_JGraph getJGraph() {
        return this.jgraph;
    }

    public JGraphController getJGraphController() {
        return this.jgraphController;
    }

    public Rectangle getGraphViewPortBounds() {
        if (this.jgraph == null) {
            return null;
        }
        Rectangle2D r2d = this.jgraph.getViewPortBounds();
        if (r2d == null) {
            return null;
        }
        if (trace.getDebugCode("mg")) {
            trace.out("mg", String.format("JGraphPanel.getGraphViewPortBounds() r2d [%6.2f %6.2f %6.2f %6.2f]", r2d.getX(), r2d.getY(), r2d.getWidth(), r2d.getHeight()));
        }
        Rectangle r = new Rectangle((int)Math.floor(r2d.getX()), (int)Math.floor(r2d.getY()), (int)Math.ceil(r2d.getWidth()), (int)Math.ceil(r2d.getHeight()));
        if (trace.getDebugCode("mg")) {
            trace.out("mg", String.format("JGraphPanel.getGraphViewPortBounds() r   [%3d    %3d    %3d    %3d   ]", r.x, r.y, r.width, r.height));
        }
        return r;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Dimension pSize = this.jgraph.getPreferredSize();
        int w = (int)(pageFormat.getWidth() * this.pageScale);
        int h = (int)(pageFormat.getHeight() * this.pageScale);
        int cols = (int)Math.max(Math.ceil((double)(pSize.width - 5) / (double)w), 1.0);
        int rows = (int)Math.max(Math.ceil((double)(pSize.height - 5) / (double)h), 1.0);
        if (trace.getDebugCode("print")) {
            trace.out("print", String.format("%s.print(g, w %.2f x h %.2f, pageIndex %d): pSize %s, pageScale %.2f, cols %d, rows %d", this.getClass().getSimpleName(), pageFormat.getWidth(), pageFormat.getHeight(), pageIndex, pSize.toString(), this.pageScale, cols, rows));
        }
        if (pageIndex < cols * rows) {
            RepaintManager currentManager = RepaintManager.currentManager(this);
            currentManager.setDoubleBufferingEnabled(false);
            double oldScale = this.jgraph.getScale();
            this.jgraph.setScale(1.0 / this.pageScale);
            int dx = (int)((double)(pageIndex % cols) * pageFormat.getWidth());
            int dy = (int)((double)(pageIndex / cols % rows) * pageFormat.getHeight());
            g.translate(-dx, -dy);
            g.setClip(dx, dy, (int)Math.ceil(pageFormat.getWidth()), (int)Math.ceil(pageFormat.getHeight()));
            if (trace.getDebugCode("print")) {
                trace.out("print", String.format(".print() to call paint() dx %d, dy %d, clipBounds %s", dx, dy, g.getClipBounds().toString()));
            }
            this.jgraph.paint(g);
            g.translate(dx, dy);
            this.jgraph.setScale(oldScale);
            currentManager.setDoubleBufferingEnabled(true);
            return 0;
        }
        return 1;
    }
}

