/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.pact.Log.LogInfo;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;

public abstract class LogWriterForwarder
extends LinkedList<String>
implements Runnable {
    private static final long serialVersionUID = -201406121140L;
    private static final String STATUS_SUCCESS = "status=success\r\n";
    private static final String STATUS_FAILURE = "status=failure\r\n";
    public static final String ENABLE_LOG_SERVICE = "EnableLogService";
    public static final String ENABLE_LOG_FORWARDING = "EnableLogForwarding";
    public static final String QUIT_MSG = "<quit/>";
    private static final int MAX_IO_ERROR_COUNT = 10;
    protected File logFile = null;
    protected BufferedWriter writer = null;
    protected int errCount;
    protected String logServerURL = null;
    protected LogInfo logInfo;

    protected abstract String openLogFile();

    protected synchronized void close() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception ioe) {
            trace.errStack("LogServlet.close(): error closing writer for log file " + this.logFile, ioe);
        }
        this.writer = null;
        this.logFile = null;
    }

    @Override
    public void run() {
        String logMsg = null;
        while (!QUIT_MSG.equalsIgnoreCase(logMsg = this.dequeue())) {
            if (trace.getDebugCode("logservice")) {
                trace.out("logservice", "thread " + Thread.currentThread().getName() + " queue length " + this.size() + ", dequeued:\n\n" + logMsg + "\n");
            }
            String response = this.forwardContent(logMsg);
            if (!trace.getDebugCode("logservice")) continue;
            trace.outNT("logservice", "LogWriterForwarder.run(): reply from forwardContent(): " + response);
        }
        this.close();
    }

    public synchronized String dequeue() {
        while (this.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        return (String)this.removeFirst();
    }

    public void exit() {
        this.enqueue(QUIT_MSG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enqueue(String logMsg) {
        int result = this.size();
        LogWriterForwarder logWriterForwarder = this;
        synchronized (logWriterForwarder) {
            this.addLast(logMsg);
            result = this.size();
            this.notifyAll();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String log(String logMsg) {
        String message;
        String response = null;
        if (!this.shouldLog()) {
            return response;
        }
        if (trace.getDebugCode("logservice")) {
            trace.out("logservice", "log(" + logMsg + ")");
        }
        if (this.writer == null && (message = this.openLogFile()) != null) {
            ++this.errCount;
            return this.handleDiskWriteError("Error opening file", message);
        }
        BufferedWriter bufferedWriter = this.writer;
        synchronized (bufferedWriter) {
            try {
                this.writer.write(logMsg.trim());
                this.writer.flush();
                this.errCount = 0;
                response = STATUS_SUCCESS;
                this.logInfo.incrementDiskLogEntries();
            }
            catch (IOException ioe) {
                ++this.errCount;
                this.logInfo.incrementDiskLogErrors();
                trace.errStack("LogServlet.log() error (count now " + this.errCount + ") writing log: " + ioe + (ioe.getCause() == null ? "" : ";\n cause " + ioe.getCause()), ioe);
                response = this.handleDiskWriteError("Error writing to file", ioe.toString());
            }
        }
        if (trace.getDebugCode("logservice")) {
            trace.out("logservice", "log(): " + response);
        }
        return response;
    }

    private String handleDiskWriteError(String operation, String message) {
        String response = "status=failure\r\ncause=internal_error\r\n";
        if (this.errCount > 10) {
            message = "*** CLOSING LOG **** LogWriterForwarder.log() I/O error count exceeds threshold 10";
            trace.err(message);
            this.close();
            response = response + "message=" + message + "\r\n";
        } else {
            response = response + "message=Error writing to file: " + message + "\r\n";
        }
        return response;
    }

    protected String forwardContent(String msg) {
        if (!this.canForward()) {
            return null;
        }
        String response = null;
        HttpURLConnection conn = null;
        URL url = null;
        try {
            url = new URL(this.getLogServerURL());
            conn = this.openConnection(url);
            OutputStream os = conn.getOutputStream();
            os.write(msg.getBytes());
            os.flush();
            os.close();
            InputStream is = conn.getInputStream();
            ByteArrayOutputStream readBuf = new ByteArrayOutputStream();
            int i = 0;
            int c = is.read();
            while (c >= 0) {
                readBuf.write(c);
                ++i;
                c = is.read();
            }
            is.close();
            if (trace.getDebugCode("log")) {
                trace.outNT("log", "content of " + this.getLogServerURL() + " response (length " + i + "): " + readBuf + "; headers " + conn.getHeaderFields());
            }
            response = readBuf.toString();
            this.logInfo.incrementForwardLogEntries();
        }
        catch (Exception ex) {
            this.logInfo.incrementForwardLogErrors();
            trace.errStack("LogServlet.sendContent() error " + ex, ex);
            response = "status=failure\r\ncause=forwarding_error\r\n";
            response = response + "message=Error writing to URL " + url + ": " + ex.toString() + "\r\n";
        }
        if (trace.getDebugCode("logservice")) {
            trace.out("logservice", "forwardContent(): " + response);
        }
        return response;
    }

    protected boolean canForward() {
        return this.getLogServerURL() != null && this.getLogServerURL().length() > 0;
    }

    private HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("Checksum", "They call it a log");
        conn.connect();
        return conn;
    }

    public void setLogInfo(LogInfo logInfo) {
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "LogServlet setLogInfo: logInfo = " + logInfo);
        }
        this.logInfo = logInfo;
    }

    public String logOrQueueAndReply(String logMsg) {
        String response = this.log(logMsg);
        if (!this.canForward()) {
            return "status=failure\r\ncause=service_unavailable\r\n";
        }
        int queueLength = this.enqueue(logMsg);
        response = response == null ? "status=success\r\nqueue_position=" + queueLength + "\r\n" : response + "queue_position=" + queueLength + "\r\n";
        return response;
    }

    public void setLogServerURL(String logServerURL) {
        this.logServerURL = logServerURL;
    }

    public String getLogServerURL() {
        return this.logServerURL;
    }

    protected boolean shouldLog() {
        return true;
    }
}

