/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities.PluginInstaller;

import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.WindowUtils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctatview.wizardframe.DefaultWizardPanel;
import edu.cmu.pact.ctatview.wizardframe.WizardDialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class PluginInstallerPanel2
extends DefaultWizardPanel
implements ActionListener {
    private static final String INTRO_TEXT = "<html>Please select the folder where Eclipse is installed.<br>This folder should contain the \"configuration\", \"features\",<br>\"plugins\", and \"workspace\" folders, among others.<br><br>On Windows this is usually \"c:\\Program Files\\eclipse\\\"<br><br>On the Mac it is usually \"/Applications/eclipse/\"<br></html>";
    WizardDialog dialog;
    private JButton openDialogButton;
    private JFileChooser chooser;
    private JTextField location;
    private String folder;

    public PluginInstallerPanel2(WizardDialog g, String panelName) {
        super(g, panelName);
        this.dialog = g;
        Box box = new Box(1);
        JLabel j = new JLabel(INTRO_TEXT);
        this.location = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.location);
        this.location.setEditable(false);
        this.openDialogButton = new JButton("Select location");
        this.openDialogButton.addActionListener(this);
        this.location.setPreferredSize(new Dimension(250, 25));
        box.add(WindowUtils.wrapLeft(j));
        box.add(WindowUtils.wrapLeft(this.location));
        box.add(Box.createVerticalStrut(8));
        box.add(WindowUtils.wrapLeft(this.openDialogButton));
        this.add(box);
    }

    @Override
    public boolean getNextButtonState() {
        return false;
    }

    @Override
    public boolean getPreviousButtonState() {
        return true;
    }

    @Override
    public boolean getCancelButtonState() {
        return true;
    }

    @Override
    public boolean getFinishButtonState() {
        return this.folder != null;
    }

    @Override
    public String getNextPanelName() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int returnVal;
        trace.out("action performed");
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setFileSelectionMode(1);
        }
        if ((returnVal = this.chooser.showOpenDialog(this.parent)) == 0) {
            this.setEclipseFolder(this.chooser.getSelectedFile());
        }
    }

    private void setEclipseFolder(File file) {
        if (!new File(file.getAbsolutePath() + "/plugins").exists()) {
            this.showWrongFolderError(file.getAbsolutePath());
            return;
        }
        this.location.setText(file.getAbsolutePath());
        this.folder = file.getAbsolutePath();
        this.dialog.updateButtonState();
    }

    private void showWrongFolderError(String folder) {
        String message = "<html>The folder you entered: " + folder + "<br>does not appear to be the Eclipse installation folder, <br>because it does not contain a \"plugins\" sub-folder.<br><br>Please check the folder name and try again.</html>";
        String title = "Wrong folder";
        JOptionPane.showMessageDialog(this.dialog, message, title, 2);
    }

    public void finish() {
        if (!new File(this.location.getText() + "/plugins").exists()) {
            this.showWrongFolderError(this.location.getText());
            return;
        }
        try {
            this.copyDirectory(new File("eclipse"), new File(this.location.getText()));
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, "<html>An unrecoverable error occured<br>while copying these files.  The files could not be found.<br><br>Sorry.</html>", "Error copying files.", 2);
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "<html>An unrecoverable error occured<br>while copying these files.  The files could not be read.<br><br>Sorry.</html>", "Error copying files.", 2);
            e.printStackTrace();
            return;
        }
        JOptionPane.showMessageDialog(this, "<html>Congratulations!<br><br>The Eclipse Jess editor plugins have been installed.</html>");
        System.exit(0);
    }

    private void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                this.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            this.copyFile(srcDir, dstDir);
        }
    }

    void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

