/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VersionInfoGenerator {
    private String workFile;
    private String buildDate;
    private String buildVersion;
    private static String UNKNOWN_VERSION = "unknown";
    private static String LICENSE_FILE = "CTAT academic license.html";
    private static final DateFormat buildDateFmt = new SimpleDateFormat("dd MMMM yyyy");
    private static final DateFormat buildVersionFmt = new SimpleDateFormat("yyyyMMdd-HHmm");
    private boolean verbose = false;
    private LicenseType licenseType = LicenseType.academic;
    public static final String USAGE_MSG = "Usage:\n  java " + VersionInfoGenerator.class.getName() + " [-v] [" + (Object)((Object)LicenseType.internal) + "|" + (Object)((Object)LicenseType.academic) + "|" + (Object)((Object)LicenseType.commercial) + "]\nwhere--\n  -v    means to print verbose debugging information;\n  " + (Object)((Object)LicenseType.internal) + "   means to generate code for use in the PACT lab (default);\n  " + (Object)((Object)LicenseType.academic) + "   means to generate code for the academic license;\n  " + (Object)((Object)LicenseType.commercial) + " means to generate code for the commercial license.";

    public VersionInfoGenerator(String licenseType, boolean verbose) {
        if (licenseType == null) {
            licenseType = LicenseType.values()[0].toString();
        }
        this.licenseType = LicenseType.valueOf(licenseType.toLowerCase());
        this.verbose = verbose;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    private String getReleaseName() {
        String propVal = System.getProperty("VersionInfo.Release");
        if (propVal != null && propVal.length() > 0) {
            return propVal;
        }
        return UNKNOWN_VERSION;
    }

    private void generateJava() {
        StringBuffer result = new StringBuffer("package edu.cmu.pact.Utilities;\n\n/**\n * Version number and build date for " + this.workFile + ".\n * THIS CODE IS GENERATED by VersionInfoGenerator.\n */\npublic class VersionInformation {\n    public static String RELEASE_NAME = \"" + this.getReleaseName() + "\";\n    public static String VERSION_NUMBER = \"" + this.getBuildVersion() + "\";\n    public static String BUILD_DATE = \"" + this.getBuildDate() + "\";\n\n    private static VersionInfoGenerator.LicenseType licenseType = VersionInfoGenerator.LicenseType." + (Object)((Object)this.licenseType) + ";\n\n    public static String getReleaseString() {\n        return RELEASE_NAME+\", \"+VERSION_NUMBER+\", \"+BUILD_DATE;\n    }\n\n    public static void main(String[] args) {\n        System.out.println(getReleaseString());\n    }\n");
        result.append("\n").append(this.genIncludePredicates());
        result.append("\n").append(this.genRunningSimSt());
        result.append("\n").append(this.genGetWebPage());
        result.append("\n").append(this.genGetMenuItem());
        result.append("\n").append(this.genGetFileReferenceString());
        result.append("}\n");
        System.out.print(result.toString());
    }

    private String genRunningSimSt() {
        StringBuffer sb = new StringBuffer();
        sb.append("    /** True if we are actually running Sim Student. */\n    private static boolean runningSimSt = false;\n");
        sb.append("\n");
        sb.append("    /**\n     * @return true if actually running Sim Student\n     */\n    public static boolean isRunningSimSt() {\n        return runningSimSt && includesSimSt();\n    }\n");
        sb.append("\n");
        sb.append("    /**\n     * @param new value for {@link #runningSimSt}\n     */\n    public static void setRunningSimSt(boolean b) {\n        runningSimSt = b;\n    }\n");
        sb.append("\n");
        return sb.toString();
    }

    private String genIncludePredicates() {
        StringBuffer sb = new StringBuffer();
        sb.append("    /**\n     * @return true if the Carnegie Learning libraries are available; else false\n     */\n    public static boolean includesCL() { return licenseType == VersionInfoGenerator.LicenseType.internal; }\n");
        sb.append("\n");
        sb.append("    /**\n     * @return true if Simulated Student mode is available; else false\n     */\n    public static boolean includesSimSt() { return licenseType == VersionInfoGenerator.LicenseType.internal; }\n");
        sb.append("\n");
        sb.append("    /** Result of last {@link #includesJess()} call. */\n    private static Boolean lastJessResult = null;\n");
        sb.append("\n");
        sb.append("    /**\n     * @return true if can instantiate the {@link jess.Rete} class; else false\n     */\n    public static boolean includesJess() {\n        if(lastJessResult != null)\n            return lastJessResult.booleanValue();\n        boolean result;\n        try {\n            Class cls = Class.forName(\"jess.Rete\");\n            result = (cls.newInstance() != null);\n        } catch (NoClassDefFoundError ncdfe) {\n            result = false;\n        } catch (ClassNotFoundException cnfe) {\n            result = false;\n        } catch (Throwable t) {\n            result = (licenseType != VersionInfoGenerator.LicenseType.commercial);\n        }\n        lastJessResult = new Boolean(result);\n        return result;\n    }\n");
        sb.append("\n");
        return sb.toString();
    }

    private String genGetWebPage() {
        String webPage = this.licenseType == LicenseType.commercial ? "null" : "\"file:///\"+VersionInformation.currentDir()+\"" + LICENSE_FILE + "\"";
        return "    /**\n     * @return URL of web page having the license agreement or null\n     */\n    public static String getWebPage() {\n        return " + webPage + ";\n    }\n";
    }

    private String genGetMenuItem() {
        String menuItem = this.licenseType == LicenseType.commercial ? "null" : "new javax.swing.JMenuItem(\"CTAT License\")";
        return "    /**\n     * @return menu item labeled \"CTAT License\" or null\n     */\n    public static javax.swing.JMenuItem getMenuItem() {\n        return " + menuItem + ";\n    }\n";
    }

    private String genGetFileReferenceString() {
        String fileReferenceString = this.licenseType == LicenseType.commercial ? "\"\"" : "\"License: \"+VersionInformation.currentDir()+\"" + LICENSE_FILE + ".<br><br>\"";
        String currentDirSource = this.licenseType == LicenseType.commercial ? "" : "    /**\n     * @return current directory from System property user.dir or empty string.\n     */\n    private static String currentDir() {\n        String result = System.getProperty(\"user.dir\");\n        if (result == null || result.length() < 1)\n            return \"\";\n        return result+java.io.File.separator;\n    }\n";
        StringBuffer result = new StringBuffer();
        result.append("    /**\n     * @return HTML string telling the location of the license file or empty string\n     */\n    public static String getFileReferenceString() {\n");
        result.append("        return ").append(fileReferenceString).append(";\n");
        result.append("    }\n");
        result.append("\n");
        result.append(currentDirSource);
        result.append("\n");
        return result.toString();
    }

    public void run() {
        this.buildDate = buildDateFmt.format(new Date());
        this.buildVersion = buildVersionFmt.format(new Date());
        if (this.verbose) {
            System.err.println("buildDate: " + this.buildDate + ", buildVersion: " + this.buildVersion);
        }
        this.generateJava();
    }

    private static void usageExit(String errMsg) {
        if (errMsg != null && errMsg.length() > 0) {
            System.err.print(errMsg + ". ");
        }
        System.err.println(USAGE_MSG);
        System.exit(1);
    }

    public static void main(String[] args) {
        int a;
        boolean verbose = false;
        block5: for (a = 0; a < args.length && args[a].charAt(0) == '-'; ++a) {
            if (args[a].length() < 2) {
                VersionInfoGenerator.usageExit("Missing option after '-'");
            }
            char opt = args[a].charAt(1);
            switch (opt) {
                case 'V': 
                case 'v': {
                    verbose = true;
                    continue block5;
                }
                default: {
                    VersionInfoGenerator.usageExit("Undefined option '-" + opt + "'");
                }
            }
        }
        String licenseType = a < args.length ? args[a] : null;
        try {
            VersionInfoGenerator gen = new VersionInfoGenerator(licenseType, verbose);
            gen.run();
        }
        catch (Exception e) {
            VersionInfoGenerator.usageExit(e.toString());
        }
    }

    static enum LicenseType {
        internal,
        academic,
        commercial;

    }
}

