/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat.view;

import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.Dialogs.UnmatchedSelectionsDialog;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import edu.cmu.pact.ctatview.CtatMenuBar;
import edu.cmu.pact.ctatview.CtatModePanel;
import edu.cmu.pact.ctatview.DockManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import net.infonode.docking.View;
import pact.CommWidgets.UniversalToolProxy;

public class CtatFrame
extends AbstractCtatWindow {
    private static final long serialVersionUID = -91588009557616193L;
    private static final String EMPTY_PROBLEM = "empty";
    private static final String NO_STUDENT_INTERFACE_TOOLTIP = "Select File->'Launch ... Interface' to open a student interface";
    private static final String NO_STUDENT_INTERFACE_LABEL = "No interface is active";
    private CtatModePanel modeSwitchPanel;
    private CtatMenuBar ctatMenuBar;
    private JLabel orderStatusLabel;
    private JButton obsoleteSelectionButton;
    private JLabel currentStateLabel;
    private JLabel studentInterfaceLabel;
    private JLabel problemNameLabel;
    private JLabel interpStatusLabel;
    private JLabel graphTutorTypeLabel;
    private final CTAT_Launcher server;
    private Map<Integer, JCheckBoxMenuItem> itemMap;

    public CtatFrame(CTAT_Launcher server) {
        super(server);
        this.server = server;
        this.itemMap = new HashMap<Integer, JCheckBoxMenuItem>();
        this.initUI(server);
    }

    public CtatModePanel getCtatModePanel() {
        return this.modeSwitchPanel;
    }

    private void initUI(CTAT_Launcher server) {
        this.modeSwitchPanel = new CtatModePanel(server);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.modeSwitchPanel, "North");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "North");
        this.setSize(800, 800);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.ctatMenuBar = this.getServer().getCtatMenuBar();
        this.modeSwitchPanel.addAuthorModeListener(this.ctatMenuBar);
        this.setJMenuBar(this.ctatMenuBar.getMenuBar());
        this.orderStatusLabel = this.createStatusBarLabel("orderStatusLabel", "select Windows -> Show Window -> Group Editor -> right click 'Top level' to change the graph order mode");
        this.obsoleteSelectionButton = UnmatchedSelectionsDialog.getDefaultButton();
        this.obsoleteSelectionButton.setBorder(new SBLBorder(1));
        Dimension osld = this.obsoleteSelectionButton.getPreferredSize();
        if (osld.height < this.orderStatusLabel.getPreferredSize().height) {
            osld.height = this.orderStatusLabel.getPreferredSize().height + 2;
        }
        osld.width += 6;
        this.obsoleteSelectionButton.setPreferredSize(osld);
        this.obsoleteSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UniversalToolProxy utp = null;
                if (CtatFrame.this.getServer().getFocusedController() == null || (utp = CtatFrame.this.getServer().getFocusedController().getUniversalToolProxy()) == null) {
                    return;
                }
                UnmatchedSelectionsDialog launcher = null;
                boolean hasDialog = false;
                if (utp == null || (launcher = utp.getUnmatchedSelectionsDialogLauncher()) == null || !(hasDialog = utp.getUnmatchedSelectionsDialogLauncher().hasDialog())) {
                    trace.err("CtatFrame.obsoleteSelectionButton listener cannot invoke dialog utp " + trace.nh(utp) + ", launcher " + trace.nh(launcher) + ", hasDialog " + hasDialog);
                    return;
                }
                launcher.launch();
            }
        });
        this.obsoleteSelectionButton.setVisible(false);
        this.graphTutorTypeLabel = this.createStatusBarLabel("graphTutorLabel", "Behavior Graph Type");
        this.currentStateLabel = this.createStatusBarLabel("currentStateLabel", "Current state in the graph");
        this.studentInterfaceLabel = this.createStatusBarLabel("studentInterfaceLabel", NO_STUDENT_INTERFACE_TOOLTIP);
        this.problemNameLabel = this.createStatusBarLabel("problemStatusLabel", "select File->'Open Graph' to load the problem");
        this.interpStatusLabel = this.createStatusBarLabel("groupStatusLabel", "Number of interpretations in the example tracer");
        JPanel statusPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 21;
        gbc.weightx = 0.06;
        statusPanel.add((Component)this.orderStatusLabel, gbc);
        gbc.weightx = 0.05;
        statusPanel.add((Component)this.currentStateLabel, gbc);
        gbc.weightx = 0.33;
        statusPanel.add((Component)this.studentInterfaceLabel, gbc);
        gbc.weightx = 0.0;
        statusPanel.add((Component)this.obsoleteSelectionButton, gbc);
        gbc.weightx = 0.32;
        statusPanel.add((Component)this.problemNameLabel, gbc);
        gbc.weightx = 0.12;
        statusPanel.add((Component)this.graphTutorTypeLabel, gbc);
        gbc.weightx = 0.12;
        statusPanel.add((Component)this.interpStatusLabel, gbc);
        this.getContentPane().add((Component)statusPanel, "Last");
    }

    private JLabel createStatusBarLabel(String name, String toolTipText) {
        JLabel label = new JLabel();
        label.setName(name);
        label.createToolTip();
        label.setToolTipText(toolTipText);
        label.setBorder(new SBLBorder(1));
        label.setOpaque(true);
        label.setVisible(true);
        label.setFont(new Font("Dialog", 1, 10));
        return label;
    }

    @Override
    public void setVisible(boolean visible) {
        if (trace.getDebugCode("br")) {
            trace.out("br", "setVisible(" + visible + ")");
        }
        super.setVisible(visible);
    }

    public void addView(View view, final int viewID) {
        final DockManager dm = this.server.getDockManager();
        JMenu viewMenu = this.ctatMenuBar.getViewPanelMenu();
        String itemName = view.getTitle();
        final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(itemName);
        viewMenu.add(menuItem);
        this.itemMap.put(viewID, menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dm.setViewVisibility(viewID, menuItem.isSelected());
            }
        });
    }

    public void updateGraphMenuItem(int viewID, String problemName) {
        String problemText = problemName != null && problemName.length() > 0 ? problemName : EMPTY_PROBLEM;
        JCheckBoxMenuItem menuItem = this.itemMap.get(viewID);
        String itemName = menuItem.getText();
        String itemNamePrefix = itemName.substring(0, itemName.indexOf("[", 0));
        menuItem.setText(itemNamePrefix + "[" + problemText + "]");
    }

    public void setViewVisibilityMarker(int viewID, boolean visible) {
        this.itemMap.get(viewID).setSelected(visible);
    }

    public boolean isTracked(int viewID) {
        return this.itemMap.get(viewID) != null;
    }

    public boolean isWindowVisible(int viewID) {
        JCheckBoxMenuItem item = this.itemMap.get(viewID);
        if (item == null) {
            return false;
        }
        return item.isSelected();
    }

    public CtatMenuBar getCtatMenuBar() {
        return this.ctatMenuBar;
    }

    public void setProblemStatusToolTip(String FullProblemName) {
        this.problemNameLabel.setToolTipText(FullProblemName);
    }

    public String getOrderStatusLabel() {
        return this.orderStatusLabel.getText();
    }

    public void setOrderStatusLabel(String orderStatusText) {
        this.orderStatusLabel.setText(orderStatusText);
    }

    public String getCurrentStateLabel() {
        return this.currentStateLabel.getText();
    }

    public void setCurrentStateLabel(String currentStateText) {
        if (currentStateText == null) {
            this.currentStateLabel.setText("No current state");
        } else {
            this.currentStateLabel.setText(currentStateText);
        }
    }

    public String getStudentInterfaceLabel() {
        return this.studentInterfaceLabel.getText();
    }

    public void setStudentInterface(String fullStudentInterface) {
        if (fullStudentInterface == null) {
            if (this.studentInterfaceLabel.getText() == null) {
                fullStudentInterface = "";
            } else {
                this.studentInterfaceLabel.setText(this.studentInterfaceLabel.getText());
                return;
            }
        }
        if (fullStudentInterface.length() < 1) {
            this.studentInterfaceLabel.setText(NO_STUDENT_INTERFACE_LABEL);
            this.studentInterfaceLabel.setToolTipText(NO_STUDENT_INTERFACE_TOOLTIP);
        } else {
            this.studentInterfaceLabel.setText(this.lastPathElement(fullStudentInterface));
            this.studentInterfaceLabel.setToolTipText("Student Interface: " + fullStudentInterface);
        }
    }

    private String lastPathElement(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        String[] pathElements = fullPath.split("\\" + File.separator);
        if (pathElements.length < 2 && !File.separator.equals("/")) {
            pathElements = fullPath.split("/");
        }
        return pathElements[pathElements.length - 1];
    }

    public String getProblemNameLabel() {
        return this.problemNameLabel.getText();
    }

    public void setProblemNameLabel(String problemNameText) {
        this.problemNameLabel.setText(problemNameText);
    }

    public String getTutorTypeLabel() {
        String s = this.graphTutorTypeLabel.getText();
        if (s == null || s.equals("No graph has been opened yet")) {
            return null;
        }
        return s;
    }

    public void setTutorTypeLabel(String tutorTypeText) {
        this.graphTutorTypeLabel.setText(tutorTypeText);
    }

    public String getInterpStatusLabel() {
        return this.interpStatusLabel.getText();
    }

    public void setInterpStatusLabel(String interpStatusText) {
        this.interpStatusLabel.setText(interpStatusText);
    }

    private CTAT_Launcher getServer() {
        return this.server;
    }

    public void updateUnmatchedSelections(boolean available) {
        UnmatchedSelectionsDialog.updateDialogAvailableButton(available, this.obsoleteSelectionButton);
    }

    class SBLBorder
    extends BevelBorder {
        private static final long serialVersionUID = -1513321908788736005L;

        SBLBorder(int bevelType) {
            super(bevelType);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 4, 2, 4);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets ins = this.getBorderInsets(c);
            insets.set(ins.top, ins.left, ins.bottom, ins.right);
            return insets;
        }
    }
}

