/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctatview;

import edu.cmu.pact.BehaviorRecorder.Tab.CTATTabManager;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctatview.DockManager;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.View;

public class DockGraphWindowAdapter
extends DockingWindowAdapter
implements DockingWindowListener {
    private final DockManager dockManager;
    private final CTATTabManager tabManager;
    private final int tabNumber;

    public DockGraphWindowAdapter(DockManager dockManager, CTATTabManager tabManager, int tabNumber) {
        this.dockManager = dockManager;
        this.tabManager = tabManager;
        this.tabNumber = tabNumber;
    }

    public void windowShown(DockingWindow window) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "DockGraphWindowAdapter (windowShown): HERE, tab = " + this.tabNumber);
            trace.out("mg", "DockGraphWindowAdapter (windowShown): window = " + window.getTitle());
        }
        if (window.getHeight() > 0) {
            this.tabManager.updateIfNewTabFocus(this.tabNumber);
        }
        this.tabManager.setTabVisibility(this.tabNumber, true);
        if (this.tabManager.numVisibleTabs() > 0) {
            this.dockManager.showGraphPlaceHolder(false);
        }
    }

    public void windowClosing(DockingWindow window) throws OperationAbortedException {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "DockGraphWindowAdapter (windowClosing): " + window.getTitle());
        }
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "DockGraphWindowAdapter (windowClosing): tabNumber " + this.tabNumber);
        }
        this.tabManager.closeTab(this.tabNumber);
    }

    public void windowClosed(DockingWindow window) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "DockGraphWindowAdapter (windowClosed): HERE, tab = " + this.tabNumber);
        }
        this.tabManager.setTabVisibility(this.tabNumber, false);
        if (this.tabManager.numVisibleTabs() < 1) {
            this.dockManager.showGraphPlaceHolder(true);
        } else {
            this.tabManager.setFocusedTab(this.tabManager.chooseVisibleTab(), true);
        }
    }

    public void windowRestored(DockingWindow window) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "DockGraphWindowAdapter (windowRestored): window = " + window.getTitle());
            trace.out("mg", "DockGraphWindowAdapter (windowRestored): HERE, tab = " + this.tabNumber);
        }
        if (window.getHeight() > 0) {
            this.tabManager.updateIfNewTabFocus(this.tabNumber);
        }
        this.tabManager.setTabVisibility(this.tabNumber, true);
        if (this.tabManager.numVisibleTabs() > 0) {
            this.dockManager.showGraphPlaceHolder(false);
        }
    }

    public void viewFocusChanged(View previouslyFocusedView, View focusedView) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "DockGraphWindowAdapter (viewFocusChanged): HERE, tab = " + this.tabNumber);
        }
        if (focusedView != null) {
            this.dockManager.graphTabFocused(this.tabNumber);
        }
    }
}

