/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.MessageEvent;
import edu.cmu.pact.Utilities.MessageEventListener;
import edu.cmu.pact.Utilities.MessageEventSupport;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.jess.JessModelTracing;
import java.util.Vector;

public abstract class MessageHandler {
    MessageObject recdMessage;
    MessageObject returnMessage;
    Vector propertyNames;
    Vector propertyValues;
    Vector selectionList;
    Vector actionList;
    Vector inputList;
    JessModelTracing jmt;
    String checkResult = "No-Applicable";
    private CTAT_Controller controller;
    private MessageEventSupport msgEvtSupport = new MessageEventSupport();

    public MessageHandler(MessageObject o, JessModelTracing jmt, CTAT_Controller controller) {
        this.recdMessage = o;
        this.jmt = jmt;
        this.controller = controller;
        this.jmt.setSkipTree(Utils.isRuntime());
    }

    public abstract String processMessage();

    public abstract void sendMessage();

    protected void fireMessageEvent(MessageObject o) {
        if (this.msgEvtSupport.getListenerCount() <= 0) {
            return;
        }
        String msgType = o.getMessageType();
        String result = (String)o.getProperty("Result");
        this.msgEvtSupport.fireMessageEvent(new MessageEvent(this, true, msgType, result, o));
    }

    public void addMessageEventListener(MessageEventListener listener) {
        this.msgEvtSupport.addMessageEventListener(listener);
    }

    public void removeMessageEventListener(MessageEventListener listener) {
        this.msgEvtSupport.removeMessageEventListener(listener);
    }

    public CTAT_Controller getController() {
        return this.controller;
    }
}

