/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.MT;
import edu.cmu.pact.jess.MTRete;
import java.io.Serializable;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

public class PerformTutorAction
implements Userfunction,
Serializable {
    private static final String FUNCTION_NAME = "perform-tutor-action";
    protected transient JessModelTracing jmt;
    protected transient Context context;

    public PerformTutorAction() {
        if (trace.getDebugCode("ui")) {
            trace.printStack("ui", "PerformTutorAction()");
        }
    }

    public PerformTutorAction(JessModelTracing jmt) {
        if (trace.getDebugCode("ui")) {
            trace.printStack("ui", "PerformTutorAction(JessModelTracing " + jmt + ")");
        }
        this.jmt = jmt;
    }

    public String getName() {
        return FUNCTION_NAME;
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        this.context = context;
        if (this.getJmt() == null) {
            return Funcall.TRUE;
        }
        if (this.getJmt().isHintTrace()) {
            return Funcall.TRUE;
        }
        Value result = Funcall.FALSE;
        if (!vv.get(0).stringValue(context).equals(FUNCTION_NAME)) {
            throw new JessException(FUNCTION_NAME, "called but ValueVector head differs", vv.get(0).stringValue(context));
        }
        String messageType = "";
        String selection = "";
        String action = "";
        String input = "";
        if (vv.size() > 1) {
            messageType = vv.get(1).resolveValue(context).stringValue(context);
            if (vv.size() > 2) {
                selection = vv.get(2).resolveValue(context).stringValue(context);
                if (vv.size() > 3) {
                    action = vv.get(3).resolveValue(context).stringValue(context);
                    if (vv.size() > 4) {
                        input = vv.get(4).resolveValue(context).stringValue(context);
                    }
                }
            }
        }
        if (messageType.length() < 1) {
            return result;
        }
        MTRete rete = null;
        MT mt = null;
        BR_Controller controller = null;
        if (this.jmt != null && (rete = this.jmt.getRete()) != null && (mt = rete.getMT()) != null && (controller = (BR_Controller)mt.getController()) != null) {
            String transactionId = controller.getMessageTank().enqueueMessageToStudent(messageType, selection, action, input, "tutor-performed");
            if (trace.getDebugCode("ui")) {
                trace.out("ui", String.format("(%s %s \"%s\" \"%s\" \"%s\") transactionId %s", FUNCTION_NAME, messageType, selection, action, input, transactionId));
            }
            return Funcall.TRUE;
        }
        return Funcall.FALSE;
    }

    protected JessModelTracing getJmt() {
        if (this.jmt == null && this.context != null && this.context.getEngine() instanceof MTRete) {
            this.jmt = ((MTRete)this.context.getEngine()).getJmt();
        }
        return this.jmt;
    }

    protected void setJmt(JessModelTracing jmt) {
        this.jmt = jmt;
    }
}

