/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.trace;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jess.Defrule;
import jess.PrettyPrinter;
import jess.Visitable;

class RulePrinter
extends PrettyPrinter {
    private String ruleText = super.toString();
    static final String BLANK_VAR = "\\?_\\w*_\\w*";
    private static final String DECLARE_PATTERN = "\\s*\\(declare(\\s*\\([^)]+\\))(\\))?";
    private static final String DECLARE_MORE_PATTERN = "^(\\s*\\([^)]+\\))(\\))?";
    private static Pattern declarePattern = null;
    private static Pattern declareMorePattern = null;

    public RulePrinter(Defrule rule) {
        super((Visitable)rule);
    }

    String patternIndexToLineNo(int i) {
        return RulePrinter.patternIndexToLineNo(i, this.ruleText);
    }

    static String patternIndexToLineNo(int i, String text) {
        Matcher m;
        boolean declareFound;
        if (i < 0) {
            return "";
        }
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "patternIndexToLineNo text:\n" + text);
        }
        if (declarePattern == null) {
            declarePattern = Pattern.compile(DECLARE_PATTERN);
        }
        if (declareFound = (m = declarePattern.matcher(text)).find()) {
            int declareCount = 1;
            String declare = m.group(1);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "patternIndexToLineNo declare[" + declareCount + "]=" + declare);
            }
            if (m.group(2) == null) {
                if (declareMorePattern == null) {
                    declareMorePattern = Pattern.compile(DECLARE_MORE_PATTERN, 8);
                }
                int end = m.end();
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "text.substring(" + end + ")=" + text.substring(end));
                }
                m = declareMorePattern.matcher(text.substring(m.end()));
                while (declareFound == m.find()) {
                    declare = m.group(1);
                    if (declare != null) {
                        ++declareCount;
                    }
                    if (trace.getDebugCode("mt")) {
                        trace.outNT("mt", "patternIndexToLineNo declare[" + declareCount + "]=" + declare);
                    }
                    if (m.group(2) == null) continue;
                }
            }
            i += declareCount;
        }
        StringBuffer result = new StringBuffer("line ");
        return result.append(String.valueOf(++i)).toString();
    }

    public String toString() {
        int i = 0;
        String[] tkns = this.ruleText.split("\n");
        StringBuffer sb = new StringBuffer(i < tkns.length ? tkns[i++] : "");
        while (i < tkns.length) {
            sb.append("\n\n");
            if (i < 10) {
                sb.append(" ");
            }
            sb.append(String.valueOf(i)).append(tkns[i++]);
        }
        this.ruleText = sb.toString();
        return this.ruleText.replaceAll(BLANK_VAR, "?");
    }
}

