/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.MTRete;
import java.util.ArrayList;
import java.util.List;
import jess.Deftemplate;
import jess.Fact;
import jess.Funcall;
import jess.JessException;
import jess.QueryResult;
import jess.Rete;
import jess.Value;
import jess.ValueVector;

public abstract class UIRecorder {
    protected static final String RESULT_VAR = "result";
    protected final Rete rete;
    protected boolean coerceSymbolsToStrings = false;

    protected UIRecorder(Rete rete) {
        this.rete = rete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Fact> getFacts(int nParams, String ... params) {
        ArrayList<Fact> result = new ArrayList<Fact>();
        QueryResult qr = null;
        for (int trial = 0; trial < 2; ++trial) {
            try {
                int i;
                ValueVector queryParams = new ValueVector(nParams);
                int n = Math.min(nParams, params.length);
                for (i = 0; i < n; ++i) {
                    queryParams.add(MTRete.stringToValue(params[i], this.coerceSymbolsToStrings));
                }
                for (i = n; i < nParams; ++i) {
                    queryParams.add(Funcall.NIL);
                }
                qr = this.rete.runQueryStar(this.getQueryName(), queryParams);
                i = 0;
                while (qr.next()) {
                    Value uc = qr.get(RESULT_VAR);
                    result.add(uc.factValue(this.rete.getGlobalContext()));
                    if (trace.getDebugCode("sv")) {
                        trace.out("sv", "query found UI component fact[" + i + "] " + result);
                    }
                    ++i;
                }
                ArrayList<Fact> arrayList = result;
                return arrayList;
            }
            catch (JessException je) {
                if (trial > 0) {
                    trace.err("Error running defquery " + this.getQueryName() + ": " + (Object)((Object)je) + "; > " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
                    List<Fact> n = null;
                    return n;
                }
            }
            finally {
                if (qr != null) {
                    qr.close();
                }
            }
            Rete rete = this.rete;
            synchronized (rete) {
                try {
                    this.rete.eval(this.getQuery());
                }
                catch (JessException je) {
                    trace.err("Error compiling defquery " + this.getQueryName() + ": " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
                    return null;
                }
            }
        }
        return result;
    }

    public Boolean updateFirst(String ... values) {
        Deftemplate deftemplate = this.makeTemplate();
        if (deftemplate == null) {
            return null;
        }
        List<Fact> facts = this.getFacts(this.getNParams(), values);
        if (facts == null) {
            return null;
        }
        if (facts.size() < 1) {
            return this.assertFact(deftemplate, values);
        }
        return this.modifyFact(facts.get(0), values);
    }

    protected Deftemplate makeTemplate() {
        try {
            Deftemplate deftemplate = this.rete.findDeftemplate(this.getTemplateName());
            if (deftemplate == null) {
                this.rete.eval(this.getTemplate());
                deftemplate = this.rete.findDeftemplate(this.getTemplateName());
            }
            return deftemplate;
        }
        catch (JessException je) {
            trace.err("Error finding or compiling deftemplate " + this.getTemplateName() + ": " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
            return null;
        }
    }

    protected Value[] makeSlotValues(Deftemplate deftemplate, String ... javaValues) throws JessException {
        int i;
        Value[] slotValues = new Value[deftemplate.getNSlots()];
        int n = Math.min(slotValues.length, javaValues.length);
        for (i = 0; i < n; ++i) {
            slotValues[i] = MTRete.stringToValue(javaValues[i], this.coerceSymbolsToStrings);
        }
        for (i = n; i < slotValues.length; ++i) {
            slotValues[i] = deftemplate.isMultislot(i) ? Funcall.NILLIST : Funcall.NIL;
        }
        return slotValues;
    }

    protected Boolean modifyFact(Fact fact, String ... newValues) {
        try {
            Value[] slotValues = this.makeSlotValues(fact.getDeftemplate(), newValues);
            this.rete.modify(fact, fact.getDeftemplate().getSlotNames(), slotValues, this.rete.getGlobalContext());
            return Boolean.TRUE;
        }
        catch (JessException je) {
            trace.err("Error modifying " + this.getTemplateName() + " fact: " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
            return null;
        }
    }

    protected Boolean assertFact(Deftemplate deftemplate, String ... newValues) {
        try {
            Fact fact = new Fact(deftemplate);
            Value[] slotValues = this.makeSlotValues(deftemplate, newValues);
            for (int i = 0; i < slotValues.length; ++i) {
                fact.set(slotValues[i], i);
            }
            this.rete.assertFact(fact, this.rete.getGlobalContext());
        }
        catch (JessException je) {
            trace.err("Error creating or asserting fact with deftemplate " + this.getTemplateName() + ": " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
            return null;
        }
        return Boolean.FALSE;
    }

    protected abstract String getQueryName();

    public abstract String getQuery();

    protected abstract int getNParams();

    public abstract String[] getSlotNames();

    protected abstract String getTemplateName();

    protected abstract String getTemplate();
}

