/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.XMLSpecialCharsTransform;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.VariableBindingNode;
import edu.cmu.pact.jess.WhyNot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jess.Deftemplate;
import jess.Fact;
import jess.JessException;
import jess.Value;

public class VBNTableModel
extends AbstractTableModel {
    private static final int COLUMN_COUNT = 2;
    private static final String[] columnNames = new String[]{"Name", "Value"};
    private final WhyNot whyNot;
    private List entries = new ArrayList();

    public List getEntries() {
        return this.entries;
    }

    public VBNTableModel(WhyNot whyNot, List vbnList) {
        this.whyNot = whyNot;
        if (vbnList == null) {
            return;
        }
        Iterator it = vbnList.iterator();
        while (it.hasNext()) {
            this.entries.add(new Entry((VariableBindingNode)it.next()));
        }
    }

    void add(VariableBindingNode vbn) {
        this.entries.add(new Entry(vbn));
    }

    Iterator nameIterator() {
        return new NameIterator();
    }

    public int findDisplayName(String displayName) {
        if (displayName == null) {
            return -1;
        }
        int rowIndex = 0;
        for (Entry entry : this.entries) {
            if (displayName.equals(entry.getDisplayName())) {
                return rowIndex;
            }
            ++rowIndex;
        }
        return -1;
    }

    public String getDisplayName(int rowIndex) {
        return this.getEntry(rowIndex).getDisplayName();
    }

    public String getDisplayValue(int rowIndex) {
        return this.getEntry(rowIndex).getDisplayValue();
    }

    public String getToolTipText(int rowIndex) {
        Entry entry = this.getEntry(rowIndex);
        return entry.getToolTipText();
    }

    @Override
    public int findColumn(String columnName) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnNames[i].equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnNames.length <= columnIndex) {
            return "";
        }
        return columnNames[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    private Entry getEntry(int rowIndex) {
        if (rowIndex < 0 || this.getRowCount() <= rowIndex) {
            throw new ArrayIndexOutOfBoundsException("rowIndex " + rowIndex + " while rowCount is " + this.getRowCount());
        }
        return (Entry)this.entries.get(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Entry entry = this.getEntry(rowIndex);
        if (columnIndex < 0 || this.getColumnCount() <= columnIndex) {
            throw new ArrayIndexOutOfBoundsException("columnIndex " + columnIndex + " while columnCount is " + this.getColumnCount());
        }
        return entry.getDisplayField(columnIndex);
    }

    public Object getObjectAt(int rowIndex, int columnIndex) {
        Entry entry = this.getEntry(rowIndex);
        if (columnIndex < 0 || this.getColumnCount() <= columnIndex) {
            throw new ArrayIndexOutOfBoundsException("columnIndex " + columnIndex + " while columnCount is " + this.getColumnCount());
        }
        return entry;
    }

    public static String factToHtmlTable(Fact fact) {
        StringBuffer sb = new StringBuffer("<html><table border=\"1\" cellpadding=\"1\">");
        int id = fact.getFactId();
        Deftemplate dt = fact.getDeftemplate();
        sb.append("\n<caption>" + dt.getBaseName() + " fact-").append(id).append("</caption>");
        for (int i = 0; i < dt.getNSlots(); ++i) {
            String sName = "";
            String sVal = "";
            try {
                sName = dt.getSlotName(i);
            }
            catch (JessException je) {
                trace.err("Error getting name for slot " + i + " in Fact-" + id + ": " + (Object)((Object)je));
                continue;
            }
            try {
                Value val = fact.get(i);
                sVal = XMLSpecialCharsTransform.transformSpecialChars(val.toString());
            }
            catch (JessException je) {
                trace.err("Error getting value for slot " + i + "(" + sName + ") in Fact-" + id + ": " + (Object)((Object)je));
                sVal = "(error)";
            }
            sb.append("\n<tr><td>").append(sName).append("</td>");
            sb.append("<td>").append(sVal).append("</td></tr>");
        }
        return sb.append("\n</table>").toString();
    }

    public class Entry {
        private final VariableBindingNode vbn;
        private String displayName = null;
        private String displayValue = null;
        private String toolTipText = null;

        private Entry(VariableBindingNode vbn) {
            this.vbn = vbn;
        }

        private String getDisplayField(int columnIndex) {
            if (columnIndex == 0) {
                return this.getDisplayName();
            }
            if (columnIndex == 1) {
                return this.getDisplayValue();
            }
            throw new ArrayIndexOutOfBoundsException("columnIndex " + columnIndex + " while columnCount is " + VBNTableModel.this.getColumnCount());
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                this.init();
            }
            return this.displayName;
        }

        public String getDisplayValue() {
            if (this.displayName == null) {
                this.init();
            }
            return this.displayValue;
        }

        public String getToolTipText() {
            if (this.toolTipText != null) {
                return this.toolTipText;
            }
            if (this.displayName == null) {
                this.init();
            }
            try {
                Fact fact = this.vbn.getVariableValue().factValue(VBNTableModel.this.whyNot.getContext());
                StringBuffer sb = new StringBuffer("<html>");
                sb.append(VBNTableModel.factToHtmlTable(fact));
                sb.append("</html>");
                this.toolTipText = sb.toString();
            }
            catch (JessException je) {
                this.toolTipText = this.displayValue;
            }
            return this.toolTipText;
        }

        private void init() {
            StringBuffer sb = new StringBuffer(this.vbn.getExtVariableName());
            if (sb.charAt(0) != '(') {
                sb.insert(0, '?');
            }
            this.displayName = sb.toString();
            this.displayValue = this.vbn.formatValue(VBNTableModel.this.whyNot.getContext());
        }
    }

    private class NameIterator
    implements Iterator {
        private Iterator delegate;

        public NameIterator() {
            this.delegate = VBNTableModel.this.entries.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("iterator is immutable");
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            Entry entry = (Entry)this.delegate.next();
            return entry.getDisplayName();
        }
    }
}

