/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.miss.AskHintClAlgebraTutor;
import edu.cmu.pact.miss.InquiryClAlgebraTutor;
import edu.cmu.pact.miss.InquiryClSolverTutor;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import java.util.Vector;

public class AskHintInBuiltClAlgebraTutor
extends AskHintClAlgebraTutor {
    public static final String COMM_STEM = "commTable";

    public AskHintInBuiltClAlgebraTutor(BR_Controller brController, ProblemNode currentNode) {
        super(brController, currentNode);
    }

    @Override
    public void getHint(BR_Controller brController, ProblemNode currentNode) {
        InquiryClSolverTutor iclSolverTutor = new InquiryClSolverTutor();
        if (brController.getMissController().getSimSt().isSaiConverterDefined()) {
            iclSolverTutor.setSAIConverter(brController.getMissController().getSimSt().getSAIConverter());
        }
        int numSteps = iclSolverTutor.goToState(brController, currentNode);
        String hintMessage = iclSolverTutor.askNextStep();
        String clAction = hintMessage.split(";")[1];
        String skillName = null;
        if ("done".equals(clAction)) {
            skillName = "done";
            this.setSelection("done");
            this.setAction("ButtonPressed");
            this.setInput("-1");
            this.setSai(new Sai(this.getSelection(), this.getAction(), this.getInput()));
        } else {
            String newInput;
            skillName = numSteps == 0 ? clAction : iclSolverTutor.getCurrentSkill() + "-typein";
            if (brController.getMissController().getSimSt().isSaiConverterDefined()) {
                this.setSelection(iclSolverTutor.getSAIConverter().convertClResponseToCtatSai(brController, currentNode, clAction));
                this.setInput(this.findInput(hintMessage, numSteps));
                this.setSai(new Sai(this.getSelection(), this.getAction(), this.getInput()));
                if (iclSolverTutor.getSAIConverter().isSelectionTransformationStep(this.getSelection())) {
                    String[] msg = null;
                    msg = iclSolverTutor.getHintMessages(this.getSelection(), "", "");
                    if (msg != null) {
                        this.setHintMsg(msg);
                    }
                }
            } else {
                int stepDepth;
                String selection = "commTable1_";
                ProblemNode startNode = brController.getProblemModel().getStartNode();
                Vector path = InquiryClAlgebraTutor.findPathDepthFirst(startNode, currentNode);
                int n = stepDepth = path == null ? 0 : path.size();
                if (stepDepth % 3 == 0) {
                    selection = selection + "C3R" + (stepDepth / 3 + 1);
                } else {
                    int column = "left".equals(clAction) ? 1 : 2;
                    selection = selection + "C" + column + "R" + (stepDepth / 3 + 2);
                }
                this.setSelection(selection);
                this.setInput(this.findInput(hintMessage, numSteps));
                this.setSai(new Sai(this.getSelection(), this.getAction(), this.getInput()));
            }
            if (brController != null && brController.getMissController() != null && brController.getMissController().getSimSt() != null && brController.getMissController().getSimSt().isInputCheckerDefined() && !brController.getMissController().getSimSt().getInputChecker().checkInput(this.getSelection(), this.getInput(), null, null) && (newInput = brController.getMissController().getSimSt().getInputChecker().interpret(this.getSelection(), this.getInput())) != null && newInput.length() > 0) {
                this.setInput(newInput);
                this.setSai(new Sai(this.getSelection(), this.getAction(), this.getInput()));
            }
        }
        this.setSkillName(skillName);
    }

    private String findInput(String hintMessage, int numSteps) {
        String input = null;
        String[] msg = hintMessage.split(";");
        if (numSteps == 0) {
            input = msg[1];
            if (EqFeaturePredicate.isOperandArithmeticSkill(msg[1])) {
                input = input + " " + msg[2];
            }
        } else {
            input = msg[2];
        }
        return input;
    }

    private String findSelection(BR_Controller brController, ProblemNode currentNode, String clAction) {
        int stepDepth;
        String selection = "commTable1_";
        ProblemNode startNode = brController.getProblemModel().getStartNode();
        Vector path = InquiryClAlgebraTutor.findPathDepthFirst(startNode, currentNode);
        int n = stepDepth = path == null ? 0 : path.size();
        if (stepDepth % 3 == 0) {
            selection = selection + "C3R" + (stepDepth / 3 + 1);
        } else {
            int column = "left".equals(clAction) ? 1 : 2;
            selection = selection + "C" + column + "R" + (stepDepth / 3 + 2);
        }
        if (selection.length() > COMM_STEM.length()) {
            char table = selection.charAt(COMM_STEM.length());
            int colIndex = selection.indexOf(67) + 1;
            char col = selection.charAt(colIndex);
            int rowIndex = selection.indexOf(82) + 1;
            char row = selection.charAt(rowIndex);
            selection = COMM_STEM + col + "_C" + table + "R" + row;
        }
        return selection;
    }
}

