/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.BrdAnalyzer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class StepAnalysis {
    String logOutputFile;
    PrintStream outP;
    boolean isBadBrd = false;
    String buffer = null;

    public String getLogOutputFile() {
        return this.logOutputFile;
    }

    public void setLogOutputFile(String logOutputFile) {
        this.logOutputFile = logOutputFile;
    }

    public StepAnalysis(String logOutputFile) {
        this.setLogOutputFile(logOutputFile);
    }

    public void analyzeStepsForBrd(String brdPath) {
        this.isBadBrd = false;
        this.buffer = "";
        String prevSourceID = null;
        int numAttempts = -100000;
        String studentName = this.studentName(brdPath);
        String brdName = this.lastToken(brdPath);
        Vector nodes = new Vector();
        Vector edges = new Vector();
        this.gatherNodeAndEdge(brdPath, nodes, edges);
        for (int i = 0; i < edges.size() && !this.isBadBrd; ++i) {
            Element edge = (Element)edges.get(i);
            EdgeProps ep = new EdgeProps(edge, nodes);
            numAttempts = ep.sourceID.equals(prevSourceID) ? ++numAttempts : 1;
            prevSourceID = ep.sourceID;
            this.printLineToBuffer(studentName, brdName, ep.stateName, ep.selectionStr, ep.actionStr, ep.inputStr, ep.ruleName, ep.correctness, numAttempts);
        }
        if (!this.isBadBrd) {
            this.printBufferToFile();
        } else {
            System.err.println("The file " + brdPath + " is a bad BRD, and was not printed to the log.");
        }
    }

    private String studentName(String brdPath) {
        int lastSlash = Math.max(brdPath.lastIndexOf("/"), brdPath.lastIndexOf("\\"));
        String studentPath = brdPath.substring(0, lastSlash - 1);
        return this.lastToken(studentPath);
    }

    private String getStateName(Vector nodes, String destID) {
        String stateName = null;
        for (int j = 0; j < nodes.size(); ++j) {
            Element node = (Element)nodes.get(j);
            String id = node.getChild("uniqueID").getValue();
            if (!id.equals(destID)) continue;
            stateName = node.getChild("text").getValue();
            break;
        }
        return stateName;
    }

    private String gatherNodeAndEdge(String brdPath, Vector nodes, Vector edges) {
        String problemName = "";
        Document doc = this.buildDocument(brdPath);
        Element rootElement = null;
        try {
            rootElement = doc.getRootElement();
        }
        catch (Exception e) {
            this.handleBadBrdException(e);
        }
        List els = null;
        try {
            els = rootElement.getChildren();
        }
        catch (Exception e) {
            this.handleBadBrdException(e);
        }
        for (Element e : els) {
            if (e.getName().equalsIgnoreCase("node")) {
                nodes.add(e);
                continue;
            }
            if (e.getName().equalsIgnoreCase("edge")) {
                edges.add(e);
                continue;
            }
            if (!e.getName().equalsIgnoreCase("startNodeMessages")) continue;
            problemName = this.getProblemName(e);
        }
        return problemName;
    }

    private String getProblemName(Element e) {
        List messages = e.getChildren();
        for (int i = 0; i < messages.size(); ++i) {
            Element problemName;
            Element message = (Element)messages.get(i);
            Element properties = message.getChild("properties");
            if (properties == null || (problemName = properties.getChild("ProblemName")) == null) continue;
            return problemName.getValue();
        }
        return null;
    }

    private Document buildDocument(String brdPath) {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(brdPath);
        }
        catch (Exception e) {
            this.handleBadBrdException(e);
        }
        return doc;
    }

    public void printLineToBuffer(String studentName, String brdName, String stateName, String selection, String action, String input, String ruleName, String correctness, int numAttempts) {
        if (input.charAt(0) == '-') {
            input = "\"" + input + "\"";
        }
        String logStr = studentName + "\t" + brdName + "\t" + stateName + "\t" + selection + "\t" + action + "\t" + input + "\t" + ruleName + "\t" + correctness + "\t" + numAttempts + "\n";
        this.buffer = this.buffer + logStr;
    }

    private void printBufferToFile() {
        this.outP.print(this.buffer);
    }

    private void handleBadBrdException(Exception e) {
        this.isBadBrd = true;
        e.printStackTrace();
    }

    private String lastToken(String path) {
        String[] backslashTokens = path.split("\\\\");
        int size = backslashTokens.length;
        String[] forwardslashTokens = backslashTokens[size - 1].split("/");
        size = forwardslashTokens.length;
        return forwardslashTokens[size - 1];
    }

    public void analyzeStepsForSubDir(String input) {
        File f = new File(input);
        String[] brdFiles = f.list();
        for (int i = 0; i < brdFiles.length; ++i) {
            String childFileName = brdFiles[i];
            File childFile = new File(f, childFileName);
            String childFilePath = childFile.getAbsolutePath();
            if (childFile.isDirectory()) {
                this.analyzeStepsForSubDir(childFilePath);
            }
            if (!childFileName.matches(".*brd$")) continue;
            this.analyzeStepsForBrd(childFilePath);
        }
    }

    public void analyzeStepsForTopDir(String input) {
        try {
            FileOutputStream out = new FileOutputStream(this.getLogOutputFile());
            this.outP = new PrintStream(out);
            String header = "student_name\tbrd_name\tstate_name\tselection\taction\tinput\trule_name\tcorrectness\tnum_attempts\n";
            this.outP.print(header);
            File f = new File(input);
            if (f.isDirectory()) {
                String[] brdFiles = f.list();
                for (int i = 0; i < brdFiles.length; ++i) {
                    String childFileName = brdFiles[i];
                    File childFile = new File(f, childFileName);
                    String childFilePath = childFile.getAbsolutePath();
                    if (childFile.isDirectory()) {
                        this.analyzeStepsForSubDir(childFilePath);
                    }
                    if (!childFileName.matches(".*brd$")) continue;
                    this.analyzeStepsForBrd(childFilePath);
                }
                this.outP.close();
            } else if (input.matches(".*brd$")) {
                this.analyzeStepsForBrd(input);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        StepAnalysis stepAnalysis = new StepAnalysis(args[1]);
        stepAnalysis.analyzeStepsForTopDir(args[0]);
    }

    public class EdgeProps {
        String sourceID;
        String stateName;
        String selectionStr;
        String actionStr;
        String inputStr;
        String ruleName;
        String correctness;

        public EdgeProps(Element edge, Vector nodes) {
            try {
                this.sourceID = edge.getChild("sourceID").getValue();
            }
            catch (Exception e) {
                StepAnalysis.this.handleBadBrdException(e);
            }
            try {
                this.stateName = StepAnalysis.this.getStateName(nodes, this.sourceID);
            }
            catch (Exception e) {
                StepAnalysis.this.handleBadBrdException(e);
            }
            Element actionLabel = null;
            try {
                actionLabel = edge.getChild("actionLabel");
            }
            catch (Exception e) {
                StepAnalysis.this.handleBadBrdException(e);
            }
            Element properties = null;
            try {
                properties = actionLabel.getChild("message").getChild("properties");
            }
            catch (Exception e) {
                StepAnalysis.this.handleBadBrdException(e);
            }
            try {
                this.selectionStr = properties.getChild("Selection").getChild("value").getValue();
                this.actionStr = properties.getChild("Action").getChild("value").getValue();
                this.inputStr = properties.getChild("Input").getChild("value").getValue();
            }
            catch (Exception e) {
                StepAnalysis.this.handleBadBrdException(e);
            }
            Element rule = edge.getChild("rule");
            this.ruleName = rule.getChild("text").getValue();
            try {
                this.correctness = actionLabel.getChild("actionType").getValue();
            }
            catch (Exception e) {
                StepAnalysis.this.handleBadBrdException(e);
            }
        }
    }
}

