/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.miss.InquiryClAlgebraTutor;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import java.util.Vector;

public class ClAlgebraTutorHint {
    private String bottomOutHint = "";
    private static final String YOU_CAN_ = "You can ";
    private static final String TYPE_IN_ = "Type in ";
    private static final String CLT = "Add/Subtract terms";
    private static final String CLT2 = "Select Simplify Signs";
    private static final String MT = "Perform multiplication";
    private static final String RF = "Simplify fractions";
    private static final String CLT_TYPEIN = "combine";
    private static final String RF_TYPEIN = "simplify";
    private static final String SKILL_ADD = "add";
    private static final String SKILL_SUB = "subtract";
    private static final String SKILL_MULTI = "multiply";
    private static final String SKILL_DIV = "divide";
    private static final String SKILL_TYPEIN = "typein";
    private static final String SKILL_CLT = "clt";
    private static final String SKILL_MT = "mt";
    private static final String SKILL_RF = "rf";
    private String[] hint;
    private String skillName = null;
    private String selection = null;
    private final String action = "UpdateTable";
    private String input = null;
    private Sai sai = null;

    public String getButtomOutHint() {
        return this.bottomOutHint;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public String getSkillName() {
        return this.skillName;
    }

    public String getInput() {
        return this.input;
    }

    public String getAction() {
        return this.action;
    }

    public ClAlgebraTutorHint(String hintMessageList) {
        this.hint = hintMessageList.split(";");
        String bottomOutHint = this.bottomOutHint = this.hint[this.hint.length - 1];
        if (bottomOutHint.startsWith(YOU_CAN_)) {
            bottomOutHint = bottomOutHint.replaceAll(YOU_CAN_, "");
        }
        this.skillName = this.parseSkillName(bottomOutHint);
        this.input = this.parseInput(bottomOutHint);
    }

    private String parseInput(String hintMessage) {
        String input = "";
        if (EqFeaturePredicate.isBasicArithmeticSkill(this.skillName)) {
            input = this.getSkillName() + " " + this.parseOperand(hintMessage);
        } else if (EqFeaturePredicate.isValidSimplificationSkill(this.getSkillName())) {
            input = this.getSkillName();
        } else if (this.isSkillTypein(this.getSkillName())) {
            input = hintMessage.split("</?literal>")[1];
        }
        return input;
    }

    private boolean isSkillTypein(String skillName) {
        return skillName.endsWith(SKILL_TYPEIN);
    }

    private String parseOperand(String hintMessage) {
        String operand = null;
        try {
            if (hintMessage.indexOf("<expression>") > 0) {
                operand = hintMessage.split("</?expression>")[1];
            } else if (this.getSkillName().equals(SKILL_ADD) || this.getSkillName().equals(SKILL_SUB)) {
                operand = hintMessage.split(" ")[1];
            } else if (this.getSkillName().equals(SKILL_MULTI) || this.getSkillName().equals(SKILL_DIV)) {
                operand = hintMessage.split(" ")[4];
                operand = operand.substring(0, operand.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return operand;
    }

    private String parseSkillName(String hintMessage) {
        String keyWord = hintMessage.split(" ")[0];
        if (SKILL_ADD.equalsIgnoreCase(keyWord)) {
            return SKILL_ADD;
        }
        if (SKILL_SUB.equalsIgnoreCase(keyWord)) {
            return SKILL_SUB;
        }
        if (SKILL_MULTI.equalsIgnoreCase(keyWord)) {
            return SKILL_MULTI;
        }
        if (SKILL_DIV.equalsIgnoreCase(keyWord)) {
            return SKILL_DIV;
        }
        if (hintMessage.startsWith(TYPE_IN_)) {
            return this.parseSkillTypein();
        }
        if (hintMessage.startsWith(CLT) || hintMessage.startsWith(CLT2)) {
            return SKILL_CLT;
        }
        if (hintMessage.startsWith(MT)) {
            return SKILL_MT;
        }
        if (hintMessage.startsWith(RF)) {
            return SKILL_RF;
        }
        new Exception("ClAlgebraTutorHint: unknown hint type: " + hintMessage).printStackTrace();
        return null;
    }

    private String parseSkillTypein() {
        String skillTypein = "";
        String typeinHint = this.hint[this.hint.length - 2];
        String skill = typeinHint.split(" ")[0].toLowerCase();
        String skill2 = typeinHint.split(" ")[1].toLowerCase();
        if (EqFeaturePredicate.isBasicArithmeticSkill(skill)) {
            skillTypein = skill + "-" + SKILL_TYPEIN;
        } else if (CLT_TYPEIN.equals(skill)) {
            skillTypein = "clt-typein";
        } else if (RF_TYPEIN.equals(skill)) {
            skillTypein = "rf-typein";
        } else if ("multiplication".equals(skill2)) {
            skillTypein = "mt-typein";
        } else {
            new Exception("ClAlgebraTutorHint: invalid skill name for typein >>> " + typeinHint).printStackTrace();
        }
        return skillTypein;
    }

    public Sai getSAI(BR_Controller brController, ProblemNode currentNode) {
        if (this.selection == null) {
            this.selection = this.findSelection(brController, currentNode);
        }
        if (this.sai == null) {
            this.sai = new Sai(this.selection, this.action, this.input);
        }
        return this.sai;
    }

    private String findSelection(BR_Controller brController, ProblemNode currentNode) {
        int stepDepth;
        String selection = "commTable1_";
        ProblemNode startNode = brController.getProblemModel().getStartNode();
        Vector path = InquiryClAlgebraTutor.findPathDepthFirst(startNode, currentNode);
        int n = stepDepth = path == null ? 0 : path.size();
        if (stepDepth % 3 == 0) {
            selection = selection + "C3R" + (stepDepth / 3 + 1);
        } else {
            int column = this.bottomOutHint.endsWith("left.") ? 1 : 2;
            selection = selection + "C" + column + "R" + (stepDepth / 3 + 2);
        }
        return selection;
    }
}

