/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.MetaTutor;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.SimSt;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLReader {
    private static final long serialVersionUID = 1L;
    public static final String PR_MESSAGES_FILE = "prMsgs.xml";
    private String prMsgsFile = "";
    private static final Pattern rulePrefix = Pattern.compile("^[Mm][Aa][Ii][Nn][:][:]");
    private DocumentBuilderFactory docBuilderFactory;
    private DocumentBuilder docBuilder;
    private Document doc;
    private SimSt simSt;

    public SimSt getSimSt() {
        return this.simSt;
    }

    public void setSimSt(SimSt simSt) {
        this.simSt = simSt;
    }

    public XMLReader() {
        this(null);
    }

    public XMLReader(SimSt ss) {
        this.simSt = ss;
        this.init();
    }

    public XMLReader(SimSt ss, String path) {
        this.simSt = ss;
        this.prMsgsFile = path;
        this.init();
    }

    void init() {
        try {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
            this.doc = this.prMsgsFile.isEmpty() ? this.docBuilder.parse(new DataInputStream(new FileInputStream(new File(this.simSt.getProjectDir(), PR_MESSAGES_FILE)))) : this.docBuilder.parse(new DataInputStream(new FileInputStream(new File(this.simSt.getProjectDir(), this.prMsgsFile))));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.doc != null) {
            this.doc.getDocumentElement().normalize();
        }
    }

    public void parseXMLFile(String ruleName, ArrayList<ArrayList<String>> list) {
        NodeList messageSet = this.doc.getElementsByTagName("message-set");
        for (int i = 0; i < messageSet.getLength(); ++i) {
            Node node = messageSet.item(i);
            if (node.getNodeType() != 1) continue;
            Element message = (Element)node;
            NodeList nameList = message.getElementsByTagName("name");
            Element name = (Element)nameList.item(0);
            if (!(ruleName = ruleName.replaceAll("&\\d$", "")).replaceAll("^[Mm][Aa][Ii][Nn][:][:]", "").equals(name.getChildNodes().item(0).getNodeValue().trim())) continue;
            NodeList menuOptionList = message.getElementsByTagName("menu-option");
            Element menuOption = (Element)menuOptionList.item(0);
            for (int j = 0; j < menuOption.getChildNodes().getLength(); ++j) {
                Node option = menuOption.getChildNodes().item(j);
                if (!(option instanceof Element)) continue;
                Element childElement = (Element)option;
                Text text = (Text)childElement.getFirstChild();
                String msg = text.getData().trim();
                this.setMenuOptionMessage(msg, list);
            }
        }
    }

    private void setMenuOptionMessage(String msg, ArrayList<ArrayList<String>> list) {
        if (msg != null) {
            msg = msg.trim();
        }
        if (msg.length() > 0) {
            String[] tokens = msg.split(":");
            if (tokens.length == 2) {
                ArrayList<String> msgContent = new ArrayList<String>();
                msgContent.add(tokens[0]);
                tokens[1] = XMLReader.resolveWMValues(tokens[1]);
                msgContent.add(tokens[1]);
                list.add(msgContent);
            } else {
                trace.err("Format of menuMessages is incorrect");
            }
        }
    }

    public static String resolveWMValues(String msg) {
        int c = 36;
        Object value = null;
        String field = null;
        int beginIndex = msg.indexOf(c);
        if (beginIndex == -1) {
            return msg;
        }
        int endIndex = msg.indexOf(c, beginIndex + 1);
        if (endIndex == -1) {
            return msg;
        }
        try {
            field = msg.substring(beginIndex + 1, endIndex);
            msg = msg.replaceAll("\\$", "");
            msg = msg.replace(field, SimSt.SimStName);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return msg;
    }
}

