/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.GameShow;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.miss.PeerLearning.GameShow.Connection;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.console.controller.MissController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class DummyContestant {
    private static final long serialVersionUID = 1L;
    Socket echoSocket = null;
    PrintWriter out = null;
    BufferedReader in = null;
    ListenerThread listener;
    String nameImg = "Dummy,SimStudentLuckyImage.png";
    private SimSt simSt = null;
    private MissController missController = null;
    private BR_Controller brController = null;

    public DummyContestant() {
        this.init();
    }

    public void init() {
        try {
            this.echoSocket = new Socket("mocha.pslc.cs.cmu.edu", 4444);
            this.out = new PrintWriter(this.echoSocket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.echoSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection.");
            System.exit(1);
        }
        Connection connection = new Connection(this.echoSocket, this.out, this.in);
        this.listener = new ListenerThread(connection);
        new Thread(this.listener).start();
        this.out.println("JoinProgram," + this.nameImg);
    }

    public SimSt getSimSt() {
        return this.simSt;
    }

    public void setSimSt(SimSt simSt) {
        this.simSt = simSt;
    }

    public MissController getMissController() {
        return this.missController;
    }

    public void setMissController(MissController missController) {
        this.missController = missController;
    }

    public BR_Controller getBrController() {
        return this.brController;
    }

    public void setBrController(BR_Controller brController) {
        this.brController = brController;
    }

    public void leave() {
        this.listener.activeListener = false;
        this.out.println("LeaveProgram");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            this.out.close();
            this.echoSocket.close();
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void requestProblem(String incomingMsg) {
        String problem = "" + ((int)(Math.random() * 20.0) - 10) + "x";
        if (Math.random() < 0.5) {
            problem = problem + "+" + ((int)(Math.random() * 20.0) - 10);
        }
        problem = problem + "=" + ((int)(Math.random() * 20.0) - 10);
        problem = problem.replaceAll("\\+-", "-");
        this.out.println("SubmitProblems," + problem);
    }

    public static void main(String[] args) throws IOException {
        new DummyContestant();
    }

    class ListenerThread
    extends Thread {
        boolean activeListener = true;
        Connection connection;

        ListenerThread(Connection connect) {
            this.connection = connect;
        }

        @Override
        public void run() {
            try {
                String incomingMsg;
                while (this.activeListener && (incomingMsg = this.connection.reader.readLine()) != null) {
                    System.out.println("Server: " + incomingMsg);
                    if (incomingMsg.startsWith("ListAvailable")) {
                        this.listParticipants(incomingMsg);
                    }
                    if (incomingMsg.startsWith("StartContest")) {
                        this.startContest(incomingMsg);
                    }
                    if (incomingMsg.startsWith("StartProblem")) {
                        this.startProblem(incomingMsg);
                    }
                    if (incomingMsg.startsWith("SolutionAssessed")) {
                        this.solutionAssessed(incomingMsg);
                    }
                    if (incomingMsg.startsWith("EndContest")) {
                        this.endContest(incomingMsg);
                    }
                    if (incomingMsg.startsWith("ContestRequested")) {
                        this.contestRequested(incomingMsg);
                    }
                    if (incomingMsg.startsWith("ContestAgreed")) {
                        this.contestAgreed(incomingMsg);
                    }
                    if (incomingMsg.startsWith("RequestProblem")) {
                        DummyContestant.this.requestProblem(incomingMsg);
                    }
                    if (!incomingMsg.startsWith("LeaveProgram")) continue;
                    this.activeListener = false;
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void contestAgreed(String incomingMsg) {
        }

        private void contestRequested(String incomingMsg) {
            String[] args = incomingMsg.split(",");
            this.connection.writer.println("AgreeContest," + args[1] + ",true");
        }

        private void endContest(String incomingMsg) {
            DummyContestant.this.leave();
            DummyContestant.this.init();
        }

        private void solutionAssessed(String incomingMsg) {
        }

        void listParticipants(String list) {
        }

        void startContest(String msg) {
        }

        void startProblem(String msg) {
            int nSteps;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String[] msgParts = msg.split(",");
            String problem = msgParts[1];
            String answer = "x=" + ((int)(Math.random() * 20.0) - 10);
            boolean isCorrect = false;
            int nIncorrect = nSteps = (int)(Math.random() * 10.0);
            String path = problem + " SolutionPath goes here";
            this.connection.writer.println("SolutionMade," + answer + "," + isCorrect + "," + nSteps + "," + nIncorrect + "," + path);
        }
    }
}

