/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.GameShow;

import java.net.URL;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.ImageIcon;

public class GameShowUtilities {
    private static char[] variables = new char[]{'a', 'b', 'c', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static String[] patterns = new String[]{"AV=B", "-AV=B", "AV=-B", "-AV=-B", "AV+B=D", "-AV+B=D", "AV-B=D", "-AV-B=D", "AV+B=-D", "-AV+B=-D", "B+AV=D", "B-AV=D", "-B+AV=-D", "-B-AV=D", "AV=CV", "-AV=CV", "AV+B=CV", "AV-B=CV", "-AV+B=-CV", "B-AV=CV", "B+AV=-CV", "AV=CV+B", "AV=B-CV", "AV=B+CV", "AV+B=CV+D", "AV+B=CV-D", "AV+B=-CV+D", "AV+B=-CV-D", "AV-B=CV+D", "-AV+B=CV+D", "-AV-B=CV+D", "-AV+B=-CV-D", "(AV+B)/C=D", "(AV-B)/C=D", "V/A=B", "-V/A=B", "V/A=-B", "AV+B+CV=D", "AV-B-CV=D", "(B-AV)/C=D", "(B+AV)/C=D", "-V=B", "V+B=AV", "V-B=AV", "V-B=-AV", "V-B=D", "B-V=D", "V+B=D", "B+V=D", "B=V+D", "B=V-D", "AV+B/C=D", "AV-B/C=D", "AV=B/C", "B/A-CV=D", "B/V=D"};

    public static String generate() {
        String problem = patterns[(int)(Math.random() * (double)patterns.length)];
        return GameShowUtilities.generate(problem);
    }

    public static String generate(String problem) {
        int A = (int)(Math.random() * 10.0) + 2;
        int B = (int)(Math.random() * 10.0) + 1;
        int C2 = (int)(Math.random() * 10.0) + 2;
        int D = (int)(Math.random() * 10.0) + 1;
        if (A == C2) {
            ++C2;
        }
        if (B == D) {
            ++D;
        }
        char var = variables[(int)(Math.random() * (double)variables.length)];
        problem = problem.replaceAll("A", "" + A);
        problem = problem.replaceAll("B", "" + B);
        problem = problem.replaceAll("C", "" + C2);
        problem = problem.replaceAll("D", "" + D);
        problem = problem.replaceAll("V", "" + var);
        return problem;
    }

    public static String[] generateExamples() {
        String[] examples = (String[])patterns.clone();
        for (int i = 0; i < examples.length; ++i) {
            examples[i] = GameShowUtilities.generate(examples[i]);
        }
        return examples;
    }

    public static String determinePattern(String problem) {
        String patt = "";
        String current = "";
        boolean hasA = false;
        boolean hasB = false;
        boolean hasC = false;
        boolean hasD = false;
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        for (int i = 0; i < problem.length(); ++i) {
            if (!Character.isLetterOrDigit(problem.charAt(i))) {
                if (current.length() > 0) {
                    if (patt.endsWith("/") && !hasA) {
                        hasA = true;
                        patt = patt + "A";
                        a = current;
                    } else if (patt.endsWith("/") && !hasC) {
                        hasC = true;
                        patt = patt + "C";
                        c = current;
                    } else if (!hasB) {
                        hasB = true;
                        patt = patt + "B";
                        b = current;
                    } else if (!hasD) {
                        hasD = true;
                        patt = patt + "D";
                        d = current;
                    } else if (b.equals(current)) {
                        patt = patt + "B";
                    } else if (d.equals(current)) {
                        patt = patt + "D";
                    } else if (a.equals(current)) {
                        patt = patt + "A";
                    } else if (c.equals(current)) {
                        patt = patt + "C";
                    } else if (!hasA) {
                        hasA = true;
                        patt = patt + "A";
                        a = current;
                    } else if (!hasC) {
                        hasC = true;
                        patt = patt + "C";
                        c = current;
                    } else {
                        patt = patt + current;
                    }
                }
                patt = patt + problem.charAt(i);
                current = "";
                continue;
            }
            if (Character.isLetter(problem.charAt(i))) {
                if (current.length() > 0) {
                    if (!hasA) {
                        hasA = true;
                        patt = patt + "A";
                        a = current;
                    } else if (!hasC) {
                        hasC = true;
                        patt = patt + "C";
                        c = current;
                    } else if (a.equals(current)) {
                        patt = patt + "A";
                    } else if (c.equals(current)) {
                        patt = patt + "C";
                    } else if (b.equals(current)) {
                        patt = patt + "B";
                    } else if (d.equals(current)) {
                        patt = patt + "D";
                    } else if (!hasB) {
                        hasB = true;
                        patt = patt + "B";
                        b = current;
                    } else if (!hasD) {
                        hasD = true;
                        patt = patt + "D";
                        d = current;
                    } else {
                        patt = patt + current;
                    }
                }
                patt = patt + "V";
                current = "";
                continue;
            }
            current = current + problem.charAt(i);
        }
        if (current.length() > 0) {
            if (patt.endsWith("/") && !hasA) {
                hasA = true;
                patt = patt + "A";
                a = current;
            } else if (patt.endsWith("/") && !hasC) {
                hasC = true;
                patt = patt + "C";
                c = current;
            } else {
                patt = !hasB ? patt + "B" : (!hasD ? patt + "D" : (b.equals(current) ? patt + "B" : (d.equals(current) ? patt + "D" : (a.equals(current) ? patt + "A" : (c.equals(current) ? patt + "C" : (!hasA ? patt + "A" : (!hasC ? patt + "C" : patt + current)))))));
            }
        }
        return patt;
    }

    public static boolean isSolution(String equation, String solution) {
        String[] solutionSides = solution.split("=");
        if (solutionSides.length != 2) {
            return false;
        }
        if (solutionSides[0].length() == 0 || solutionSides[1].length() == 0) {
            return false;
        }
        if (solutionSides[0].length() > 1 && solutionSides[1].length() > 1) {
            return false;
        }
        if (solutionSides[0].contains("+") || solutionSides[1].contains("+")) {
            return false;
        }
        if (solutionSides[0].contains("*") || solutionSides[1].contains("*")) {
            return false;
        }
        if (solutionSides[0].substring(1).contains("-") || solutionSides[1].substring(1).contains("-")) {
            return false;
        }
        if (solutionSides[0].split("/").length > 2 || solutionSides[1].split("/").length > 2) {
            return false;
        }
        String var = "";
        String solValue = "";
        if (solutionSides[0].length() == 1 && Character.isLetter(solutionSides[0].charAt(0))) {
            var = solutionSides[0];
            if (solutionSides[1].contains(var)) {
                return false;
            }
            solValue = solutionSides[1];
        } else if (solutionSides[1].length() == 1 && Character.isLetter(solutionSides[1].charAt(0))) {
            var = solutionSides[1];
            if (solutionSides[0].contains(var)) {
                return false;
            }
            solValue = solutionSides[0];
        } else {
            return false;
        }
        String[] equationSides = equation.split("=");
        if (equationSides.length != 2) {
            return false;
        }
        String lhs = equationSides[0].replaceAll(var, "(" + solValue + ")");
        String rhs = equationSides[1].replaceAll(var, "(" + solValue + ")");
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("JavaScript");
        String lhsEval = null;
        String rhsEval = null;
        try {
            lhsEval = "" + engine.eval(GameShowUtilities.insertMultiplySymbols(lhs));
            rhsEval = "" + engine.eval(GameShowUtilities.insertMultiplySymbols(rhs));
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        double lhsVal = Double.parseDouble(lhsEval);
        double rhsVal = Double.parseDouble(rhsEval);
        return Math.abs(lhsVal - rhsVal) < 1.0E-5;
    }

    public static String insertMultiplySymbols(String equation) {
        String[] eqParts = equation.split("\\(");
        String insertedEq = eqParts[0];
        for (int i = 1; i < eqParts.length; ++i) {
            insertedEq = insertedEq.length() == 0 ? "(" + eqParts[i] : (Character.isDigit(insertedEq.charAt(insertedEq.length() - 1)) ? insertedEq + "*(" + eqParts[i] : insertedEq + "(" + eqParts[i]);
        }
        return insertedEq;
    }

    public static String replacePiece(String message, String name) {
        while (message.contains("$1")) {
            message = message.replace("$1", name);
        }
        return message;
    }

    public static String replaceTwoPieces(String message, String name, String name2) {
        while (message.contains("$1")) {
            message = message.replace("$1", name);
        }
        while (message.contains("$2")) {
            message = message.replace("$2", name2);
        }
        return message;
    }

    public static ImageIcon createImageIcon(String path) {
        String file = "/edu/cmu/pact/miss/PeerLearning/" + path;
        URL url = GameShowUtilities.class.getResource(file);
        return new ImageIcon(url);
    }

    public static ImageIcon createImageIcon(String path, Object createFor) {
        String file = "/edu/cmu/pact/miss/PeerLearning/" + path;
        URL url = createFor.getClass().getResource(file);
        return new ImageIcon(url);
    }
}

