/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.TutorialBuilderUtility;

import edu.cmu.pact.miss.PeerLearning.TutorialBuilderUtility.DOMNode;
import edu.cmu.pact.miss.PeerLearning.TutorialBuilderUtility.DOMTree;
import edu.cmu.pact.miss.PeerLearning.TutorialBuilderUtility.GUIUtility;
import java.awt.Color;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class ConfigFileRunner
implements ComponentListener {
    public static final String[] COMMANDS = new String[]{"HIGHLIGHT"};
    private static final String HIGHLIGHT = "HIGHLIGHT";
    private static final String SHOW = "SHOW";
    private static final String PLAY = "PLAY";
    private static final String CLOSE = "CLOSE";
    private static final String TITLE = "TITLE";
    private static final int ELEMENT_INDEX = 0;
    private static final int COLOR_INDEX = 1;
    private DOMTree tree;
    private String path;
    private boolean parsed = false;

    protected ConfigFileRunner(String path, DOMTree tree) {
        this.tree = tree;
        this.path = path;
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(null, message);
    }

    private void parse(String path) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.error("The provided tutorial config file was not found.");
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String command = line.split(":")[0];
                String[] arguments = line.split("\\|");
                arguments[0] = arguments[0].split(":")[1];
                if (command.equals(HIGHLIGHT)) {
                    this.highlight(arguments);
                    JOptionPane.showMessageDialog(null, "Press ok to continue");
                    continue;
                }
                if (command.equals(SHOW) || command.equals(PLAY) || command.equals(CLOSE) || command.equals(TITLE)) continue;
                reader.close();
                this.error("The provided tutorial config file was not written in the correct way. Please reference the documentation and look at the file again.\n The line the error occured on was as follows: " + line);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.parsed = true;
    }

    private void highlight(String[] args) {
        DOMNode toHighlight = this.tree.findElementByID(args[0]);
        if (toHighlight == null) {
            this.error("The component that you specified (" + args[0] + ") isn't valid. Try looking at the tree again.");
            return;
        }
        Color color = this.parseColor(args[1]);
        GUIUtility.clearAndDraw((JComponent)toHighlight.getContents(), color);
    }

    private Color parseColor(String color) {
        if ((color = color.toLowerCase()).equals("red")) {
            return Color.red;
        }
        if (color.equals("blue")) {
            return Color.blue;
        }
        if (color.equals("green")) {
            return Color.green;
        }
        if (color.equals("black")) {
            return Color.black;
        }
        if (color.equals("cyan")) {
            return Color.cyan;
        }
        if (color.equals("darkgray")) {
            return Color.darkGray;
        }
        if (color.equals("gray")) {
            return Color.gray;
        }
        if (color.equals("lightgray")) {
            return Color.lightGray;
        }
        if (color.equals("magenta")) {
            return Color.magenta;
        }
        if (color.equals("orange")) {
            return Color.orange;
        }
        if (color.equals("pink")) {
            return Color.pink;
        }
        if (color.equals("white")) {
            return Color.white;
        }
        if (color.equals("yellow")) {
            return Color.yellow;
        }
        this.error("The color you specified (" + color + ") isn't valid. Look at the documentation for colors you can use.");
        return null;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (!this.parsed) {
            this.parse(this.path);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (!this.parsed) {
            this.parse(this.path);
        }
    }

    public static enum RETURN_CODE {
        SUCCESS,
        FILE_NOT_FOUND,
        FILE_WRITTEN_WRONG,
        IO_ERROR;

    }
}

