/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import aima.search.framework.Successor;
import aima.search.framework.SuccessorFunction;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.QuizState;
import edu.cmu.pact.miss.Sai;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class QuizStateSuccessorFn
implements SuccessorFunction {
    public static final String COMM_STEM = "commTable";
    HashMap successorStateCache = new HashMap();

    public List getSuccessors(Object arg0) {
        List<Successor> successors = new ArrayList();
        QuizState current = (QuizState)arg0;
        String probNode = "" + current.getProbNode();
        if (this.successorStateCache.containsKey(probNode)) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "No need to expand the state using the activationList");
            }
            successors = (List)this.successorStateCache.get(probNode);
            this.print(successors);
            return successors;
        }
        if (current.isDoneStep() || current.equals(null)) {
            return successors;
        }
        long startTime = System.currentTimeMillis();
        Vector<RuleActivationNode> activationList = current.getSsInteractiveLearning().getSimSt().gatherActivationList(current.getProbNode());
        long duration = System.currentTimeMillis() - startTime;
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "ActivationList took  " + duration + "  ms.");
        }
        this.print(activationList);
        if (activationList.size() > 0) {
            Vector children = new Vector();
            children = this.makeChildStatesUsingActivations(current, activationList);
            for (int i = 0; i < children.size(); ++i) {
                successors.add(new Successor(((Object)activationList.elementAt(i)).toString(), children.elementAt(i)));
            }
        } else if (trace.getDebugCode("miss")) {
            trace.out("miss", "No activation for the current quiz state: " + current);
        }
        this.successorStateCache.put(probNode, successors);
        return successors;
    }

    void print(List successor) {
        for (int i = 0; i < successor.size(); ++i) {
            if (!trace.getDebugCode("miss")) continue;
            trace.out("miss", "activationList at index  " + i + "  is" + successor.get(i));
        }
    }

    private Vector makeChildStatesUsingActivations(QuizState current, Vector activationList) {
        Vector<QuizState> children = new Vector<QuizState>();
        for (int i = 0; i < activationList.size(); ++i) {
            QuizState child;
            RuleActivationNode ran = (RuleActivationNode)activationList.get(i);
            if (ran.getActualInput().equalsIgnoreCase("FALSE") || (child = this.createStateUsingRuleActivation(current, ran)) == null) continue;
            children.add(child);
        }
        return children;
    }

    private QuizState createStateUsingRuleActivation(QuizState current, RuleActivationNode ran) {
        QuizState succState = null;
        Object nextCurrentNode = null;
        ProblemNode currentNode = current.getProbNode();
        current.getSsInteractiveLearning().secureCurrentNode(currentNode);
        Sai sai = new Sai(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput());
        if (sai.getS().equals("NotSpecified") || sai.getI().equals("NotSpecified")) {
            return null;
        }
        ProblemNode successiveNode = current.getSsInteractiveLearning().simulatePerformingStep(currentNode, sai);
        if (successiveNode != null) {
            succState = new QuizState(current.getSimStPLE(), current.getSsInteractiveLearning(), current.getOriginalEqn());
            String succStateStep = "";
            if (!sai.getS().equals("done")) {
                String table = sai.getS().substring(COMM_STEM.length(), COMM_STEM.length() + 1);
                int tableIndex = Integer.parseInt(table);
                switch (tableIndex) {
                    case 1: {
                        String step;
                        succStateStep = !current.isTypeInStep() ? sai.getI() : (step = sai.getI() + " = " + current.getCurrentStep());
                        succState.setCurrentStep(succStateStep);
                        succState.setPreviousStep(current.getCurrentStep());
                        succState.setProbNode(successiveNode);
                        succState.setTypeInStep(true);
                        break;
                    }
                    case 2: {
                        String step;
                        succStateStep = !current.isTypeInStep() ? sai.getI() : (step = current.getCurrentStep() + " = " + sai.getI());
                        succState.setCurrentStep(succStateStep);
                        succState.setPreviousStep(current.getCurrentStep());
                        succState.setProbNode(successiveNode);
                        succState.setTypeInStep(true);
                        break;
                    }
                    case 3: {
                        succStateStep = current.getCurrentStep();
                        succStateStep = succStateStep + " [" + sai.getI() + "]";
                        succState.setCurrentStep(succStateStep);
                        succState.setPreviousStep(current.getCurrentStep());
                        succState.setProbNode(successiveNode);
                        succState.setTypeInStep(false);
                        break;
                    }
                }
            } else {
                succStateStep = current.getCurrentStep();
                succState.setDoneStep(true);
                succState.setCurrentStep(succStateStep);
                succState.setPreviousStep(current.getCurrentStep());
                succState.setProbNode(successiveNode);
                succState.setTypeInStep(false);
            }
        }
        return succState;
    }
}

