/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import aima.search.framework.Successor;
import aima.search.framework.SuccessorFunction;
import edu.cmu.pact.miss.FeaturePredicate;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.RhsState;
import edu.cmu.pact.miss.SimSt;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import mylib.Combinations;
import mylib.CombinatoricException;
import mylib.Permutations;

public class RhsSearchSuccessorFn
implements SuccessorFunction {
    final String VOID_OP_CLASS = "edu.cmu.pact.miss.VoidOp";
    Vector rhsOpList = new Vector();
    HashMap rhsOpCache = null;
    private boolean heuristicBasedIDS = false;

    Vector getRhsOpList() {
        return this.rhsOpList;
    }

    void setRhsOpList(Vector rhsOpList) {
        this.rhsOpList = rhsOpList;
    }

    private void addRhsOpList(String rhsOp) {
        this.rhsOpList.add(rhsOp);
    }

    private void initRhsOpList(String fileName) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            String rhsOp = null;
            while ((rhsOp = reader.readLine()) != null) {
                int commentPos = rhsOp.indexOf(59);
                if (commentPos != -1) {
                    rhsOp = rhsOp.substring(0, commentPos);
                }
                if ((rhsOp = rhsOp.replaceAll(" ", "")).length() <= 0) continue;
                this.addRhsOpList(rhsOp);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addRhsOpList("edu.cmu.pact.miss.VoidOp");
    }

    void setRhsOpCache(HashMap rhsOpCache) {
        this.rhsOpCache = rhsOpCache;
    }

    FeaturePredicate getRhsOpCache(String rhsOpName) {
        if (this.rhsOpCache != null) {
            return (FeaturePredicate)this.rhsOpCache.get(rhsOpName);
        }
        return null;
    }

    void putRhsOpCache(String rhsOpName, FeaturePredicate rhsOp) {
        if (this.rhsOpCache != null) {
            this.rhsOpCache.put(rhsOpName, rhsOp);
        }
    }

    public boolean isHeuristicBasedIDS() {
        return this.heuristicBasedIDS;
    }

    public void setHeuristicBasedIDS(boolean heuristicBasedIDS) {
        this.heuristicBasedIDS = heuristicBasedIDS;
    }

    public RhsSearchSuccessorFn() {
    }

    public RhsSearchSuccessorFn(Vector rhsOp, HashMap rhsOpCache) {
        this.setRhsOpCache(rhsOpCache);
        this.setRhsOpList(rhsOp);
    }

    public final List getSuccessors(Object object) {
        ArrayList<Successor> successors = new ArrayList<Successor>();
        RhsState rhs = (RhsState)object;
        if (rhs.numRhsOperators() <= SimSt.MAX_RHS_OPS && !SimSt.isRunningOutOfTime("RHS")) {
            Vector varList = rhs.getVarList();
            Object[] varArray = varList.toArray();
            Iterator rhsOpList = this.getRhsOpList().iterator();
            while (rhsOpList.hasNext()) {
                FeaturePredicate rhsOp = this.getRhsOp((String)rhsOpList.next());
                int arity = rhsOp.getArity();
                boolean isCommutative = rhsOp.isCommutative();
                if (varList.size() < arity) continue;
                Vector children = new Vector();
                switch (arity) {
                    case 0: {
                        children = this.getSuccessorSimple(rhs, rhsOp);
                        break;
                    }
                    case 1: {
                        children = this.getSuccessorsStraight(rhs, rhsOp, varArray);
                        break;
                    }
                    default: {
                        children = this.getSuccessorsComb(rhs, rhsOp, varArray, arity, isCommutative);
                    }
                }
                for (int i = 0; i < children.size(); ++i) {
                    successors.add((Successor)children.get(i));
                }
            }
        }
        return successors;
    }

    private Vector getSuccessorSimple(RhsState rhs, FeaturePredicate rhsOp) {
        Vector<Successor> children = new Vector<Successor>();
        RhsState child = this.makeRhsChildState(rhs, rhsOp);
        if (child != null) {
            String action = "(bind " + child.getExpVar(rhsOp) + " " + rhsOp.actionStr() + ")";
            children.add(new Successor(action, (Object)child));
        }
        return children;
    }

    private Vector getSuccessorsStraight(RhsState rhs, FeaturePredicate rhsOp, Object[] varArray) {
        Vector<Successor> children = new Vector<Successor>();
        for (int i = 0; i < varArray.length; ++i) {
            String arg = (String)varArray[i];
            if (rhsOp.getClass().getName().equals("edu.cmu.pact.miss.VoidOp") && !rhs.isGivenVar(arg)) continue;
            Vector<String> argV = new Vector<String>();
            argV.add(arg);
            rhsOp.setArgs(argV);
            RhsState child = this.makeRhsChildState(rhs, rhsOp);
            if (child == null) continue;
            String action = "(bind " + child.getExpVar(rhsOp) + " " + rhsOp.actionStr(argV) + ")";
            children.add(new Successor(action, (Object)child));
        }
        return children;
    }

    private Vector getSuccessorsComb(RhsState rhs, FeaturePredicate rhsOp, Object[] varArray, int arity, boolean isCommutative) {
        Vector<Successor> children = new Vector<Successor>();
        Enumeration varPair = this.enumerate(varArray, arity, isCommutative);
        while (varPair.hasMoreElements()) {
            Object[] argArray = (Object[])varPair.nextElement();
            Vector argV = this.arrayToVector(argArray);
            rhsOp.setArgs(argV);
            RhsState child = this.makeRhsChildState(rhs, rhsOp);
            if (child == null) continue;
            String action = "(bind " + child.getExpVar(rhsOp) + " " + rhsOp.actionStr(argV) + ")";
            children.add(new Successor(action, (Object)child));
        }
        return children;
    }

    private Enumeration enumerate(Object[] varArray, int arity, boolean isCommutative) {
        StringTokenizer varComb = null;
        if (arity == 1) {
            varComb = new StringTokenizer(this.arrayToString(varArray));
        } else {
            try {
                varComb = isCommutative ? new Combinations(varArray, arity) : new Permutations(varArray, arity);
            }
            catch (CombinatoricException e) {
                e.printStackTrace();
            }
        }
        return varComb;
    }

    RhsState makeRhsChildState(RhsState parent, FeaturePredicate rhsOp) {
        boolean opTypeMatch;
        RhsState child = (RhsState)parent.clone();
        String opName = rhsOp.getClass().getName();
        if (!opName.equals("edu.cmu.pact.miss.VoidOp") && !(opTypeMatch = child.pushExpList((FeaturePredicate)rhsOp.clone()))) {
            return null;
        }
        child.removeVarList(rhsOp.getArgs());
        return child;
    }

    private FeaturePredicate getRhsOp(String rhsOpName) {
        FeaturePredicate rhsOp = this.getRhsOpCache(rhsOpName);
        if (rhsOp == null) {
            try {
                Class<?> classDef = Class.forName(rhsOpName);
                rhsOp = (FeaturePredicate)classDef.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            this.putRhsOpCache(rhsOpName, rhsOp);
        }
        return rhsOp;
    }

    private String arrayToString(Object[] array) {
        String str = "";
        for (int i = 0; i < array.length; ++i) {
            str = str + (String)array[i] + " ";
        }
        return str;
    }

    private Object[] vectorToArray(Vector v) {
        Object[] array = new Object[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            array[i] = v.get(i);
        }
        return array;
    }

    private Vector arrayToVector(Object[] array) {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < array.length; ++i) {
            v.add(array[i]);
        }
        return v;
    }

    class RhsOperatorComparator
    implements Comparator<Object> {
        RhsOperatorComparator() {
        }

        @Override
        public int compare(Object arg0, Object arg1) {
            int h1 = ((FeaturePredicate)arg0).freqCount;
            int h2 = ((FeaturePredicate)arg1).freqCount;
            if (h1 == h2) {
                return 0;
            }
            if (h1 < h2) {
                return -1;
            }
            return 1;
        }
    }
}

