/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;

public class TypeCheckerForStoich {
    public static String[] validReasonNames = new String[]{"Given Value", "Unit Conversion", "Molecular Weight", "Avogadro's Number", "Composition Stoichiometry", "Solution Concentration"};
    public static String[] validUnitNames = new String[]{"atoms", "cm3", "fl oz", "g", "gal", "kg", "kL", "km3", "L", "lb", "mg", "mL", "mmol", "mol", "molecules", "$", "{mu}g"};
    public static String[] validSubstanceNames = new String[]{"As", "aspirin", "AsO2-", "Ba", "blood", "C", "Canadian", "C2H6", "C6H12O6", "CCl4", "Cl", "COH4", "coke", "ethanol", "Fe", "FeCl2", "Fe2O3", "fertilizer", "furan", "H", "H2", "H2O", "hemoglobin", "KCl", "MgSO4", "milk", "Na+", "Na3PO4", "Na2HPO4", "NaCl", "NH3", "O2", "O", "P4O10", "petrol", "potatoes", "sea water", "solution", "splenda", "syrup", "U.S.", "YBa2Cu3O7"};

    public static boolean isValidReason(String s) {
        for (int i = 0; i < validReasonNames.length; ++i) {
            if (!s.equalsIgnoreCase(validReasonNames[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumber(String s) {
        return EqFeaturePredicate.isFloatingPointNumber(s);
    }

    public static boolean isValidUnit(String s) {
        if (s.charAt(s.length() - 1) == 'g') {
            return true;
        }
        for (int i = 0; i < validUnitNames.length; ++i) {
            if (!s.equalsIgnoreCase(validUnitNames[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubstance(String s) {
        for (int i = 0; i < validSubstanceNames.length; ++i) {
            if (!s.equalsIgnoreCase(validSubstanceNames[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isCancel(String s) {
        return s.equalsIgnoreCase(": true");
    }

    public static Integer valueType(String value) {
        int valueType = 0;
        if (TypeCheckerForStoich.isValidReason(value)) {
            valueType = 6;
        } else if (TypeCheckerForStoich.isNumber(value)) {
            valueType = 1;
        } else if (TypeCheckerForStoich.isValidUnit(value)) {
            valueType = 7;
        } else if (TypeCheckerForStoich.isSubstance(value)) {
            valueType = 8;
        } else if (TypeCheckerForStoich.isCancel(value)) {
            valueType = 9;
        }
        return new Integer(valueType);
    }
}

