/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.jess;

import edu.cmu.pact.jess.SimStRete;
import edu.cmu.pact.miss.jess.APlusModelTracing;
import edu.cmu.pact.miss.jess.ModelTraceWorkingMemory;
import edu.cmu.pact.miss.minerva_3_1.Problem;
import java.io.Serializable;
import java.security.SecureRandom;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

public class GetSimilarProblem
implements Userfunction,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String GET_SIMILAR_PROBLEM = "get-similar-problem";
    private static char[] variables = new char[]{'a', 'b', 'c', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    protected transient APlusModelTracing amt;
    protected transient Context context;
    private static String lastAbstractedProblem;
    private static String lastSimilarProblem;
    private static int lastAbstractedProblemSolvedCount;

    public GetSimilarProblem() {
        this(null);
    }

    public GetSimilarProblem(APlusModelTracing amt) {
        this.amt = amt;
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        if (!vv.get(0).stringValue(context).equals(GET_SIMILAR_PROBLEM)) {
            throw new JessException(GET_SIMILAR_PROBLEM, "called but ValueVector head differs", vv.get(0).stringValue(context));
        }
        String problem = "NotSpecified";
        if (context.getEngine() instanceof SimStRete) {
            String[] token;
            if (vv.size() > 1) {
                problem = vv.get(1).resolveValue(context).stringValue(context);
            }
            if ((token = problem.split("=")).length == 2 && token[0].trim().equals(token[1].trim())) {
                return new Value(problem, 2);
            }
            if (token.length == 2 && token[0].trim().length() > 0 && token[1].trim().length() > 0) {
                problem = " " + token[0].trim() + "= " + token[1].trim();
                Problem abstractor = new Problem(problem);
                String abstractedPWithSignPreserved = abstractor.getSignedAbstraction();
                Integer problemCount = ModelTraceWorkingMemory.quizProblemsTutoredListAllSections.get(abstractedPWithSignPreserved);
                if (abstractedPWithSignPreserved.equals(lastAbstractedProblem) && problemCount != null && problemCount == lastAbstractedProblemSolvedCount) {
                    return new Value(lastSimilarProblem, 2);
                }
                String similarP = GetSimilarProblem.generate(abstractedPWithSignPreserved);
                lastAbstractedProblem = abstractedPWithSignPreserved;
                lastSimilarProblem = similarP;
                if (problemCount != null) {
                    lastAbstractedProblemSolvedCount = ModelTraceWorkingMemory.quizProblemsTutoredListAllSections.get(lastAbstractedProblem);
                }
                return new Value(similarP, 2);
            }
        }
        return Funcall.NIL;
    }

    public String getName() {
        return GET_SIMILAR_PROBLEM;
    }

    private static String generate(String problem) {
        int count = 0;
        for (int i = 0; i < problem.length(); ++i) {
            char current = problem.charAt(i);
            if (current != 'N') continue;
            ++count;
        }
        int[] val = new int[count];
        for (int i = 0; i < count; ++i) {
            SecureRandom rand = new SecureRandom();
            val[i] = rand.nextInt(Integer.MAX_VALUE) % 10 + 2;
        }
        char var = variables[(int)(Math.random() * (double)variables.length)];
        for (int i = 0; i < count; ++i) {
            problem = problem.replaceFirst("N", "" + val[i]);
        }
        String[] token = (problem = problem.replaceAll("[Vv]", "" + var)).split("=");
        if (token.length == 2 && token[0].trim().length() > 0 && token[1].trim().length() > 0) {
            problem = token[0].trim() + "  =  " + token[1].trim();
        }
        return problem;
    }
}

