/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra;

import cl.utilities.sm.Expression;
import edu.cmu.pact.miss.userDef.algebra.CLBased;
import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ExpParseException;
import java.util.Vector;

public class DivTerm
extends CLBased {
    public DivTerm() {
        this.setArity(2);
        this.setName("div-term");
        this.setReturnValueType(1);
        this.setArgValueType(new int[]{1, 1});
    }

    @Override
    public String apply(Vector args) {
        String expString1 = (String)args.get(0);
        String expString2 = (String)args.get(1);
        Expression exp1 = this.parse(expString1);
        Expression exp2 = this.parse(expString2);
        Expression divided = exp1.divide(exp2).simplify();
        try {
            AlgExp e1 = AlgExp.parseExp(expString1);
            AlgExp e2 = AlgExp.parseExp(expString2);
            if (e1.equals(AlgExp.ZERO)) {
                return "0";
            }
            if (e1.equals(e2)) {
                return "1";
            }
            if (!e2.isSimple() || e2.equals(AlgExp.ZERO)) {
                return null;
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
        return this.typecheck(expString1, expString2, divided);
    }
}

