/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression;

import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.Constant;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.DoubleConst;

public class IntConst
extends Constant {
    IntConst(String s) {
        this.value = Integer.parseInt(s);
        this.isNegative = this.value < 0.0;
        this.isInt = true;
    }

    public IntConst(int c) {
        this((double)c);
    }

    public IntConst(double d) {
        this.value = d;
        this.isNegative = this.value < 0.0;
        this.isInt = true;
    }

    @Override
    public double getVal() {
        return this.value;
    }

    @Override
    public AlgExp add(DoubleConst c) {
        double result = this.value + c.getVal();
        if (result == Math.floor(result)) {
            return new IntConst((int)result);
        }
        return new DoubleConst(result);
    }

    @Override
    public AlgExp add(IntConst c) {
        return new IntConst(this.value + c.getVal());
    }

    @Override
    public AlgExp mul(DoubleConst c) {
        double result = this.value * c.getVal();
        if (result == Math.floor(result)) {
            return new IntConst((int)result);
        }
        return new DoubleConst(result);
    }

    @Override
    public AlgExp mul(IntConst c) {
        return new IntConst(this.value * c.getVal());
    }

    @Override
    public AlgExp div(DoubleConst c) {
        double result = this.value / c.getVal();
        if (result == Math.floor(result)) {
            return new IntConst((int)result);
        }
        return new DoubleConst(result);
    }

    @Override
    public AlgExp div(IntConst c) {
        int thisVal = (int)this.value;
        int otherVal = (int)c.getVal();
        if (thisVal % otherVal == 0) {
            return new IntConst(thisVal / otherVal);
        }
        return new ConstantFraction(this, c).eval();
    }

    @Override
    public AlgExp divDecimal(IntConst divident) {
        return new DoubleConst(this.getVal() / divident.getVal());
    }

    public String toString() {
        return String.valueOf((int)this.value);
    }

    @Override
    public boolean equals(IntConst c) {
        return c.getVal() == this.value;
    }

    @Override
    public boolean equals(DoubleConst c) {
        return DoubleConst.doubleEq(this.value, c.getVal());
    }

    @Override
    public AlgExp eval() {
        return this;
    }
}

