/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATBaseTutorShop;
import edu.cmu.hcii.ctat.CTATCS2NHandler;
import edu.cmu.hcii.ctat.CTATConfigPanel;
import edu.cmu.hcii.ctat.CTATContentCache;
import edu.cmu.hcii.ctat.CTATCurriculum;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATDirectoryTXT;
import edu.cmu.hcii.ctat.CTATHTTPHandler;
import edu.cmu.hcii.ctat.CTATHTTPHandlerBase;
import edu.cmu.hcii.ctat.CTATHTTPLocalHandler;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATOfflineHTTPHandler;
import edu.cmu.hcii.ctat.CTATTutorUpdater;
import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.hcii.ctat.LocalTSSystemTray;
import edu.cmu.hcii.ctat.ProblemEndHandler;
import edu.cmu.hcii.ctat.ProblemSetEndHandler;
import edu.cmu.hcii.ctat.UserProgressDatabase;
import edu.cmu.pact.Utilities.trace;
import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class CTATFlashTutorShop
extends CTATBaseTutorShop
implements ProblemSetEndHandler,
ProblemEndHandler {
    private CTATCurriculum curriculum = null;
    private UserProgressDatabase localUserDB = null;

    public CTATFlashTutorShop() {
        this.setClassName("CTATFlashTutorShop");
        this.debug("CTATFlashTutorShop ()");
        this.debug("microedition.platform: " + System.getProperty("microedition.platform"));
    }

    @Override
    protected void monitorConnectivity() {
        if (!CTATLink.remoteHost.equals("") && !CTATLink.remoteHost.equals("local")) {
            this.diags.runBackgroundConnectivityChecker();
        }
    }

    @Override
    protected void invokeBrowserOnLocalWebServer() {
        try {
            Desktop.getDesktop();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.debug("Launching browser ...");
        CTATFlashTutorShop.launchBrowser();
    }

    @Override
    protected void createSysTrayIcon() {
        this.debug("Launching trayicon ...");
        if (this.useSysTray.booleanValue()) {
            try {
                if (!Desktop.isDesktopSupported()) {
                    this.debug("Diagnostic: TutorShop is not allowed to start a desktop application");
                    return;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                LocalTSSystemTray systray = LocalTSSystemTray.getInstance();
                systray.setWebServer(this.wserver);
                systray.display();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    public static void launchBrowser() {
        CTATBase.debug("CTATHTML5Driver", "launchBrowser ()");
        URI uri = null;
        Desktop tmpDesktop = null;
        try {
            tmpDesktop = Desktop.getDesktop();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            if (CTATLink.appMode.equals("admin")) {
                if (!CTATLink.getAdminPassword()) {
                    System.exit(0);
                }
                CTATLink.adminLogin = true;
                uri = new URI("http://" + CTATLink.hostName + ":" + CTATLink.wwwPort + "/admin.html");
            } else {
                uri = new URI("http://" + CTATLink.hostName + ":" + CTATLink.wwwPort);
            }
            try {
                tmpDesktop.browse(uri);
            }
            catch (NoClassDefFoundError e) {
                JOptionPane.showMessageDialog(null, "Please open a browser and enter " + uri + " in the address bar.");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
        }
    }

    public static void makeConfigFile() {
        CTATBase.debug("CTATHTML5Driver", "makeConfigFile ()");
        try {
            CTATLink.fManager.configureCTATLink();
        }
        catch (Exception e) {
            System.err.println("Error reading config.data: " + e + ";\n  cause " + e.getCause());
            e.printStackTrace();
        }
        JFrame frame = new JFrame();
        frame.setTitle("Standalone TutorShop -- Configuration Settings");
        frame.setSize(838, 554);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new CTATConfigPanel(frame));
        frame.setVisible(true);
    }

    @Override
    protected void showExitUI() {
        this.debug("showExitUI ()");
        try {
            if (LocalTSSystemTray.getInstance().isDisplayed()) {
                return;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        final JFrame frame = new JFrame("TutorShop");
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(3, 3, 3, 3));
        JButton exitBtn = new JButton("Exit TutorShop");
        exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CTATFlashTutorShop.this.confirmExit(e, frame);
            }
        });
        panel.add(exitBtn);
        panel.setPreferredSize(new Dimension(200, 50));
        frame.getContentPane().add(panel);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CTATFlashTutorShop.this.confirmExit(e, frame);
            }
        });
        if (trace.getDebugCode("exit")) {
            trace.out("exit", "showExitUI.frame listeners " + frame.getWindowListeners() + ", defaultCloseOperation " + frame.getDefaultCloseOperation());
        }
        frame.pack();
        frame.setVisible(true);
    }

    protected void confirmExit(EventObject e, JFrame parentFrame) {
        int okCancel;
        this.debug("confirmExit ()");
        if (trace.getDebugCode("exit")) {
            trace.out("kill", "confirmExit(" + e + ")");
        }
        if ((okCancel = JOptionPane.showConfirmDialog(parentFrame, "Are you sure you want to quit TutorShop?", "Confirm Exit TutorShop", 2)) != 0) {
            return;
        }
        if (this.wserver != null && this.wserver.getHandler() instanceof CTATHTTPHandler) {
            ((CTATHTTPHandler)this.wserver.getHandler()).enqueuePushResponse(CTATHTTPHandler.PushResponse.Exit);
        }
        long ms = CTATLink.pushPollingInterval + 2000L;
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ie) {
            trace.errStack("Error while sleeping " + ms + "ms awaiting poll for exit", ie);
        }
        System.exit(0);
    }

    public static boolean downloadContent(JTextArea aConsole, JProgressBar aBar, boolean skipGlobalAssets, boolean useSwingWorker, Runnable doWhenDone) {
        CTATBase.debug("CTATFlashTutorShop", "downloadContent ()");
        boolean success = false;
        CTATTutorUpdater updater = new CTATTutorUpdater(null, aConsole, aBar);
        CTATCurriculum curr = updater.getCourse(CTATLink.FIREClass);
        if (curr == null) {
            JOptionPane.showMessageDialog(null, "Error: unable to download asssignment (" + CTATLink.lastError + ")");
            return false;
        }
        if (!CTATLink.fManager.setContents(CTATLink.htdocs + "/curriculum.xml", updater.getCurriculumXML())) {
            JOptionPane.showMessageDialog(null, "Error: unable to save: " + CTATLink.htdocs + "/curriculum.xml");
            return false;
        }
        try {
            CTATContentCache cache = new CTATContentCache(new File(CTATLink.htdocs, "/cache/"), true);
            cache.setConsole(aConsole);
            cache.setProgressBar(aBar);
            updater.updateContentFromCurriculum(curr, cache, new File(CTATLink.htdocs, "/remoteBRDs/"), CTATLink.remoteHost, skipGlobalAssets, useSwingWorker, doWhenDone);
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!success) {
            JOptionPane.showMessageDialog(null, "Content download failed.");
        }
        return success;
    }

    public static Boolean parseArgs(String[] args) {
        CTATBase.debug("CTATFlashTutorShop", "parseArgs ()");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-normal") == 0) {
                CTATLink.appMode = "normal";
            }
            if (args[i].compareTo("-safemode") == 0) {
                CTATLink.appMode = "safemode";
            }
            if (args[i].compareTo("-diagnostics") == 0) {
                CTATLink.appMode = "diagnostics";
            }
            if (args[i].compareTo("-install") == 0) {
                CTATLink.appMode = "install";
            }
            if (args[i].compareTo("-update") == 0) {
                CTATLink.appMode = "update";
            }
            if (args[i].compareTo("-admin") == 0) {
                CTATLink.appMode = "admin";
            }
            if (args[i].compareTo("-config") == 0) {
                CTATFlashTutorShop.makeConfigFile();
                return false;
            }
            if (args[i].compareTo("-XMLsUnencrypted") == 0) {
                CTATLink.problemSetXMLsAreEncrypted = false;
            }
            if (args[i].compareTo("-BRDsUnencrypted") == 0) {
                CTATLink.BRDsAreEncrypted = false;
            }
            if (args[i].compareTo("-debug") == 0) {
                CTATLink.printDebugMessages = true;
            }
            if (args[i].compareTo("-skipGlobalAssets") == 0) {
                CTATLink.skipGlobalAssets = true;
            }
            if (args[i].compareTo("-downloadcontent") != 0) continue;
            CTATLink.dlContent = true;
            CTATLink.FIREClass = args[i + 1];
        }
        return true;
    }

    @Override
    protected void runPrep() {
        this.debug("runPrep ()");
        this.killPreviousInstance();
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        CTATLink link = new CTATLink(new CTATDesktopFileManager());
        try {
            this.localUserDB = new UserProgressDatabase(true);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        CTATLink.fManager.configureCTATLink();
        if (CTATLink.remoteHost.isEmpty() || CTATLink.remoteHost.equalsIgnoreCase("local")) {
            CTATLink.cache = new CTATContentCache(new File(CTATLink.getCacheDir()), false);
            if (CTATLink.fManager.doesFileExist(CTATLink.htdocs + "/curriculum.xml")) {
                this.debug("Curriculum file exists, loading ...");
                String currContents = CTATLink.fManager.getContents(CTATLink.htdocs + "/curriculum.xml");
                try {
                    this.curriculum = new CTATCurriculum(currContents);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    JOptionPane.showMessageDialog(null, "An error occurred when reading the curriculum description (" + CTATLink.htdocs + "curriculum.xml):\n" + e.getMessage());
                    this.curriculum = null;
                }
                if (this.curriculum != null) {
                    this.debug("Curriculum check: " + this.curriculum.toString());
                    this.curriculum.loadAllProblemSets();
                }
            } else {
                this.debug("Info: " + CTATLink.htdocs + "/curriculum.xml" + " does not exist, attemting to load directory.txt instead ...");
            }
            if (this.curriculum == null) {
                this.debug("No curriculum object, attempting to load from directory.txt ...");
                CTATLink.fDirectoryTXT = new CTATDirectoryTXT();
                if (!CTATLink.fDirectoryTXT.isLoaded()) {
                    CTATLink.fDirectoryTXT.loadDirectoryTXT(CTATLink.htdocs + "FlashTutors/directory.txt");
                }
            } else {
                this.debug("We have a curriculum, no need to load directory.txt");
            }
            this.debug("Configuring the local offline code some more ...");
            this.setProblemSetEndHandler(this);
            this.setProblemEndHandler(this);
        }
        this.setUseTray(true);
    }

    @Override
    protected Boolean installHandler() throws IOException {
        CTATHTTPHandlerBase handler;
        this.debug("installHandler (" + CTATLink.handlerConfig + ")");
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd.HH.mm.SS");
        String accessLogName = "access" + dateFmt.format(new Date()) + ".log";
        if (CTATLink.handlerConfig.equalsIgnoreCase("DEFAULT")) {
            this.debug("Installing instance of CTATHTTPHandler ...");
            handler = new CTATHTTPHandler(CTATLink.htdocs, CTATLink.logdir + "/access.log");
            this.setHandler(handler);
        }
        if (CTATLink.handlerConfig.equalsIgnoreCase("LOCAL")) {
            if (!CTATLink.remoteHost.equalsIgnoreCase("local") && !CTATLink.remoteHost.isEmpty()) {
                CTATLink.lastError = "The local TutorShop is configured for local usage but the configuration has an external hostname";
                this.debug(CTATLink.lastError);
                return false;
            }
            this.debug("Installing instance of CTATHTTPLocalHandler ...");
            handler = new CTATHTTPLocalHandler(CTATLink.logdir + accessLogName, this.localUserDB);
            this.setHandler(handler);
        }
        if (CTATLink.handlerConfig.equalsIgnoreCase("OFFLINE")) {
            if (!CTATLink.remoteHost.equalsIgnoreCase("local") && !CTATLink.remoteHost.isEmpty()) {
                CTATLink.lastError = "The local TutorShop is configured for local usage but the configuration has an external hostname";
                this.debug(CTATLink.lastError);
                return false;
            }
            this.debug("Installing instance of CTATHTTPLocalHandler ...");
            handler = new CTATOfflineHTTPHandler(CTATLink.logdir + accessLogName, this.localUserDB, this.curriculum);
            this.setHandler(handler);
        }
        if (CTATLink.handlerConfig.equalsIgnoreCase("CS2N")) {
            this.debug("Installing instance of CTATCS2NHandler ...");
            try {
                handler = new CTATCS2NHandler(CTATLink.logdir + accessLogName, this.localUserDB, this.curriculum);
                ((CTATHTTPLocalHandler)handler).setCurriculum(this.curriculum);
                ((CTATCS2NHandler)handler).setUserid(System.getProperty("offline_user"));
                this.debug("Assigning local handler ...");
                this.setHandler(handler);
            }
            catch (Exception e1) {
                this.debug("Error: unable to install HTTP handler");
                CTATLink.lastError = e1.getMessage();
                this.debug(CTATLink.lastError);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isExiting() {
        return this.nowExiting;
    }

    @Override
    public boolean startExiting() {
        this.debug("startExiting ()");
        boolean result = this.nowExiting;
        this.nowExiting = true;
        this.debug("startExiting: nowExiting was " + result + "; nOtherServers " + this.otherServers.size() + "; then call dispose()");
        if (this.otherServers != null) {
            for (ExitableServer es : this.otherServers) {
                es.startExiting();
            }
        }
        return result;
    }

    @Override
    public boolean problemSetEnd(List<String> problemSummaries) {
        return false;
    }

    @Override
    public boolean problemEnd(String problemSummary) {
        return false;
    }

    public void mainForLoader(String[] args) {
        this.debug("main ()");
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        CTATLink link = new CTATLink(new CTATDesktopFileManager());
        CTATLink.fManager.configureCTATLink();
        if (!CTATFlashTutorShop.parseArgs(args).booleanValue()) {
            return;
        }
        this.debug("Starting thread ...");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CTATFlashTutorShop.this.debug("run ()");
                CTATFlashTutorShop service = new CTATFlashTutorShop();
                service.otherServers.add(CTATFlashTutorShop.this.ls);
                service.otherServers.add(CTATFlashTutorShop.this.wserver);
                service.runBasic();
            }
        });
    }

    public static void main(String[] args) {
        CTATBase.debug("CTATFlashTutorShop", "main ()");
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        CTATLink link = new CTATLink(new CTATDesktopFileManager());
        CTATLink.fManager.configureCTATLink();
        if (!CTATFlashTutorShop.parseArgs(args).booleanValue()) {
            return;
        }
        if (CTATLink.dlContent) {
            CTATFlashTutorShop.downloadContent(null, null, CTATLink.skipGlobalAssets, false, null);
            return;
        }
        CTATBase.debug("CTATFlashTutorShop", "Starting thread ...");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CTATBase.debug("CTATFlashTutorShop", "run ()");
                CTATFlashTutorShop service = new CTATFlashTutorShop();
                service.runBasic();
            }
        });
    }
}

