/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATContentCache;
import edu.cmu.hcii.ctat.CTATCryptoUtils;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATFileManager;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATWebTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CTATGeneralizedIOManager
extends CTATFileManager {
    private IOSource outputDest = IOSource.FILE;
    private CTATFileManager fileIOManager = new CTATDesktopFileManager();
    private CTATContentCache cache = null;
    private File jarfile = null;

    public IOSource getOutputDestination() {
        return this.outputDest;
    }

    public void setOutputDestination(IOSource outputDestination) {
        this.outputDest = outputDestination;
    }

    public CTATFileManager getFileIOManager() {
        return this.fileIOManager;
    }

    public boolean setFileIOManager(CTATFileManager fileIOManager) {
        if (fileIOManager != null) {
            this.fileIOManager = fileIOManager;
            return true;
        }
        return false;
    }

    public CTATContentCache getCache() {
        return this.cache;
    }

    public void setCache(CTATContentCache cache) {
        this.cache = cache;
    }

    public File getJarfile() {
        return this.jarfile;
    }

    public void setJarfile(File jarfile) {
        this.jarfile = jarfile;
    }

    @Override
    public boolean doesFileExist(String aFileURI) {
        byte[] bytes;
        try {
            bytes = this.doInput(aFileURI);
        }
        catch (IOException e) {
            return false;
        }
        return bytes != null;
    }

    @Override
    public boolean createDirectory(String aDirURI) {
        switch (this.outputDest) {
            case FILE: {
                return new File(aDirURI).mkdirs();
            }
            case CACHE: {
                return true;
            }
            case JAR: {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getContents(String aFileURI) {
        byte[] bytes;
        try {
            bytes = this.doInput(aFileURI);
            if (bytes == null) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        return new String(bytes);
    }

    @Override
    public Element getContentsXML(String aFileURI) {
        byte[] bytes;
        try {
            bytes = this.doInput(aFileURI);
            if (bytes == null) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        return this.parseXML(bytes);
    }

    @Override
    public Element getContentsXMLEncrypted(String aFileURI) {
        byte[] bytes;
        try {
            bytes = this.doInput(aFileURI);
            if (bytes == null) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        try {
            bytes = this.decrypt(bytes);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        return this.parseXML(bytes);
    }

    @Override
    public boolean setContents(String aFileURI, String aContents) {
        if (aContents == null) {
            return false;
        }
        try {
            this.doOutput(aFileURI, aContents.getBytes());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean setContentsEncrypted(String aFileURI, String aContents) {
        byte[] encrypted;
        if (aContents == null) {
            return false;
        }
        try {
            encrypted = this.encrypt(aContents.getBytes());
        }
        catch (GeneralSecurityException e) {
            return false;
        }
        if (encrypted == null) {
            return false;
        }
        try {
            this.doOutput(aFileURI, encrypted);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String getContentsEncrypted(String aFileURI) {
        byte[] decrypted;
        byte[] bytes;
        try {
            bytes = this.doInput(aFileURI);
            if (bytes == null) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        try {
            decrypted = this.decrypt(bytes);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        return decrypted == null ? null : new String(decrypted);
    }

    @Override
    public boolean configureCTATLink() {
        this.debug("configureCTATLink()");
        return this.fileIOManager.configureCTATLink();
    }

    protected void doOutput(String path, byte[] data) throws IOException {
        if (path == null || data == null) {
            return;
        }
        switch (this.outputDest) {
            case FILE: {
                boolean success = this.fileIOManager.setContents(path, new String(data));
                if (success) break;
                throw new IOException();
            }
            case CACHE: {
                this.cache.addToCache(path, data, CTATWebTools.headerDateFmt.format(new Date()), true);
                break;
            }
            case JAR: {
                throw new IOException();
            }
        }
    }

    protected byte[] doInput(String path) throws IOException {
        byte[] bytes;
        if (path == null) {
            return null;
        }
        String contents = this.fileIOManager.getContents(path);
        if (contents != null) {
            return contents.getBytes();
        }
        if (this.cache != null && (bytes = this.cache.getBytesFromCache(path, true)) != null) {
            return bytes;
        }
        if (this.jarfile != null) {
            JarFile jf = new JarFile(this.jarfile);
            ZipEntry entry = jf.getEntry(path);
            if (entry != null) {
                int b;
                BufferedInputStream in = new BufferedInputStream(jf.getInputStream(entry));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((b = ((InputStream)in).read()) != -1) {
                    baos.write(b);
                }
                ((InputStream)in).close();
                return baos.toByteArray();
            }
            jf.close();
        }
        return null;
    }

    protected Element parseXML(byte[] bytes) {
        Element documentElement = null;
        if (bytes != null) {
            Document doc;
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            }
            catch (Exception e) {
                return null;
            }
            documentElement = doc.getDocumentElement();
        }
        return documentElement;
    }

    protected byte[] decrypt(byte[] encrypted) throws GeneralSecurityException {
        if (encrypted == null) {
            return null;
        }
        CTATCryptoUtils crypto = CTATLink.crypto == null ? new CTATCryptoUtils() : CTATLink.crypto;
        String decrypted = crypto.decrypt(new String(encrypted), CTATLink.keyString);
        return decrypted == null ? null : decrypted.getBytes();
    }

    protected byte[] encrypt(byte[] decrypted) throws GeneralSecurityException {
        if (decrypted == null) {
            return null;
        }
        CTATCryptoUtils crypto = CTATLink.crypto == null ? new CTATCryptoUtils() : CTATLink.crypto;
        String encrypted = crypto.encrypt(new String(decrypted), CTATLink.keyString);
        return encrypted == null ? null : encrypted.getBytes();
    }

    public static enum IOSource {
        FILE,
        CACHE,
        JAR;

    }
}

