/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.CTATHTTPHandler;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.pact.TutoringService.LauncherHandler;
import edu.cmu.pact.Utilities.trace;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;

public class CTATHTTPServer
extends CTATBase
implements Runnable,
ExitableServer {
    protected static volatile int threadCount = 0;
    private CTATHTTPHandlerInterface handler = null;
    protected int port;
    protected String pathToRoot;
    protected String logFileName;
    protected Socket socket = null;
    private ServerSocket serverSocket = null;
    protected volatile boolean nowExiting = false;
    protected Date shutdownTime = null;

    public CTATHTTPServer(Socket s, CTATHTTPHandlerInterface handler) {
        this.setClassName("CTATHTTPServer");
        this.debug("CTATHTTPServer (" + s + ", " + trace.nh(handler) + ")");
        this.socket = s;
        this.handler = handler;
    }

    public CTATHTTPServer(int port, String pathToRoot, String logFileName) {
        this(port, pathToRoot, logFileName, null);
    }

    public CTATHTTPServer(int port, String pathToRoot, String logFileName, CTATHTTPHandlerInterface aHandler) {
        this.setClassName("CTATHTTPServer");
        this.debug("CTATHTTPServer ()");
        this.port = port;
        this.pathToRoot = pathToRoot;
        this.logFileName = logFileName;
        this.handler = aHandler;
    }

    public boolean startWebServer() {
        if (this.handler == null) {
            this.debug("startWebServer(), handler is null");
        } else if (this.handler instanceof LauncherHandler) {
            this.debug("startWebServer() where handler is a LauncherHandler; port: " + this.port);
        } else {
            this.debug("startWebServer() with handler class " + this.handler.getClass().getSimpleName());
        }
        if (this.handler == null) {
            this.debug("No handler assigned, creating default ...");
            try {
                this.handler = new CTATHTTPHandler(this.pathToRoot, this.logFileName);
            }
            catch (IOException e) {
                this.debug("Failed to open logFile, exiting HTTP Server: " + e + "\n");
                e.printStackTrace();
                return false;
            }
        }
        this.socket = null;
        new Thread((Runnable)this, "CTATHTTPServer").start();
        this.debug("Webserver started");
        return true;
    }

    @Override
    public void run() {
        if (this.socket == null) {
            Thread.currentThread().setName("HTTPServer_" + ++threadCount);
            try {
                this.serverSocket = new ServerSocket(this.port);
                this.debug("to open HTTPServer listening on port " + this.port);
                while (!this.isExiting()) {
                    Socket newSocket;
                    block14: {
                        newSocket = null;
                        try {
                            newSocket = this.serverSocket.accept();
                        }
                        catch (SocketException se) {
                            this.debug("CTATHTTPServer.run() from serverSocket.accept() isExiting() " + this.isExiting() + ";\n  error: " + se + ";\n  cause: " + se.getCause());
                            if (this.isExiting()) break block14;
                            throw se;
                        }
                    }
                    if (newSocket == null) continue;
                    new Thread(new CTATHTTPServer(newSocket, this.getHandler())).start();
                }
            }
            catch (Exception uhe) {
                this.debug("Failed to open HTTPserver on localhost: error = " + uhe);
                uhe.printStackTrace(System.out);
            }
            this.debug("run(): isExiting() " + this.isExiting() + ", shutdownTime " + this.shutdownTime);
        } else {
            this.debug("Accepted a connection on the socket, creating new HTTP Exchange Object ...");
            CTATHTTPExchange exchange = new CTATHTTPExchange();
            exchange.setHandler(this.handler);
            if (!exchange.processSocket(this.socket).booleanValue()) {
                this.debug("Error creating CTATHTTPExchange");
                return;
            }
            if (exchange.isInitialized()) {
                this.debug("CTATHTTPServer.run() handler " + trace.nh(this.handler));
                if (this.handler != null) {
                    if (this.handler.handle(exchange, null)) {
                        this.debug("The handler indicated that the server is completely done with the request. closing socket ...");
                        exchange.close();
                    } else {
                        this.debug("The handler indicated that the server isn't completely done with the request, keeping the socket open");
                    }
                } else {
                    this.debug("Error: no HTTP handler installed!");
                }
            } else {
                this.debug("CTATHTTPExchange could not be initialized.");
            }
            this.debug("HTTP Exchange handled");
        }
    }

    @Override
    public synchronized boolean isExiting() {
        return this.nowExiting;
    }

    @Override
    public synchronized boolean startExiting() {
        this.debug("startExiting ()");
        boolean result = this.nowExiting;
        this.nowExiting = true;
        this.shutdownTime = new Date();
        this.debug("startExiting() previous nowExiting " + result + ", server socket to close " + this.serverSocket);
        try {
            this.serverSocket.close();
            this.serverSocket = null;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return result;
    }

    public CTATHTTPHandlerInterface getHandler() {
        return this.handler;
    }

    public int getPort() {
        return this.port;
    }
}

