/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.wizard;

import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.env.CTATFileEntry;
import edu.cmu.hcii.ctat.wizard.CTATLMSConfiguration;
import edu.cmu.hcii.ctat.wizard.CTATPackageGeneratorBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class CTATSCORMHTML5PackageGenerator
extends CTATPackageGeneratorBase {
    private File tempIndex = null;
    private File tempManifest = null;
    private File tempPackage = null;
    private File tempCTATLib = null;
    private File tempCTATLoader = null;
    protected ArrayList<File> internalList = new ArrayList();
    private CTATLMSConfiguration LMSConfiguration = null;

    public CTATSCORMHTML5PackageGenerator(CTATLMSConfiguration aConfiguration) {
        super(aConfiguration);
        this.setClassName("CTATSCORMPackageGenerator");
        this.debug("CTATSCORMPackageGenerator ()");
        this.LMSConfiguration = aConfiguration;
    }

    @Override
    public CTATLMSConfiguration getLMSConfiguration() {
        return this.LMSConfiguration;
    }

    @Override
    public void setLMSConfiguration(CTATLMSConfiguration aConfiguration) {
        this.LMSConfiguration = aConfiguration;
    }

    private Boolean generateManifest() {
        this.debug("generateManifest ()");
        StringBuffer manifestBuffer = new StringBuffer();
        manifestBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        manifestBuffer.append("<manifest identifier=\"CQFaceism\" version=\"1.0\" xmlns=\"http://www.imsproject.org/xsd/imscp_rootv1p1p2\" xmlns:adlcp=\"http://www.adlnet.org/xsd/adlcp_rootv1p2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.imsproject.org/xsd/imscp_rootv1p1p2 imscp_rootv1p1p2.xsd http://www.imsglobal.org/xsd/imsmd_rootv1p2p1 imsmd_rootv1p2p1.xsd http://www.adlnet.org/xsd/adlcp_rootv1p2 adlcp_rootv1p2.xsd\">\n");
        manifestBuffer.append("<organizations default=\"CMU\">");
        manifestBuffer.append("<organization identifier=\"CMU\">");
        manifestBuffer.append("<title>CTAT Example SCORM Tutors</title>");
        manifestBuffer.append("<item identifier=\"problemset\" identifierref=\"ctat\" isvisible=\"true\">");
        manifestBuffer.append("<title>CTAT Example SCORM Tutors</title>");
        manifestBuffer.append("</item>");
        manifestBuffer.append("</organization>");
        manifestBuffer.append("</organizations>");
        manifestBuffer.append("<metadata>\n");
        manifestBuffer.append("<schema>ADL SCORM</schema>\n");
        manifestBuffer.append("<schemaversion>1.2</schemaversion>\n");
        manifestBuffer.append("<lom xmlns=\"http://www.imsglobal.org/xsd/imsmd_rootv1p2p1\">\n");
        manifestBuffer.append("</lom>\n");
        manifestBuffer.append("</metadata>\n");
        manifestBuffer.append("<resources>\n");
        int index = 0;
        for (CTATFileEntry file : this.LMSConfiguration.getFileList()) {
            this.debug("Registering: " + file.filePath + " in the manifest");
            if (file.filePath.equalsIgnoreCase("index.html")) {
                manifestBuffer.append("<resource adlcp:scormtype=\"sco\" href=\"" + file.filePath + "\" identifier=\"ctat\" type=\"webcontent\">\n");
            } else {
                if (!file.relativePath.isEmpty()) {
                    manifestBuffer.append("<resource adlcp:scormtype=\"sco\" href=\"" + file.filePath + "\" identifier=\"ctat-" + index + "\" type=\"webcontent\">\n");
                } else {
                    manifestBuffer.append("<resource adlcp:scormtype=\"sco\" href=\"" + file.relativePath + "/" + file.filePath + "\" identifier=\"ctat-" + index + "\" type=\"webcontent\">\n");
                }
                ++index;
            }
            if (file.getIsSystemEntry().booleanValue()) {
                manifestBuffer.append("<file href=\"" + file.filePath + "\"/>\n");
            } else {
                manifestBuffer.append("<file href=\"" + file.relativePath + "/" + file.filePath + "\"/>\n");
            }
            manifestBuffer.append("</resource>\n");
        }
        manifestBuffer.append("</resources>\n");
        manifestBuffer.append("</manifest>\n");
        return CTATLink.fManager.setContents(this.tempManifest.getAbsolutePath(), manifestBuffer.toString());
    }

    @Override
    public Boolean generatePackage(File outputZip) {
        this.debug("generatePackage ()");
        CTATLink.deployMobileAPI = CTATLink.MOBILEAPIDISABLED;
        this.addFileEntry("Templates/PackagingWizard/SCORM/", "adlcp_rootv1p2.xsd").setIsSystemEntry(true);
        this.addFileEntry("Templates/PackagingWizard/SCORM/", "dolmsfunctions.js").setIsSystemEntry(true);
        this.addFileEntry("Templates/PackagingWizard/SCORM/", "ims_xml.xsd").setIsSystemEntry(true);
        this.addFileEntry("Templates/PackagingWizard/SCORM/", "imscp_root1p1p2.xsd").setIsSystemEntry(true);
        this.addFileEntry("Templates/PackagingWizard/SCORM/", "imsmd_rootv1p2p1.xsd").setIsSystemEntry(true);
        this.addFileEntry("Templates/PackagingWizard/SCORM/", "scormfs.js").setIsSystemEntry(true);
        this.addFileEntry("Templates/PackagingWizard/SCORM/", "jquery.min.js").setIsSystemEntry(true);
        for (int i = 0; i < this.LMSConfiguration.getAssetValues().size(); ++i) {
            File tempEntry = this.LMSConfiguration.getAssetValues().get(i);
            this.addFileEntry(tempEntry, this.LMSConfiguration.getAssetBasePath());
        }
        try {
            this.tempManifest = File.createTempFile("scormmanifest", Long.toString(System.nanoTime()));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        CTATFileEntry manifestEntry = this.addFileEntry(this.tempManifest.getParent(), "imsmanifest.xml");
        manifestEntry.fullPath = this.tempManifest.getAbsolutePath();
        manifestEntry.setIsSystemEntry(true);
        this.tempFiles.add(this.tempManifest);
        try {
            this.tempPackage = File.createTempFile("package", Long.toString(System.nanoTime()));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        CTATFileEntry packageEntry = this.addFileEntry(this.tempPackage.getParent(), "package.xml");
        packageEntry.fullPath = this.tempPackage.getAbsolutePath();
        packageEntry.setIsSystemEntry(true);
        this.tempFiles.add(this.tempPackage);
        String manifest = this.createManifest();
        CTATLink.fManager.setContents(this.tempPackage.getAbsolutePath(), manifest);
        try {
            this.tempIndex = File.createTempFile("tempindex", Long.toString(System.nanoTime()));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        CTATFileEntry indexEntry = this.addFileEntry(this.tempIndex.getParent(), "index.html");
        indexEntry.fullPath = this.tempIndex.getAbsolutePath();
        indexEntry.setIsSystemEntry(true);
        this.tempFiles.add(this.tempIndex);
        if (!this.generateIndexFileSingle().booleanValue()) {
            return false;
        }
        if (!this.generateManifest().booleanValue()) {
            return false;
        }
        this.zipIt(outputZip.getAbsolutePath());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private Boolean generateIndexFileSingle() {
        this.debug("generateIndexFileSingle ()");
        String indexTemplate = CTATLink.fManager.getContents("Templates/PackagingWizard/SCORM/index-html5.html");
        File tempInterfaceLocation = new File(this.LMSConfiguration.getSwfLocationString());
        File tempBRDLocation = new File(this.LMSConfiguration.getBrdLocationString());
        this.addFileEntry(tempInterfaceLocation.getParent(), tempInterfaceLocation.getName());
        this.addFileEntry(tempBRDLocation.getParent(), tempBRDLocation.getName());
        String composite = indexTemplate.replaceFirst("<INTERFACEPATH>", "ctatcontent");
        composite = composite.replaceFirst("<PROBLEMPATH>", "");
        composite = composite.replaceFirst("<MODE>", "SCORM");
        composite = this.LMSConfiguration.getEngineTarget().equalsIgnoreCase("http") ? composite.replaceFirst("<CLIENTINDICATOR>", "client:") : composite.replaceFirst("<CLIENTINDICATOR>", "");
        composite = this.LMSConfiguration.getUseLogging() == true ? composite.replaceFirst("<LOGGING>", "ClientToLogServer") : composite.replaceFirst("<LOGGING>", "None");
        composite = composite.replaceFirst("<TSHOST>", CTATLink.hostName);
        composite = composite.replaceFirst("<TSPORT>", String.valueOf(CTATLink.tsPort));
        composite = composite.replaceFirst("<LOGURL>", CTATLink.datashopURL);
        composite = composite.replaceFirst("<DATASET>", CTATLink.datasetName);
        composite = composite.replaceFirst("<CONNECTION>", this.LMSConfiguration.getEngineTarget());
        CTATLink.fManager.setContents(this.tempIndex.getAbsolutePath(), composite);
        return true;
    }
}

