/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller.LMS;

import edu.cmu.pact.BehaviorRecorder.Controller.LMS.LMS_Provider;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.trace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JOptionPane;
import pact.CommWidgets.StudentInterfaceWrapper;

public class TutorShopLMS
implements LMS_Provider,
ActionListener {
    private CTAT_Controller controller;

    public TutorShopLMS(CTAT_Controller controller) {
        this.controller = controller;
        StudentInterfaceWrapper siw = this.getController().getStudentInterface();
        if (siw != null && siw.getWrapperSupport() != null) {
            siw.getWrapperSupport().addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (trace.getDebugCode("done")) {
            trace.out("done", "got done " + ae);
        }
        try {
            this.advanceProblem();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getController().getActiveWindow(), "Cannot advance to next problem:\n" + e.getMessage(), "Error Requesting Next Problem", 0);
        }
        this.getController().closeApplication(false);
    }

    @Override
    public void advanceProblem() throws Exception {
        BasicService bs = null;
        try {
            bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
        }
        catch (UnavailableServiceException e) {
            trace.err("Lookup failed: " + (Object)((Object)e));
            throw new Exception("Browser service unavailable: " + (Object)((Object)e), e);
        }
        URL url = null;
        boolean result = false;
        try {
            String curriculumServiceURL = System.getProperty("curriculum_service_url");
            String pslc = "https://pslc-qa.andrew.cmu.edu/tutorshop/TutorProblem2";
            String local = "javascript: hello()";
            StringBuffer sb = new StringBuffer(curriculumServiceURL != null ? curriculumServiceURL : "https://pslc-qa.andrew.cmu.edu/tutorshop/TutorProblem2");
            this.appendParameter(sb, "user_guid");
            this.appendParameter(sb, "auth_token");
            this.appendParameter(sb, "session_id");
            this.appendParameter(sb, "admit_code");
            this.appendParameter(sb, "student_problem_id");
            sb.append("&").append("cmd").append("=doneNext");
            if (trace.getDebugCode("done")) {
                trace.out("done", "url: " + sb);
            }
            url = new URL(sb.toString());
            if (trace.getDebugCode("done")) {
                JOptionPane.showMessageDialog(this.getController().getActiveWindow(), "url is " + url, "debug", 1);
            }
            if (result = bs.showDocument(url)) {
                this.getController().closeApplication(false);
                return;
            }
            throw new Exception("Unknown error invoking browser service.");
        }
        catch (MalformedURLException mue) {
            throw new Exception("Bad server address: " + mue, mue);
        }
        catch (Exception e) {
            throw new Exception("Error invoking browser service: " + e, e);
        }
    }

    private StringBuffer appendParameter(StringBuffer partialURL, String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue == null) {
            return partialURL;
        }
        if (partialURL.indexOf("?") < 0) {
            partialURL.append("?");
        } else {
            partialURL.append("&");
        }
        String enc = "UTF-8";
        try {
            partialURL.append(URLEncoder.encode(propertyName, "UTF-8"));
            partialURL.append("=");
            partialURL.append(URLEncoder.encode(propertyValue, "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            trace.err("fix the encoding: " + uee);
        }
        return partialURL;
    }

    private CTAT_Controller getController() {
        CTAT_Controller c = this.controller;
        return this.controller;
    }
}

