/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import pact.CommWidgets.JCommPicture;

public class EditLabelNameDialog
extends JDialog
implements ActionListener {
    private JFrame frame;
    private JCheckBox InvisibleCheckBox;
    private JButton replace;
    private JButton cancel;
    private JButton browse;
    private JTextField newLabelText;
    private JTextField iconImageFile;
    private String newLabel;
    private String imageName;
    private ImageIcon icon = null;
    private String currentDirectory;
    private boolean invisible;
    private String defaultnewLabelText = "";

    public EditLabelNameDialog(JFrame parent, String title, String oldLabel, String oldImageName, String currentDirectory, boolean invisible, boolean modal) {
        super(parent, title, modal);
        this.newLabel = oldLabel;
        this.currentDirectory = currentDirectory;
        JPanel mainPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.ipadx = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        mainPane.add((Component)new JLabel("New Text: "), c);
        this.newLabelText = new JTextField(this.newLabel, 25);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.newLabelText);
        this.newLabelText.setName("newLabelText");
        c.gridy = 1;
        c.gridwidth = 3;
        mainPane.add((Component)this.newLabelText, c);
        c.gridy = 2;
        mainPane.add((Component)new JLabel("Image File:"), c);
        this.browse = new JButton("Browse");
        this.browse.addActionListener(this);
        c.gridx = 3;
        c.gridy = 3;
        mainPane.add((Component)this.browse, c);
        this.iconImageFile = oldImageName != "" ? new JTextField(oldImageName, 25) : new JTextField(25);
        jTextUndoPacket = JUndo.makeTextUndoable(this.iconImageFile);
        this.iconImageFile.setName("iconImageFile");
        c.gridx = 0;
        c.gridwidth = 3;
        mainPane.add((Component)this.iconImageFile, c);
        this.InvisibleCheckBox = new JCheckBox("Invisible", null, invisible);
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 1;
        mainPane.add((Component)this.InvisibleCheckBox, c);
        this.replace = new JButton("Replace");
        this.replace.addActionListener(this);
        c.gridx = 2;
        c.gridy = 9;
        c.gridwidth = 1;
        mainPane.add((Component)this.replace, c);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        c.gridx = 3;
        mainPane.add((Component)this.cancel, c);
        this.setContentPane(mainPane);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.pack();
        this.setVisible(true);
    }

    public EditLabelNameDialog(JFrame parent, String title, String oldLabel, String oldImageName, String currentDirectory, boolean modal) {
        super(parent, title, modal);
        this.newLabel = oldLabel;
        this.currentDirectory = currentDirectory;
        JPanel mainPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.ipadx = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        mainPane.add((Component)new JLabel("New Text: "), c);
        this.newLabelText = new JTextField(this.newLabel, 25);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.newLabelText);
        this.newLabelText.setName("newLabelText");
        c.gridy = 1;
        c.gridwidth = 3;
        mainPane.add((Component)this.newLabelText, c);
        c.gridy = 2;
        mainPane.add((Component)new JLabel("Image File:"), c);
        this.browse = new JButton("Browse");
        this.browse.addActionListener(this);
        c.gridx = 3;
        c.gridy = 3;
        mainPane.add((Component)this.browse, c);
        this.iconImageFile = oldImageName != "" ? new JTextField(oldImageName, 25) : new JTextField(25);
        jTextUndoPacket = JUndo.makeTextUndoable(this.iconImageFile);
        this.iconImageFile.setName("iconImageFile");
        c.gridx = 0;
        c.gridwidth = 3;
        mainPane.add((Component)this.iconImageFile, c);
        this.InvisibleCheckBox = new JCheckBox("Invisible", null, this.invisible);
        this.replace = new JButton("Replace");
        this.replace.addActionListener(this);
        c.gridx = 2;
        c.gridy = 9;
        c.gridwidth = 1;
        mainPane.add((Component)this.replace, c);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        c.gridx = 3;
        mainPane.add((Component)this.cancel, c);
        this.setContentPane(mainPane);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.browse) {
            File f = DialogUtilities.chooseFile(this.currentDirectory, null, (FileFilter)new ImageFilter(), "Find files", "Open", this.frame);
            if (f != null) {
                this.iconImageFile.setText(f.getAbsolutePath());
            }
        } else if (ae.getSource() == this.cancel) {
            this.setVisible(false);
            this.dispose();
        } else if (ae.getSource() == this.replace) {
            String[] args = new String[2];
            args[0] = this.newLabelText.getText();
            String newLabel = this.newLabelText.getText();
            this.setNewLabel(this.newLabelText.getText());
            String newImageFileName = this.iconImageFile.getText();
            if (!newImageFileName.equals("")) {
                this.setImageName(newImageFileName);
                ImageIcon icon = this.createImageIcon(newImageFileName, "a pretty but meaningless splat");
                this.setIcon(icon);
            }
            this.setInvisible(this.InvisibleCheckBox.isSelected());
            this.setVisible(false);
            this.dispose();
        }
    }

    public String getNewLabel() {
        return this.newLabel;
    }

    public void setNewLabel(String newLabel) {
        this.newLabel = newLabel;
    }

    protected ImageIcon oldcreateImageIcon(String path, String description) {
        File imgFile = null;
        try {
            imgFile = new File(path);
            if (imgFile.exists()) {
                String newName = imgFile.getCanonicalPath().replace('\\', '/');
                return new ImageIcon(newName);
            }
            URL newName = Utils.getURL(path, this);
            return new ImageIcon(newName);
        }
        catch (Exception e) {
            trace.err("Can't find file " + path);
            return null;
        }
    }

    protected ImageIcon createImageIcon(String imageName, String description) {
        URL imageURL;
        block9: {
            if (imageName == null || imageName.length() < 1) {
                return null;
            }
            File imgFile = null;
            imageURL = null;
            try {
                if (!imageName.startsWith("file:") && (imgFile = new File(imageName)).exists()) {
                    return new ImageIcon(imageName);
                }
            }
            catch (Exception e) {
                trace.err("Can't find file " + imageName);
            }
            try {
                imageURL = new URL(imageName);
            }
            catch (MalformedURLException mal) {
                if (!trace.getDebugCode("log")) break block9;
                trace.out("log", "MalformedURLException message = " + mal.getMessage());
            }
        }
        if (imageURL == null) {
            imageURL = Utils.getURL(imageName, this);
        }
        if (imageURL == null) {
            imageURL = JCommPicture.class.getResource(imageName);
        }
        if (imageURL == null) {
            trace.err("Error: cannot find image " + new File(imageName).getAbsolutePath());
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
        ImageIcon imageIcon = new ImageIcon(image, imageName);
        return imageIcon;
    }

    protected ImageIcon savecreateImageIcon(String imageName, String description) {
        if (imageName == null || imageName.length() < 1) {
            return null;
        }
        File imgFile = null;
        URL imageURL = null;
        try {
            if (!imageName.startsWith("file:")) {
                imgFile = new File(imageName);
                if (imgFile.exists()) {
                    System.err.println("Creat icon from physical address");
                    return new ImageIcon(imageName);
                }
            } else {
                imageURL = new URL(imageName);
            }
        }
        catch (MalformedURLException mal) {
            if (trace.getDebugCode("log")) {
                trace.out("log", "MalformedURLException message = " + mal.getMessage());
            }
        }
        catch (Exception e) {
            trace.err("Can't find file " + imageName);
        }
        if (imageURL == null) {
            imageURL = Utils.getURL(imageName, this);
        } else {
            System.err.println("Creat icon from URL address");
        }
        if (imageURL == null) {
            imageURL = JCommPicture.class.getResource(imageName);
        } else {
            System.err.println("Creat icon from current directory");
        }
        if (imageURL == null) {
            trace.err("Error: cannot find image " + new File(imageName).getAbsolutePath());
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
        ImageIcon imageIcon = new ImageIcon(image, imageName);
        return imageIcon;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    private class ImageFilter
    extends FileFilter {
        private ImageFilter() {
        }

        @Override
        public boolean accept(File f) {
            String name = f.getName().toLowerCase();
            return f.isDirectory() || name.endsWith(".gif") || name.endsWith(".png") || name.endsWith(".jpg");
        }

        @Override
        public String getDescription() {
            return "Image Files";
        }
    }
}

