/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.BrdFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.Dialogs.SaveFileDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.TxtFilter;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class LoadProductionRulesDialog {
    private File fi;
    private BR_Controller controller;

    public LoadProductionRulesDialog(BR_Controller controller) {
        this.controller = controller;
        int clearRules = JOptionPane.showConfirmDialog(controller.getActiveWindow(), "Remove all existing production rules before loading?", "Load Production Rules", 1, 3);
        if (clearRules == 2) {
            return;
        }
        if (clearRules == 0) {
            controller.getRuleProductionCatalog().clear();
        }
        FileFilter brdOrTxtFilter = new FileFilter(){
            FileFilter brdFilter = new BrdFilter();
            FileFilter txtFilter = new TxtFilter();

            @Override
            public boolean accept(File f) {
                return this.brdFilter.accept(f) || this.txtFilter.accept(f);
            }

            @Override
            public String getDescription() {
                return "Behavior Graph files (.brd) or Production Rule lists (.txt)";
            }
        };
        String initialDirectory = SaveFileDialog.getProjectsDirectory(controller);
        this.fi = DialogUtilities.chooseFile(initialDirectory, null, brdOrTxtFilter, "Choose a file or a directory (of .brd files) to scan", "Open", 2, controller.getActiveWindow());
        if (this.fi == null) {
            return;
        }
        String fileType = ".brd";
        int fileCount = 0;
        int ctlrRuleCount = this.getNControllerRules();
        int fileRuleCount = 0;
        String message = "";
        if (this.fi.getPath().endsWith(".txt")) {
            fileType = ".txt";
            fileCount = 1;
            fileRuleCount = LoadProductionRulesDialog.loadProductionRules(this.fi.getPath(), controller);
            message = "Found " + fileRuleCount + " rules in " + this.fi.getPath() + ".";
        } else {
            List<File> brdFiles = Utils.findFiles(this.fi, new BrdFilter());
            fileCount = brdFiles.size();
            for (File brdFile : brdFiles) {
                fileRuleCount += LoadProductionRulesDialog.loadProblemRules(brdFile.getPath(), controller);
            }
            message = "Found " + fileRuleCount + " rules in" + (this.fi.getPath().endsWith(".brd") ? " " : " " + fileCount + " .brd file(s) in ") + this.fi.getPath() + ".";
        }
        int ruleGain = this.getNControllerRules() - ctlrRuleCount;
        JOptionPane.showMessageDialog(controller.getActiveWindow(), message + "\nLoaded net " + ruleGain + " new rules.", "Loaded production rules from " + fileType + " file" + (fileCount > 1 ? "s" : ""), 1);
    }

    private int getNControllerRules() {
        RuleProduction.Catalog ctlrRules = this.controller.getRuleProductionCatalog();
        return ctlrRules == null ? 0 : ctlrRules.size();
    }

    public static int loadProductionRules(String ruleFileFullPath, BR_Controller controller) {
        int ruleCount = 0;
        try {
            if (trace.getDebugCode("pm")) {
                trace.out("pm", "!!Loading file: " + ruleFileFullPath);
            }
            FileReader fr = new FileReader(ruleFileFullPath);
            if (trace.getDebugCode("pm")) {
                trace.out("pm", "FileReader fr: " + fr);
            }
            BufferedReader br = new BufferedReader(fr);
            if (trace.getDebugCode("pm")) {
                trace.out("pm", "BufferedReader br: " + br);
            }
            String s = br.readLine();
            int ruleProductionCount = Integer.valueOf(s);
            if (trace.getDebugCode("pm")) {
                trace.out("pm", "ruleProductionNumber = " + ruleProductionCount);
            }
            for (int i = 0; i < ruleProductionCount; ++i) {
                String tempRuleName = br.readLine();
                String tempProductionSet = br.readLine();
                RuleProduction tempRuleProduction = new RuleProduction(tempRuleName, tempProductionSet);
                if (trace.getDebugCode("pm")) {
                    trace.out("pm", "tempRuleProduction.ruleName = " + tempRuleProduction.getRuleName());
                }
                if ((s = br.readLine()).equals("save the hints for this RuleProduction")) {
                    s = br.readLine();
                    int hintsNumbers = Integer.valueOf(s);
                    for (int j = 0; j < hintsNumbers; ++j) {
                        String tempString = "";
                        s = br.readLine();
                        while (!s.equals("This Hint Message Done")) {
                            tempString = tempString + s + "\n";
                            s = br.readLine();
                        }
                        tempRuleProduction.addHintItem(tempString);
                    }
                    s = br.readLine();
                }
                StringBuffer pr = new StringBuffer();
                while (!s.equals("This Production Rule Done")) {
                    pr.append(s.trim()).append("\n");
                    s = br.readLine();
                }
                if (trace.getDebugCode("pm")) {
                    trace.out("pm", "tempRuleProduction.productionRule = " + pr);
                }
                tempRuleProduction.setProductionRule(pr.toString());
                controller.getRuleProductionCatalog().checkAddRuleProduction(tempRuleProduction);
                ++ruleCount;
            }
        }
        catch (FileNotFoundException e) {
            trace.errStack("loadProductionRules(" + ruleFileFullPath + ") error: file not found", e);
        }
        catch (IOException e) {
            trace.errStack("loadProductionRules(" + ruleFileFullPath + ") error reading file", e);
        }
        return ruleCount;
    }

    public static int loadProblemRules(String problemFullName, BR_Controller controller) {
        int ruleCount = 0;
        Vector<RuleProduction> problemRules = controller.getProblemStateReader().loadProblemRules(problemFullName);
        for (int i = 0; i < problemRules.size(); ++i) {
            RuleProduction tempRuleProduction = problemRules.elementAt(i);
            if (trace.getDebugCode("pm")) {
                trace.out("pm", "productionSet() = " + tempRuleProduction.getProductionSet() + ", ruleName() = " + tempRuleProduction.getRuleName());
            }
            controller.getRuleProductionCatalog().checkAddRuleProduction(tempRuleProduction);
            ++ruleCount;
        }
        return ruleCount;
    }
}

