/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageBuilder;
import edu.cmu.pact.BehaviorRecorder.Dialogs.ImmovableColumnColumnModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.StartStateModel;
import edu.cmu.pact.ctat.view.CtatFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import pact.CommWidgets.UniversalToolProxy;

public class UnmatchedSelectionsDialog
implements StartStateModel.Listener,
ProblemModelListener {
    public static final String SHOW_UNMATCHED_COMPONENT_REFERENCES = "Show Unmatched Component References";
    private static int threadId = 0;
    private final UniversalToolProxy utp;
    private volatile Dialog dialog = null;
    private volatile Thread creatingThread = null;
    private volatile boolean launchRequested = false;
    private volatile int rerunRequests = 0;
    private volatile boolean dialogReady = false;
    private Map<String, String> interfaceCompsMap = null;
    private Map<String, List<Reference>> obsoleteReferencesMap = new LinkedHashMap<String, List<Reference>>();
    private static final JButton defaultButton = new JButton(" "){

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    };
    private static ImageIcon dialogAvailableIcon = null;
    private static final int SS = 0;
    private static final int LINK = 1;
    private static final int NTBLS = 2;
    private static final String[] Sources;
    static final int SELECTION_COL = 0;
    static final int ACTION_COL = 1;
    static final int INPUT_COL = 2;
    static final int LINK_OR_REMOVED_COL = 3;
    static final String[][] columnLabels;
    private JButton okButton;
    private JButton cancelButton;

    public UnmatchedSelectionsDialog(UniversalToolProxy utp) {
        this.utp = utp;
        if (trace.getDebugCode("obssel")) {
            trace.out("obssel", "USD() utp " + trace.nh(utp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForUnmatchedReferences(final StartStateModel ssm) {
        if (trace.getDebugCode("startstate")) {
            trace.printStack("startstate", "USD.checkForUnmatchedRefs(" + ssm);
        }
        if (!this.utp.getStudentInterfaceConnectionStatus().isConnected()) {
            return;
        }
        if (this.utp.getController().getProblemModel() == null || this.utp.getController().getProblemModel().getStartNode() == null) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int runCount = 0;
                int exceptionCount = 0;
                while (true) {
                    ++runCount;
                    try {
                        if (trace.getDebugCode("obssel")) {
                            trace.out("obssel", "USD.checkForUnmatchedReferences() top of loop: rerunRequests " + UnmatchedSelectionsDialog.this.rerunRequests + ", runCount " + runCount + ", exceptionCount " + exceptionCount);
                        }
                        UnmatchedSelectionsDialog.this.rerunRequests = 0;
                        int[] refCounts = UnmatchedSelectionsDialog.this.buildObsoleteReferenceMap(UnmatchedSelectionsDialog.this.utp, ssm);
                        if (trace.getDebugCode("obssel")) {
                            trace.out("obssel", String.format("USD.checkForUnmatchedReferences() after build(): rerunRequests %d, runCount %d, map size %d, refCounts[%d,%d]", UnmatchedSelectionsDialog.this.rerunRequests, runCount, UnmatchedSelectionsDialog.this.obsoleteReferencesMap.size(), refCounts[0], refCounts[1]));
                        }
                    }
                    catch (Exception ie) {
                        trace.err("UnmatchedSelectionsDialog create thread " + Thread.currentThread() + " stopped on exception #" + ++exceptionCount + ":" + ie + ", cause " + ie.getCause());
                        if (UnmatchedSelectionsDialog.this.dialog != null) {
                            UnmatchedSelectionsDialog.this.dialog.dispose();
                        }
                        UnmatchedSelectionsDialog.this.dialog = null;
                    }
                    if (trace.getDebugCode("obssel")) {
                        trace.out("obssel", "USD.checkForUnmatchedReferences() bottom of loop: rerunRequests " + UnmatchedSelectionsDialog.this.rerunRequests + ", runCount " + runCount + ", exceptionCount " + exceptionCount);
                    }
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        if (UnmatchedSelectionsDialog.this.rerunRequests == 0) {
                            UnmatchedSelectionsDialog.this.utp.notifyUnmatchedSelectionsDialogAvailable(UnmatchedSelectionsDialog.this.hasDialog());
                            UnmatchedSelectionsDialog.this.creatingThread = null;
                            return;
                        }
                    }
                }
            }
        }, "UnmatchedSelectionsDialog" + ++threadId);
        UnmatchedSelectionsDialog unmatchedSelectionsDialog = this;
        synchronized (unmatchedSelectionsDialog) {
            if (trace.getDebugCode("obssel")) {
                trace.out("obssel", "OSD.checkForUnmatchedReferences() ssm " + trace.nh(ssm) + ", thread " + t);
            }
            this.creatingThread = t;
            t.start();
        }
    }

    public synchronized void launch() {
        if (trace.getDebugCode("obssel")) {
            trace.out("obssel", "OSD.launch() dialog " + trace.nh(this.dialog) + ", dialogReady " + this.dialogReady + ", creatingThread " + this.creatingThread);
        }
        if (this.creatingThread != null) {
            this.launchRequested = true;
        } else if (this.dialog != null) {
            if (this.dialog.isVisible()) {
                return;
            }
            if (!this.dialogReady) {
                this.launchRequested = true;
            }
        } else if (!this.hasDialog()) {
            JOptionPane.showMessageDialog(this.utp.getController().getCtatFrameController().getDockedFrame(), "Found no unmatched component references in the graph.", "No Unmatched Component References", 1);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CtatFrame parent = UnmatchedSelectionsDialog.this.utp.getController().getCtatFrameController().getDockedFrame();
                    UnmatchedSelectionsDialog.this.dialog = new Dialog(parent, UnmatchedSelectionsDialog.this.utp.getStartStateModel());
                    UnmatchedSelectionsDialog.this.dialog.setVisible(true);
                }
            });
        }
    }

    public boolean hasDialog() {
        return this.obsoleteReferencesMap.size() > 0;
    }

    public synchronized void setDialogReady(boolean dialogReady) {
        boolean launchRequested = this.launchRequested;
        this.launchRequested = false;
        this.dialogReady = dialogReady;
        this.utp.notifyUnmatchedSelectionsDialogAvailable(dialogReady);
        if (this.dialog != null && dialogReady && launchRequested && !this.dialog.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UnmatchedSelectionsDialog.this.dialog.setVisible(true);
                }
            });
        }
    }

    void recalculate() {
        this.setDialogReady(false);
        this.init(this.utp.getStartStateModel());
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent e) {
        if (trace.getDebugCode("obssel")) {
            trace.out("obssel", "OSD.problemModelEventOccurred() evt " + trace.nh(e) + ", source " + e.getSource());
        }
        this.init(this.utp.getStartStateModel());
    }

    @Override
    public void startStateReceived(EventObject evt) {
        if (trace.getDebugCode("obssel")) {
            trace.out("obssel", "OSD.startStateReceived() evt.source " + trace.nh(evt.getSource()));
        }
        this.init((StartStateModel)evt.getSource());
    }

    private void init(StartStateModel ssm) {
        if (trace.getDebugCode("obssel")) {
            trace.out("obssel", "USD.init(" + trace.nh(ssm) + ") dialog " + trace.nh(this.dialog) + ", .visible " + (this.dialog == null ? "null" : String.valueOf(this.dialog.isVisible())) + ", creatingThread " + this.creatingThread + ", rerunRequests " + this.rerunRequests);
        }
        if (this.interruptCreatingThread()) {
            return;
        }
        if (this.dialog != null) {
            if (this.dialog.isVisible()) {
                return;
            }
            this.setDialogReady(false);
            this.dialog.dispose();
            this.dialog = null;
        }
        this.checkForUnmatchedReferences(ssm);
    }

    private synchronized boolean interruptCreatingThread() {
        if (this.creatingThread == null) {
            return false;
        }
        ++this.rerunRequests;
        this.creatingThread.interrupt();
        return true;
    }

    private int[] buildObsoleteReferenceMap(UniversalToolProxy utp, StartStateModel ssm) {
        this.obsoleteReferencesMap.clear();
        int[] result = new int[2];
        this.interfaceCompsMap = ssm.getInterfaceComponentsMap();
        ProblemModel pm = utp.getController().getProblemModel();
        if (trace.getDebugCode("obssel")) {
            trace.out("obssel", "OSD.buildObsoleteReferenceMap() interfaceCompsMap size " + (this.interfaceCompsMap == null ? -1 : this.interfaceCompsMap.size()) + ", pm " + trace.nh(pm) + " name " + (pm == null ? "" : pm.getProblemName()));
        }
        if (this.interfaceCompsMap.size() < 1) {
            return result;
        }
        if (pm == null) {
            return result;
        }
        result[0] = 0;
        Iterator<MessageObject> pmIter = pm.startNodeMessagesIterator();
        while (pmIter.hasNext()) {
            result[0] = result[0] + this.checkAndAddReference(0, "Start State", pmIter.next());
        }
        result[1] = 0;
        if (pm.getExampleTracerGraph() != null) {
            for (ExampleTracerLink link : pm.getExampleTracerGraph().getLinks()) {
                EdgeData linkData = link.getEdge();
                result[1] = result[1] + this.checkAndAddReference(1, "Link " + link.getID(), PseudoTutorMessageBuilder.buildToolInterfaceAction(linkData.getSelection(), linkData.getAction(), linkData.getInput(), "DATA", null));
            }
        }
        return result;
    }

    private int checkAndAddReference(int ssOrLink, String location, MessageObject msg) {
        String key = null;
        int result = -1;
        List<Reference> refs = null;
        if (!"InterfaceAction".equalsIgnoreCase(msg.getMessageType())) {
            result = 0;
        } else {
            key = msg.getSelection0();
            if (null == key) {
                result = 0;
            } else if (this.interfaceCompsMap.containsKey(key)) {
                result = 0;
            } else {
                refs = this.obsoleteReferencesMap.get(key);
                if (refs == null) {
                    refs = new ArrayList<Reference>();
                    this.obsoleteReferencesMap.put(key, refs);
                }
                refs.add(new Reference(key, ssOrLink, location, msg));
                result = 1;
            }
        }
        if (trace.getDebugCode("obssel")) {
            trace.out("obssel", String.format("OSD.checkAndAddReference(%b, %s, %s) returns %d, %d refs, map size %d", ssOrLink, location, msg.summary(), result, refs == null ? -1 : refs.size(), this.obsoleteReferencesMap.size()));
        }
        return result;
    }

    public static JButton getDefaultButton() {
        return defaultButton;
    }

    public static JButton updateDialogAvailableButton(boolean enabled, JButton button) {
        button.setEnabled(enabled);
        if (enabled) {
            button.setText(null);
            button.setIcon(dialogAvailableIcon);
            button.setPressedIcon(dialogAvailableIcon);
            button.setDisabledIcon(dialogAvailableIcon);
            button.setDisabledSelectedIcon(dialogAvailableIcon);
            button.setToolTipText("<html>Click to display <i>Show Unmatched Component References</i><br />to find selections in the graph but not in the student interface.</html>");
        } else {
            button.setText(" ");
            button.setIcon(null);
            button.setPressedIcon(null);
            button.setDisabledIcon(null);
            button.setDisabledSelectedIcon(null);
            button.setToolTipText(null);
        }
        button.setVisible(enabled);
        return button;
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        this.dialog = null;
        this.cancelButton = null;
        this.okButton = null;
        if (this.interfaceCompsMap != null) {
            this.interfaceCompsMap.clear();
        }
        this.interfaceCompsMap = null;
        if (this.obsoleteReferencesMap != null) {
            this.obsoleteReferencesMap.clear();
        }
        this.obsoleteReferencesMap = null;
    }

    static {
        String path = "/" + UnmatchedSelectionsDialog.class.getPackage().getName().replace('.', '/');
        String baseName = "xmark.png";
        URL url = null;
        String fileName = path + "/" + baseName;
        try {
            url = UnmatchedSelectionsDialog.class.getResource(fileName);
            if (null != url) {
                dialogAvailableIcon = new ImageIcon(url);
            }
            if (trace.getDebugCode("obssel")) {
                trace.out("obssel", "ObsSelDialog: image \"" + fileName + "\"; url " + url + ", icon " + dialogAvailableIcon);
            }
        }
        catch (Exception e) {
            trace.errStack("Error loading image \"" + fileName + "\"; url " + url + ", icon " + dialogAvailableIcon, e);
        }
        Dimension size = new Dimension(dialogAvailableIcon.getIconWidth(), dialogAvailableIcon.getIconHeight());
        defaultButton.setPreferredSize(size);
        defaultButton.setHorizontalTextPosition(0);
        defaultButton.setIconTextGap(0);
        defaultButton.setBorderPainted(false);
        defaultButton.setFocusPainted(false);
        defaultButton.setBorder(null);
        defaultButton.setMargin(new Insets(0, 0, 0, 0));
        UnmatchedSelectionsDialog.updateDialogAvailableButton(false, defaultButton);
        Sources = new String[]{"StartState", "Links"};
        columnLabels = new String[][]{{"Selection"}, {"Action"}, {"Input"}, {"Remove?", "Link "}};
    }

    private class Dialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 201404241730L;
        protected static final String SELECT_COMPONENT = "SELECT_COMPONENT";
        private final StartStateModel ssm;
        private JComboBox obsoleteComponentsCB;
        private Component tablesPanel;
        private JPanel mainPanel;
        private int lineHeight;
        private int lineWidth;
        private int lineLength;
        private JPanel cbPanel;
        private JPanel buttonPanel;
        private int selectedIndex;
        private static final String labelHtmlTag0 = "<html><p><font face=\"sans-serif\"/>";
        private static final String labelHtmlTag1 = "</font></p></html>";

        public Dialog(final JFrame parent, StartStateModel ssm) {
            super((Frame)parent, UnmatchedSelectionsDialog.SHOW_UNMATCHED_COMPONENT_REFERENCES);
            this.cbPanel = null;
            this.buttonPanel = null;
            this.selectedIndex = 0;
            if (trace.getDebugCode("obssel")) {
                trace.out("obssel", "UnmatchedSelectionsDialog() constructor");
            }
            this.ssm = ssm;
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    int okCancel;
                    int nChanges = Dialog.this.commitChanges(false);
                    if (nChanges > 0 && (okCancel = JOptionPane.showConfirmDialog(parent, "You have unsaved changes to the list of unmatched components. Discard them?", "Discard Changes to Unmatched Components", 2, 2)) != 0) {
                        return;
                    }
                    UnmatchedSelectionsDialog.this.cancelButton.doClick();
                }
            });
            Point p = parent.getLocation();
            p.move(p.x + 60, p.y + 60);
            this.setLocation(p);
            int n = UnmatchedSelectionsDialog.this.obsoleteReferencesMap.size();
            String line1 = String.format("The graph contains references to %d component %s not in ", n, n > 1 ? "names that are" : "name that is");
            this.lineLength = line1.length();
            JLabel obsCompCaption = new JLabel(labelHtmlTag0 + line1 + "the student interface. This can result from modifying components in the interface after the graph was created or from accidentally opening a graph built for a different interface. Select a component name from this drop-down list to find where it is referenced in the graph." + labelHtmlTag1);
            obsCompCaption.setAlignmentX(0.5f);
            FontMetrics fm = obsCompCaption.getFontMetrics(new Font("SansSerif", 0, 12));
            this.lineWidth = fm.stringWidth(line1);
            this.lineHeight = fm.getHeight();
            int markup = labelHtmlTag0.length() + labelHtmlTag1.length();
            obsCompCaption.setPreferredSize(new Dimension(this.lineWidth, (obsCompCaption.getText().length() - markup + this.lineLength - 1) / this.lineLength * this.lineHeight));
            obsCompCaption.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            obsCompCaption.setOpaque(true);
            DefaultComboBoxModel<String> obsCompModel = new DefaultComboBoxModel<String>(UnmatchedSelectionsDialog.this.obsoleteReferencesMap.keySet().toArray(new String[0]));
            this.obsoleteComponentsCB = new JComboBox(obsCompModel){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.obsoleteComponentsCB.setFont(new Font("Dialog", 0, 12));
            this.obsoleteComponentsCB.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.obsoleteComponentsCB.setName("obsoleteComponentComboBox");
            this.obsoleteComponentsCB.setToolTipText("Click on a component name to see where it is referenced in the graph.");
            this.obsoleteComponentsCB.setSelectedIndex(this.selectedIndex);
            this.cbPanel = new JPanel(new GridBagLayout());
            this.cbPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 4, 4, 4), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Unmatched Component Names", 4, 2, new Font("SansSerif", 1, 12)), BorderFactory.createEmptyBorder(0, 6, 4, 6))));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.fill = 1;
            c.anchor = 23;
            this.cbPanel.add((Component)obsCompCaption, c);
            c.gridy = 1;
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.fill = 0;
            c.anchor = 10;
            this.cbPanel.add((Component)this.obsoleteComponentsCB, c);
            UnmatchedSelectionsDialog.this.okButton = new JButton("OK");
            UnmatchedSelectionsDialog.this.okButton.setEnabled(false);
            UnmatchedSelectionsDialog.this.okButton.addActionListener(this);
            UnmatchedSelectionsDialog.this.cancelButton = new JButton("Cancel");
            UnmatchedSelectionsDialog.this.cancelButton.addActionListener(this);
            this.buttonPanel = new JPanel(new GridLayout(1, 2)){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.buttonPanel.add(UnmatchedSelectionsDialog.this.okButton);
            this.buttonPanel.add(UnmatchedSelectionsDialog.this.cancelButton);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
            this.mainPanel.add(this.cbPanel);
            this.tablesPanel = this.createReferenceTablesPanel(this.selectedIndex);
            this.mainPanel.add(this.tablesPanel);
            this.mainPanel.add(this.buttonPanel);
            this.getContentPane().add(this.mainPanel);
            this.pack();
            this.obsoleteComponentsCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Dialog.this.selectedIndex = Dialog.this.obsoleteComponentsCB.getSelectedIndex();
                    Object selectedItem = Dialog.this.obsoleteComponentsCB.getSelectedItem();
                    if (selectedItem == null) {
                        return;
                    }
                    Dialog.this.rebuildTables();
                    UnmatchedSelectionsDialog.this.utp.getController().getServer().getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", Dialog.SELECT_COMPONENT, Dialog.this.obsoleteComponentsCB.getSelectedItem().toString());
                }
            });
            UnmatchedSelectionsDialog.this.setDialogReady(true);
        }

        private void rebuildTables() {
            final Component newTblsPanel = this.createReferenceTablesPanel(this.selectedIndex);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Dialog.this.mainPanel.remove(Dialog.this.buttonPanel);
                    Dialog.this.mainPanel.remove(Dialog.this.tablesPanel);
                    Dialog.this.tablesPanel = newTblsPanel;
                    Dialog.this.mainPanel.add(Dialog.this.tablesPanel);
                    Dialog.this.mainPanel.add(Dialog.this.buttonPanel);
                    Dialog.this.pack();
                }
            });
        }

        private Component createReferenceTablesPanel(int selectedIndex) {
            String selection = this.obsoleteComponentsCB.getItemAt(selectedIndex).toString();
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            JLabel[] captions = new JLabel[]{new JLabel("<html><p><font face=\"sans-serif\"/>Click the check boxes below to remove start-state information from the graph for component <b>" + selection + "</b>, which may have been removed or renamed. After removing references, you can re-demonstrate the start state for the problem as needed." + labelHtmlTag1), new JLabel("<html><p><font face=\"sans-serif\"/>See the Link column below to find links in the graph for component <b>" + selection + "</b>. Revise the links if the component was renamed; delete the links if the component was removed from the interface." + labelHtmlTag1)};
            String[] titles = new String[]{"References in the Start State", "References in Links "};
            int i = 0;
            while (i < 2) {
                Box box = new Box(3);
                ReferenceTableModel refTblModel = new ReferenceTableModel(selection, i);
                captions[i].setName("CaptionForTableOfReferencesFrom" + Sources[i]);
                captions[i].setAlignmentX(0.5f);
                captions[i].setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
                int markup = labelHtmlTag0.length() + labelHtmlTag1.length() + "<b></b>".length();
                captions[i].setPreferredSize(new Dimension(this.lineWidth, (captions[i].getText().length() - markup + this.lineLength - 1) / this.lineLength * this.lineHeight));
                captions[i].setOpaque(true);
                JTable refTbl = new JTable(refTblModel, new ImmovableColumnColumnModel());
                refTbl.setAutoCreateColumnsFromModel(true);
                refTbl.setName("TableOfReferencesFrom" + Sources[i]);
                refTbl.setAutoResizeMode(4);
                refTbl.setSelectionMode(0);
                JScrollPane refTblPane = new JScrollPane(refTbl);
                refTblPane.setPreferredSize(new Dimension(250, 100));
                refTblPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 4, 0, 4))));
                box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 0, 2), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), titles[i], 4, 2, new Font("SansSerif", 1, 12))));
                box.add(captions[i]);
                box.add(refTblPane);
                c.gridy = i++;
                panel.add((Component)box, c);
            }
            panel.setOpaque(true);
            return panel;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int nChanges = 0;
            if ("OK".equalsIgnoreCase(evt.getActionCommand())) {
                nChanges = this.commitChanges(true);
            } else if (!"Cancel".equalsIgnoreCase(evt.getActionCommand())) {
                return;
            }
            this.dispose();
            UnmatchedSelectionsDialog.this.dialog = null;
            UnmatchedSelectionsDialog.this.recalculate();
        }

        private int commitChanges(boolean execute) {
            LinkedHashSet<MessageObject> changes = new LinkedHashSet<MessageObject>();
            for (Map.Entry entry : UnmatchedSelectionsDialog.this.obsoleteReferencesMap.entrySet()) {
                for (Reference ref : (List)entry.getValue()) {
                    if (!ref.removed) continue;
                    changes.add(ref.msg);
                }
            }
            if (execute) {
                this.ssm.applyEditsToProblemModel(UnmatchedSelectionsDialog.this.utp.getController().getProblemModel(), changes, "Remove unmatched selections");
            }
            return changes.size();
        }

        class ReferenceTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 201404250229L;
            final List<Reference> refs;
            final int ssOrLink;

            ReferenceTableModel(String key, int ssOrLink) {
                this.ssOrLink = ssOrLink;
                this.refs = new ArrayList<Reference>();
                List allRefs = (List)UnmatchedSelectionsDialog.this.obsoleteReferencesMap.get(key);
                if (allRefs == null || allRefs.isEmpty()) {
                    return;
                }
                for (Reference ref : allRefs) {
                    if (ref.ssOrLink != ssOrLink) continue;
                    this.refs.add(ref);
                }
            }

            @Override
            public String getColumnName(int col) {
                if (col == 3) {
                    return columnLabels[col][this.ssOrLink];
                }
                return columnLabels[col][0];
            }

            @Override
            public int getRowCount() {
                return this.refs.size();
            }

            @Override
            public int getColumnCount() {
                return columnLabels.length;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 3 && this.refs.get((int)row).ssOrLink == 0;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                if (col != 3 || this.refs.get((int)row).ssOrLink != 0) {
                    return;
                }
                this.refs.get(row).setRemoved(value);
            }

            @Override
            public Object getValueAt(int row, int col) {
                Reference ref = this.refs.get(row);
                switch (col) {
                    case 0: {
                        return ref.selection;
                    }
                    case 1: {
                        return ref.action;
                    }
                    case 2: {
                        return ref.input;
                    }
                    case 3: {
                        return this.ssOrLink == 0 ? Boolean.valueOf(ref.removed) : ref.location;
                    }
                }
                throw new IllegalArgumentException("Invalid column " + col + " to ReferenceTableModel.getValueAt(); should be in range 0-" + (this.getColumnCount() - 1));
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return String.class;
                    }
                    case 3: {
                        return this.ssOrLink == 0 ? Boolean.class : String.class;
                    }
                }
                throw new IllegalArgumentException("Invalid column " + col + " to ReferenceTableModel.getColumnClass(); should be in range 0-" + (this.getColumnCount() - 1));
            }
        }
    }

    class Reference {
        final int ssOrLink;
        final String key;
        final String location;
        final String selection;
        final String action;
        final String input;
        boolean removed = false;
        MessageObject msg = null;

        Reference(String key, int ssOrLink, String location, MessageObject msg) {
            this.key = key;
            this.ssOrLink = ssOrLink;
            this.location = location;
            this.selection = msg.getSelection0();
            this.action = msg.getAction0();
            this.input = msg.getInput0();
            this.msg = msg;
        }

        public void setRemoved(Object value) {
            if (value == null) {
                this.removed = false;
            } else {
                this.removed = Boolean.parseBoolean(value.toString());
                UnmatchedSelectionsDialog.this.okButton.setEnabled(true);
            }
        }
    }
}

